---
navigation:
  parent: crazyae2addons_index.md
  title: CPU优先级
  icon: crazyae2addons:cpu_prio_tuner
categories:
  - Monitoring and Automation
item_ids:
  - crazyae2addons:cpu_prio_tuner
---

# 合成CPU优先级

在**应用能源2（Applied Energistics 2，AE2）**中，如果ME网络中有多个**合成CPU**，那么通常来说ME系统会为合成任务自动分配CPU。默认情况下，这种挑选过程相对来说比较随意⸺哪个CPU当前正好空闲，就让哪个CPU来处理任务。

某些情况下，这种挑选方式会产生预期之外的结果；尤其是需要CPU优先完成自身任务时，或是需防止CPU中物品被其他合成任务“夺取”时。

---

## 为什么需要优先级？

安装此附属后，每个合成CPU都可分配一个**优先级**。

* **高优先级**的CPU会在低优先级CPU之前收到所需物品。
* 如果有两个CPU在等待同种物品，**高优先级**的会首先拿到。
* 可借此控制网络中CPU竞争物品的方式。

此特性在如下情况中很有用处：

* 需要一台&zwnj;**“主要”CPU**&zwnj;来处理重要配方，优先于其他小型CPU。
* 需要**分离任务**（如避免自动合成CPU干扰批量合成CPU）。
* 希望合成工作流更可控，而非完全依赖于随机分配。

---

## 如何设置CPU优先级

1. 合成并手持**CPU优先级调整器**（用于配置CPU结构优先级的工具）。
2. 右击需配置的**合成CPU结构**中的方块。
3. 对应的配置界面会打开。
4. 在优先级输入框中输入数字：
  * 数字越大，**优先级越高**。
  * 数字越小或越负，**优先级越低**。
5. 按下**保存/Save**。

新设置的优先级会直接存储在CPU结构中。可按此步骤为其他CPU设置优先级。

---

## 提示

* 如果所有CPU的优先级都一致，那么挑选方式就会和AE2原版一致⸺随机分配。
* 主要CPU使用**较大的正数**，次要的使用**负数或较小的正数**。
* 可随意修改CPU的优先级，而无需破坏或重新进行搭建。
