---
navigation:
  parent: crazyae2addons_index.md
  title: 显示监视器
  icon: crazyae2addons:display_monitor
categories:
  - Monitoring and Automation
item_ids:
  - crazyae2addons:display_monitor
---

# 显示监视器⸺用户指南

![显示监视器](../img/display.png)

这篇指南会介绍Crazy AE2 Addons中**显示监视器**子部件的安装、配置、文本格式化、多方块搭建等的方法。

---

## 显示监视器是什么

显示监视器是可以放置在线缆某一面上的平板型应用能源2（AE2）子部件。激活后，它可以渲染文本（支持简单的格式和颜色），也可**监控ME数据控制器中的变量**以实时显示其值。

**能耗：**空闲能耗极少（约1 AE/t）。监视器只有在**接受供能并启用**时才会进行渲染。

---

## 快速入门

1. 将显示监视器**放置**在线缆上。
2. **右击**打开**显示菜单**。
3. 文本框内可输入显示信息（见下方格式化代码）。示例：
   - **系统在线**&nl* 合成进行中&nl* 库存：&s^minecraft:iron_ingot
4. **应用/保存**。监视器会在有能量供应时显示文本。

---


## ME库存组件（库存自动计数）

可以使用特殊组件显示**ME库存中物品当前的数量**：

**语法**

`&s^命名空间:物品`
`&s^命名空间:物品%N`

* `&s^minecraft:oak_log`：显示ME网络中该物品的总量。
* `%N`可选，用于缩放显示量；缩放比为**10^N**，有舍入：

  * `%1` → 十
  * `%2` → 百
  * `%3` → 千
  * `%4` → 万，以此类推。

**示例**

| 组件                        | 意义                  | 示例值（假设网络中有64个）  |
| --------------------------- | --------------------- | --------------------------- |
| `&s^minecraft:oak_log`      | 精确数值              | `64`                        |
| `&s^minecraft:oak_log%1`    | amount / 10（舍入）   | `6`                         |
| `&s^minecraft:oak_log%2`    | amount / 100（舍入）  | 120 → `1`，150 → `2`      |
| `&s^minecraft:iron_ingot%3` | amount / 1000（舍入） | 小于500为`0`，大于等于为`1` |

> 可以连用库存组件和颜色等其他格式化代码，示例：
> `&b101010&cE0E0E0**Logs:** &s^minecraft:oak_log%3 k`

## 文本格式化速查表

显示监视器的文本框内可以使用多种简单的文本格式。

### 换行

* 在需换行处按下Enter或输入&nl。

### 行内样式（类Markdown）

* `**粗体**` → 粗体
* `*斜体*` → 斜体
* `__下划线__` → 下划线
* `~~删除线~~` → 删除线

### 颜色

* **文本颜色**：`&cRRGGBB`（十六进制）
    * 示例：`&cFF0000`会让其后方的文本变为红色，直至再次更改颜色或换行。
* **背景颜色**：`&bRRGGBB`（十六进制）
    * 示例：`&b001122`会将面板的整个背景变为不透明的深蓝色。
    * 背景颜色在显示监视器阵列中全局有效（文本中任意一处设置即可）。

### 项目号与缩进

* 行首为`* `或`- `代表项目点号`•`。
* 行首有任意数量个`>>`代表缩进记号。

---

## 变量（实时值）

在文本中使用`&名称`可显示**实时变量**。监视器会自动监控各变量，并显示**ME数据控制器**最新推送的值。

* 语法: `&`后跟字母/数字/下划线（如`&A1`）。
* 变量名对**大小写敏感**。
* 网络中需存在**Crazy AE2 Addons的ME数据控制器**，需有足够的变量容量，并且数据流（节点）需能产生对应的值。

**示例**

&b101010&cE0E0E0**库存**&nl
铁：&iron&nl
金：&gold&nl
电路板：&circuits

> 修改文本或网络/控制器的状态发生变化时，监视器会自动监控变量或解除对变量的监控。

---

## 字号和自动缩放

* **自动缩放**：将字号设为**0**（或保留默认值）。文本会缩放至填满所有可用区域。
* **固定字号**：将字号设为**正数**，各监视器中文本都会使用该字号。

> 固定字号的文本若无法完全显示，则会进行截断。应使用`&nl`换行或缩小字号。

---

## 监视器墙（连接模式）

墙面上（朝向东/西/南/北）的多个监视器可连接成**单个巨型显示监视器**。

### 需求

* 所有显示监视器必须：

    * 处于**同一个墙面**（同侧面/朝向）。
    * **有能量供应且启用**。
    * 启用**连接模式（Linked Mode）**（需在各监视器的菜单中切换）。
* 监视器应当形成**实心长方形**（无间隙和缺口）。
* **天花板和地板**监视器（上/下）**不会**连接成墙，而只会各自显示。

### 渲染原理

* 监视器墙中只有**一个**监视器实际渲染文本，其余的只会提供显示空间。
* 渲染器会在内部选定**原点**位置（通常是监视器墙的**左上角**）。
* 向**该监视器**输入文本，即可在整面墙中渲染（自动缩放会识别整面墙）。

> 如果编辑后未能显示文本，应尝试编辑长方形**左上角**的监视器。

### 搭建步骤

1. 在墙面上按长方形放置监视器。
2. 向其后方的线缆供能。
3. 启用各面板的**连接模式**。
4. 打开**左上角**监视器的界面，编辑文本和字号。

---

## 放置与朝向

* 放置在墙上（东/西/南/北）：文本遵循墙面的朝向。文本的渲染方向固定。
* 放置在地板/天花板上（上/下）：监视器会使用放置时玩家的**朝向**，破坏后更改玩家朝向再放置即可更改。

---

## 提示与问题检修

* **未显示文本**：确保监视器**有能量供应且启用**；对于监视器墙而言，应编辑长方形**左上角**的监视器。
* **变量显示为`&名称`**：网络中无**ME数据控制器**，或变量容量耗尽，或变量尚未建立。正确设置控制器或节点即可，监视器会自动进行监控。
* **监视器墙未连接**：检查是否每个监视器的**连接模式**都已启用，是否所有监视器处于**同一个墙面**，形状是否是无空隙的**长方形**。
* **文本被截断**：切换至**自动缩放（0字号）**，或减小所固定的字号。较长的行可用`&nl`换行。

---

## 参考表（所有组件）

* `&nl`：换行
* `&cRRGGBB`：文本颜色（影响后续文本）
* `&bRRGGBB`：背景颜色（影响整个面板）
* `&名称`：变量占位符（接受字母/数字/下划线）
* 行首为`* `或`- `：项目点号`•`
* 行首为`>>`（可重复出现）：缩进
* `**粗体**`、`*斜体*`、`__下划线__`、`~~删除线~~`
* `&s^命名空间:物品`：ME网络物品计数
* `&s^命名空间:物品%N`：ME网络物品计数，按10^N缩放，带舍入

---

祝建筑愉快！如果对其他的格式化组件有想法和意见建议，欢迎来Discord分享（链接见Wiki主页），以便考虑在将来的版本里把它们加入游戏。
