/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.adapters.skins.ComboBoxListViewSkin;
import com.jfoenix.concurrency.JFXUtilities;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.transitions.CachedTransition;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransition;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.scene.transform.Scale;
import javafx.util.Duration;

public class JFXComboBoxListViewSkin<T>
extends ComboBoxListViewSkin<T> {
    private boolean invalid = true;
    private StackPane customPane;
    private StackPane line = new StackPane();
    private StackPane focusedLine = new StackPane();
    private Text promptText = new Text();
    private double initScale = 0.05;
    private Scale scale = new Scale(this.initScale, 1.0);
    private Timeline linesAnimation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.scale.xProperty(), (Object)this.initScale, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.focusedLine.opacityProperty(), (Object)0, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)1.0), new KeyValue[]{new KeyValue((WritableValue)this.focusedLine.opacityProperty(), (Object)1, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)160.0), new KeyValue[]{new KeyValue((WritableValue)this.scale.xProperty(), (Object)1, Interpolator.EASE_BOTH)})});
    private ParallelTransition transition;
    private CachedTransition promptTextUpTransition;
    private CachedTransition promptTextDownTransition;
    private CachedTransition promptTextColorTransition;
    private Scale promptTextScale = new Scale(1.0, 1.0, 0.0, 0.0);
    private Paint oldPromptTextFill;
    protected final ObjectProperty<Paint> promptTextFill = new SimpleObjectProperty((Object)Color.valueOf((String)"#B2B2B2"));
    private BooleanBinding usePromptText = Bindings.createBooleanBinding(this::usePromptText, (Observable[])new Observable[]{((JFXComboBox)this.getSkinnable()).valueProperty(), ((ComboBoxBase)this.getSkinnable()).promptTextProperty()});

    public JFXComboBoxListViewSkin(JFXComboBox<T> comboBox) {
        super(comboBox);
        this.getArrowButton().setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, null, null)}));
        this.promptText.textProperty().bind((ObservableValue)comboBox.promptTextProperty());
        this.promptText.fillProperty().bind(this.promptTextFill);
        this.promptText.getStyleClass().addAll((Object[])new String[]{"text", "prompt-text"});
        this.promptText.getTransforms().add((Object)this.promptTextScale);
        if (!comboBox.isLabelFloat()) {
            this.promptText.visibleProperty().bind((ObservableValue)this.usePromptText);
        }
        this.customPane = new StackPane();
        this.customPane.setMouseTransparent(true);
        this.customPane.getStyleClass().add((Object)"combo-box-button-container");
        this.customPane.backgroundProperty().bindBidirectional((Property)((ComboBoxBase)this.getSkinnable()).backgroundProperty());
        this.customPane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, null, null)}));
        this.customPane.getChildren().add((Object)this.promptText);
        this.getChildren().add(0, (Object)this.customPane);
        StackPane.setAlignment((Node)this.promptText, (Pos)Pos.CENTER_LEFT);
        this.line.getStyleClass().add((Object)"input-line");
        this.focusedLine.getStyleClass().add((Object)"input-focused-line");
        this.getChildren().add((Object)this.line);
        this.getChildren().add((Object)this.focusedLine);
        this.line.setPrefHeight(1.0);
        this.line.setTranslateY(1.0);
        this.line.setManaged(false);
        this.line.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((JFXComboBox)this.getSkinnable()).getUnFocusColor(), CornerRadii.EMPTY, Insets.EMPTY)}));
        if (((ComboBoxBase)this.getSkinnable()).isDisabled()) {
            this.line.setBorder(new Border(new BorderStroke[]{new BorderStroke(((JFXComboBox)this.getSkinnable()).getUnFocusColor(), BorderStrokeStyle.DASHED, CornerRadii.EMPTY, new BorderWidths(1.0))}));
            this.line.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, CornerRadii.EMPTY, Insets.EMPTY)}));
        }
        this.focusedLine.setPrefHeight(2.0);
        this.focusedLine.setTranslateY(0.0);
        this.focusedLine.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((JFXComboBox)this.getSkinnable()).getFocusColor(), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.focusedLine.setOpacity(0.0);
        this.focusedLine.getTransforms().add((Object)this.scale);
        this.focusedLine.setManaged(false);
        if (comboBox.isEditable()) {
            comboBox.getEditor().setStyle("-fx-background-color:TRANSPARENT;-fx-padding: 4 0 4 0");
            comboBox.getEditor().promptTextProperty().unbind();
            comboBox.getEditor().setPromptText(null);
            comboBox.getEditor().textProperty().addListener((o, oldVal, newVal) -> {
                this.usePromptText.invalidate();
                comboBox.setValue(this.getConverter().fromString(newVal));
            });
        }
        comboBox.labelFloatProperty().addListener((o, oldVal, newVal) -> {
            if (newVal.booleanValue()) {
                this.promptText.visibleProperty().unbind();
                JFXUtilities.runInFX(() -> this.createFloatingAnimation());
            } else {
                this.promptText.visibleProperty().bind((ObservableValue)this.usePromptText);
            }
            this.createFocusTransition();
        });
        comboBox.focusColorProperty().addListener((o, oldVal, newVal) -> {
            if (newVal != null) {
                this.focusedLine.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(newVal, CornerRadii.EMPTY, Insets.EMPTY)}));
                if (((JFXComboBox)this.getSkinnable()).isLabelFloat()) {
                    this.promptTextColorTransition = new CachedTransition((Node)this.customPane, new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)1300.0), new KeyValue[]{new KeyValue(this.promptTextFill, newVal, Interpolator.EASE_BOTH)})})){
                        {
                            this.setDelay(Duration.millis((double)0.0));
                            this.setCycleDuration(Duration.millis((double)160.0));
                        }

                        @Override
                        protected void starting() {
                            super.starting();
                            JFXComboBoxListViewSkin.this.oldPromptTextFill = (Paint)JFXComboBoxListViewSkin.this.promptTextFill.get();
                        }
                    };
                    this.transition = null;
                }
            }
        });
        comboBox.unFocusColorProperty().addListener((o, oldVal, newVal) -> {
            if (newVal != null) {
                this.line.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(newVal, CornerRadii.EMPTY, Insets.EMPTY)}));
            }
        });
        comboBox.disabledProperty().addListener((o, oldVal, newVal) -> {
            this.line.setBorder(newVal != false ? new Border(new BorderStroke[]{new BorderStroke(((JFXComboBox)this.getSkinnable()).getUnFocusColor(), BorderStrokeStyle.DASHED, CornerRadii.EMPTY, new BorderWidths(this.line.getHeight()))}) : Border.EMPTY);
            this.line.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)(newVal != false ? Color.TRANSPARENT : ((JFXComboBox)this.getSkinnable()).getUnFocusColor()), CornerRadii.EMPTY, Insets.EMPTY)}));
        });
        comboBox.focusedProperty().addListener((o, oldVal, newVal) -> {
            if (newVal.booleanValue()) {
                this.focus();
            } else {
                this.unFocus();
            }
        });
        comboBox.valueProperty().addListener((o, oldVal, newVal) -> {
            if (((JFXComboBox)this.getSkinnable()).isLabelFloat()) {
                if (newVal == null || newVal.toString().isEmpty()) {
                    this.animateFloatingLabel(false);
                } else {
                    this.animateFloatingLabel(true);
                }
            }
        });
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        super.layoutChildren(x, y, w, h);
        this.customPane.resizeRelocate(x, y, w, h);
        if (this.invalid) {
            Text javaPromptText;
            this.invalid = false;
            if (!((ComboBoxBase)this.getSkinnable()).isEditable() && (javaPromptText = (Text)super.getDisplayNode().lookup(".text")) != null) {
                this.promptTextFill.set((Object)javaPromptText.getFill());
            }
            this.createFloatingAnimation();
            if (((ComboBoxBase)this.getSkinnable()).getValue() != null) {
                this.animateFloatingLabel(true);
            }
        }
        this.focusedLine.resizeRelocate(x, ((ComboBoxBase)this.getSkinnable()).getHeight(), w, this.focusedLine.prefHeight(-1.0));
        this.line.resizeRelocate(x, ((ComboBoxBase)this.getSkinnable()).getHeight(), w, this.line.prefHeight(-1.0));
        this.scale.setPivotX(w / 2.0);
    }

    private void createFloatingAnimation() {
        this.promptTextUpTransition = new CachedTransition((Node)this.customPane, new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)1300.0), new KeyValue[]{new KeyValue((WritableValue)this.promptText.translateYProperty(), (Object)(-this.customPane.getHeight() + 6.05), Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.promptTextScale.xProperty(), (Object)0.85, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.promptTextScale.yProperty(), (Object)0.85, Interpolator.EASE_BOTH)})})){
            {
                this.setDelay(Duration.millis((double)0.0));
                this.setCycleDuration(Duration.millis((double)240.0));
            }
        };
        this.promptTextColorTransition = new CachedTransition((Node)this.customPane, new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)1300.0), new KeyValue[]{new KeyValue(this.promptTextFill, (Object)((JFXComboBox)this.getSkinnable()).getFocusColor(), Interpolator.EASE_BOTH)})})){
            {
                this.setDelay(Duration.millis((double)0.0));
                this.setCycleDuration(Duration.millis((double)160.0));
            }

            @Override
            protected void starting() {
                super.starting();
                JFXComboBoxListViewSkin.this.oldPromptTextFill = (Paint)JFXComboBoxListViewSkin.this.promptTextFill.get();
            }
        };
        this.promptTextDownTransition = new CachedTransition((Node)this.customPane, new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)1300.0), new KeyValue[]{new KeyValue((WritableValue)this.promptText.translateYProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.promptTextScale.xProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.promptTextScale.yProperty(), (Object)1, Interpolator.EASE_BOTH)})})){
            {
                this.setDelay(Duration.millis((double)0.0));
                this.setCycleDuration(Duration.millis((double)240.0));
            }
        };
        this.promptTextDownTransition.setOnFinished(finish -> {
            this.promptText.setTranslateY(0.0);
            this.promptTextScale.setX(1.0);
            this.promptTextScale.setY(1.0);
        });
    }

    private void focus() {
        if (this.transition == null) {
            this.createFocusTransition();
        }
        this.transition.play();
    }

    private void animateFloatingLabel(boolean up) {
        if (this.promptText == null) {
            Platform.runLater(() -> this.animateFloatingLabel(up));
        } else {
            if (this.transition != null) {
                this.transition.stop();
                this.transition.getChildren().remove((Object)this.promptTextUpTransition);
                this.transition.getChildren().remove((Object)this.promptTextColorTransition);
                this.transition = null;
            }
            if (up && this.promptText.getTranslateY() == 0.0) {
                this.promptTextDownTransition.stop();
                this.promptTextUpTransition.play();
                if (((ComboBoxBase)this.getSkinnable()).isFocused()) {
                    this.promptTextColorTransition.play();
                }
            } else if (!up) {
                this.promptTextUpTransition.stop();
                if (((ComboBoxBase)this.getSkinnable()).isFocused()) {
                    this.promptTextFill.set((Object)this.oldPromptTextFill);
                }
                this.promptTextDownTransition.play();
            }
        }
    }

    private void createFocusTransition() {
        this.transition = new ParallelTransition();
        if (((JFXComboBox)this.getSkinnable()).isLabelFloat()) {
            this.transition.getChildren().add((Object)this.promptTextUpTransition);
            this.transition.getChildren().add((Object)this.promptTextColorTransition);
        }
        this.transition.getChildren().add((Object)this.linesAnimation);
    }

    private void unFocus() {
        if (this.transition != null) {
            this.transition.stop();
        }
        this.scale.setX(this.initScale);
        this.focusedLine.setOpacity(0.0);
        if (((JFXComboBox)this.getSkinnable()).isLabelFloat() && this.oldPromptTextFill != null) {
            this.promptTextFill.set((Object)this.oldPromptTextFill);
            if (this.usePromptText()) {
                this.promptTextDownTransition.play();
            }
        }
    }

    private boolean usePromptText() {
        Object txt = ((JFXComboBox)this.getSkinnable()).getValue();
        String promptTxt = ((ComboBoxBase)this.getSkinnable()).getPromptText();
        return (txt == null || txt.toString().isEmpty()) && promptTxt != null && !promptTxt.isEmpty() && !((Paint)this.promptTextFill.get()).equals(Color.TRANSPARENT);
    }
}

