/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download.java.disco;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.jackhuang.hmcl.download.java.JavaDistribution;
import org.jackhuang.hmcl.download.java.JavaPackageType;
import org.jackhuang.hmcl.download.java.disco.DiscoJavaRemoteVersion;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.platform.Architecture;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.platform.Platform;

public enum DiscoJavaDistribution implements JavaDistribution<DiscoJavaRemoteVersion>
{
    TEMURIN("Eclipse Temurin", "temurin", "Adoptium", EnumSet.of(JavaPackageType.JDK, JavaPackageType.JRE), Pair.pair(OperatingSystem.WINDOWS, EnumSet.of(Architecture.X86_64, Architecture.X86, Architecture.ARM64)), Pair.pair(OperatingSystem.LINUX, EnumSet.of(Architecture.X86_64, new Architecture[]{Architecture.X86, Architecture.ARM64, Architecture.ARM32, Architecture.RISCV64, Architecture.PPC64, Architecture.PPC64LE, Architecture.S390X, Architecture.SPARCV9})), Pair.pair(OperatingSystem.MACOS, EnumSet.of(Architecture.X86_64, Architecture.ARM64))),
    LIBERICA("BellSoft Liberica", "liberica", "BellSoft", EnumSet.of(JavaPackageType.JDK, JavaPackageType.JRE, JavaPackageType.JDKFX, JavaPackageType.JREFX), new Pair[]{Pair.pair(OperatingSystem.WINDOWS, EnumSet.of(Architecture.X86_64, Architecture.X86, Architecture.ARM64)), Pair.pair(OperatingSystem.LINUX, EnumSet.of(Architecture.X86_64, new Architecture[]{Architecture.X86, Architecture.ARM64, Architecture.ARM32, Architecture.RISCV64, Architecture.PPC64LE})), Pair.pair(OperatingSystem.MACOS, EnumSet.of(Architecture.X86_64, Architecture.ARM64))}){

        @Override
        public boolean testVersion(DiscoJavaRemoteVersion version) {
            if (!super.testVersion(version)) {
                return false;
            }
            String fileName = version.getFileName();
            return !fileName.endsWith("-lite.tar.gz") && !fileName.endsWith("-lite.zip");
        }
    }
    ,
    ZULU("Azul Zulu", "zulu", "Azul", EnumSet.of(JavaPackageType.JDK, JavaPackageType.JRE, JavaPackageType.JDKFX, JavaPackageType.JREFX), Pair.pair(OperatingSystem.WINDOWS, EnumSet.of(Architecture.X86_64, Architecture.X86, Architecture.ARM64)), Pair.pair(OperatingSystem.LINUX, EnumSet.of(Architecture.X86_64, new Architecture[]{Architecture.X86, Architecture.ARM64, Architecture.ARM32, Architecture.RISCV64, Architecture.PPC64LE})), Pair.pair(OperatingSystem.MACOS, EnumSet.of(Architecture.X86_64, Architecture.ARM64))),
    GRAALVM("Oracle GraalVM", "graalvm", "Oracle", EnumSet.of(JavaPackageType.JDK), Pair.pair(OperatingSystem.WINDOWS, EnumSet.of(Architecture.X86_64)), Pair.pair(OperatingSystem.LINUX, EnumSet.of(Architecture.X86_64, Architecture.ARM64)), Pair.pair(OperatingSystem.MACOS, EnumSet.of(Architecture.X86_64, Architecture.ARM64))),
    SEMERU("IBM Semeru (OpenJ9)", "semeru", "IBM", EnumSet.of(JavaPackageType.JDK, JavaPackageType.JRE), Pair.pair(OperatingSystem.WINDOWS, EnumSet.of(Architecture.X86_64)), Pair.pair(OperatingSystem.LINUX, EnumSet.of(Architecture.X86_64, Architecture.ARM64, Architecture.PPC64LE, Architecture.S390X)), Pair.pair(OperatingSystem.MACOS, EnumSet.of(Architecture.X86_64, Architecture.ARM64))),
    CORRETTO("Amazon Corretto", "corretto", "Amazon", EnumSet.of(JavaPackageType.JDK), Pair.pair(OperatingSystem.WINDOWS, EnumSet.of(Architecture.X86_64)), Pair.pair(OperatingSystem.LINUX, EnumSet.of(Architecture.X86_64, Architecture.ARM64)), Pair.pair(OperatingSystem.MACOS, EnumSet.of(Architecture.X86_64, Architecture.ARM64)));

    private final String displayName;
    private final String apiParameter;
    private final String vendor;
    private final Set<JavaPackageType> supportedPackageTypes;
    private final Map<OperatingSystem, EnumSet<Architecture>> supportedPlatforms = new EnumMap<OperatingSystem, EnumSet<Architecture>>(OperatingSystem.class);

    public static DiscoJavaDistribution of(String name) {
        for (DiscoJavaDistribution distribution : DiscoJavaDistribution.values()) {
            if (!distribution.apiParameter.equalsIgnoreCase(name) && !distribution.name().equalsIgnoreCase(name)) continue;
            return distribution;
        }
        return null;
    }

    @SafeVarargs
    private DiscoJavaDistribution(String displayName, String apiParameter, String vendor, Set<JavaPackageType> supportedPackageTypes, Pair<OperatingSystem, EnumSet<Architecture>> ... supportedPlatforms) {
        this.displayName = displayName;
        this.apiParameter = apiParameter;
        this.vendor = vendor;
        this.supportedPackageTypes = supportedPackageTypes;
        for (Pair<OperatingSystem, EnumSet<Architecture>> platform : supportedPlatforms) {
            this.supportedPlatforms.put(platform.getKey(), platform.getValue());
        }
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public String getApiParameter() {
        return this.apiParameter;
    }

    public String getVendor() {
        return this.vendor;
    }

    @Override
    public Set<JavaPackageType> getSupportedPackageTypes() {
        return this.supportedPackageTypes;
    }

    public boolean isSupport(Platform platform) {
        EnumSet<Architecture> architectures = this.supportedPlatforms.get((Object)platform.getOperatingSystem());
        return architectures != null && architectures.contains((Object)platform.getArchitecture());
    }

    public boolean testVersion(DiscoJavaRemoteVersion version) {
        return this.getApiParameter().equals(version.getDistribution());
    }
}

