/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.game;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.auth.AuthInfo;
import org.jackhuang.hmcl.game.GameRepository;
import org.jackhuang.hmcl.game.LaunchOptions;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.launch.DefaultLauncher;
import org.jackhuang.hmcl.launch.ProcessListener;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.ManagedProcess;
import org.jackhuang.hmcl.util.versioning.GameVersionNumber;

public final class HMCLGameLauncher
extends DefaultLauncher {
    public HMCLGameLauncher(GameRepository repository, Version version, AuthInfo authInfo, LaunchOptions options) {
        this(repository, version, authInfo, options, null);
    }

    public HMCLGameLauncher(GameRepository repository, Version version, AuthInfo authInfo, LaunchOptions options, ProcessListener listener) {
        this(repository, version, authInfo, options, listener, true);
    }

    public HMCLGameLauncher(GameRepository repository, Version version, AuthInfo authInfo, LaunchOptions options, ProcessListener listener, boolean daemon) {
        super(repository, version, authInfo, options, listener, daemon);
    }

    @Override
    protected Map<String, String> getConfigurations() {
        Map<String, String> res = super.getConfigurations();
        res.put("${launcher_name}", "HMCL");
        res.put("${launcher_version}", Metadata.VERSION);
        return res;
    }

    private void generateOptionsTxt() {
        File optionsFile = new File(this.repository.getRunDirectory(this.version.getId()), "options.txt");
        File configFolder = new File(this.repository.getRunDirectory(this.version.getId()), "config");
        if (optionsFile.exists()) {
            return;
        }
        if (configFolder.isDirectory() && this.findFiles(configFolder, "options.txt")) {
            return;
        }
        if (!I18n.isUseChinese()) {
            return;
        }
        GameVersionNumber gameVersion = GameVersionNumber.asGameVersion(this.repository.getGameVersion(this.version));
        String lang = gameVersion.compareTo("1.1") < 0 ? null : (gameVersion.compareTo("1.11") < 0 ? "zh_CN" : "zh_cn");
        if (lang != null) {
            try {
                FileUtils.writeText(optionsFile, String.format("lang:%s\n", lang));
            }
            catch (IOException e) {
                Logger.LOG.warning("Unable to generate options.txt", e);
            }
        }
    }

    private boolean findFiles(File folder, String fileName) {
        File[] fs = folder.listFiles();
        if (fs != null) {
            for (File f : fs) {
                if (f.isDirectory() && f.listFiles((dir, name) -> name.equals(fileName)) != null) {
                    return true;
                }
                if (!f.getName().equals(fileName)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public ManagedProcess launch() throws IOException, InterruptedException {
        this.generateOptionsTxt();
        return super.launch();
    }

    @Override
    public void makeLaunchScript(File scriptFile) throws IOException {
        this.generateOptionsTxt();
        super.makeLaunchScript(scriptFile);
    }
}

