/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.game;

import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.jackhuang.hmcl.game.Artifact;
import org.jackhuang.hmcl.game.CompatibilityRule;
import org.jackhuang.hmcl.game.ExtractRules;
import org.jackhuang.hmcl.game.LibrariesDownloadInfo;
import org.jackhuang.hmcl.game.LibraryDownloadInfo;
import org.jackhuang.hmcl.util.Immutable;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.ToStringBuilder;
import org.jackhuang.hmcl.util.gson.TolerableValidationException;
import org.jackhuang.hmcl.util.gson.Validation;
import org.jackhuang.hmcl.util.platform.Architecture;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jetbrains.annotations.Nullable;

@Immutable
public class Library
implements Comparable<Library>,
Validation {
    private static final String[] POSSIBLE_NATIVE_DESCRIPTORS;
    @SerializedName(value="name")
    private final Artifact artifact;
    private final String url;
    private final LibrariesDownloadInfo downloads;
    private final ExtractRules extract;
    private final Map<String, String> natives;
    private final List<CompatibilityRule> rules;
    private final List<String> checksums;
    @SerializedName(value="hint", alternate={"MMC-hint"})
    private final String hint;
    @SerializedName(value="filename", alternate={"MMC-filename"})
    private final String fileName;

    public Library(Artifact artifact) {
        this(artifact, null, null);
    }

    public Library(Artifact artifact, String url, LibrariesDownloadInfo downloads) {
        this(artifact, url, downloads, null, null, null, null, null, null);
    }

    public Library(Artifact artifact, String url, LibrariesDownloadInfo downloads, List<String> checksums, ExtractRules extract, Map<String, String> natives, List<CompatibilityRule> rules, String hint, String filename) {
        this.artifact = artifact;
        this.url = url;
        this.downloads = downloads;
        this.extract = extract;
        this.natives = natives;
        this.rules = rules;
        this.checksums = checksums;
        this.hint = hint;
        this.fileName = filename;
    }

    public String getGroupId() {
        return this.artifact.getGroup();
    }

    public String getArtifactId() {
        return this.artifact.getName();
    }

    public String getName() {
        return this.artifact.toString();
    }

    public String getVersion() {
        return this.artifact.getVersion();
    }

    public String getClassifier() {
        if (this.artifact.getClassifier() == null) {
            if (this.natives != null) {
                for (String nativeDescriptor : POSSIBLE_NATIVE_DESCRIPTORS) {
                    String nd = this.natives.get(nativeDescriptor);
                    if (nd == null) continue;
                    return nd.replace("${arch}", Architecture.SYSTEM_ARCH.getBits().getBit());
                }
            } else if (this.downloads != null && this.downloads.getClassifiers() != null) {
                for (String nativeDescriptor : POSSIBLE_NATIVE_DESCRIPTORS) {
                    LibraryDownloadInfo info = this.downloads.getClassifiers().get(nativeDescriptor);
                    if (info == null) continue;
                    return nativeDescriptor;
                }
            }
            return null;
        }
        return this.artifact.getClassifier();
    }

    public ExtractRules getExtract() {
        return this.extract == null ? ExtractRules.EMPTY : this.extract;
    }

    public boolean appliesToCurrentEnvironment() {
        return CompatibilityRule.appliesToCurrentEnvironment(this.rules);
    }

    public boolean isNative() {
        if (!this.appliesToCurrentEnvironment()) {
            return false;
        }
        if (this.natives != null) {
            return true;
        }
        return this.downloads != null && this.downloads.getClassifiers().keySet().stream().anyMatch(s -> s.startsWith("native"));
    }

    public LibraryDownloadInfo getRawDownloadInfo() {
        if (this.downloads != null) {
            if (this.isNative()) {
                return this.downloads.getClassifiers().get(this.getClassifier());
            }
            return this.downloads.getArtifact();
        }
        return null;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public String getPath() {
        LibraryDownloadInfo temp = this.getRawDownloadInfo();
        if (temp != null && temp.getPath() != null) {
            return temp.getPath();
        }
        return this.artifact.setClassifier(this.getClassifier()).getPath();
    }

    public LibraryDownloadInfo getDownload() {
        LibraryDownloadInfo temp = this.getRawDownloadInfo();
        String path = this.getPath();
        return new LibraryDownloadInfo(path, this.computePath(temp, path), temp != null ? temp.getSha1() : null, temp != null ? temp.getSize() : 0);
    }

    private String computePath(LibraryDownloadInfo raw, String path) {
        String url;
        if (raw != null && (url = raw.getUrl()) != null) {
            return url;
        }
        Object repo = Lang.requireNonNullElse(this.url, "https://libraries.minecraft.net/");
        if (!((String)repo).endsWith("/")) {
            repo = (String)repo + "/";
        }
        return (String)repo + path;
    }

    public boolean hasDownloadURL() {
        LibraryDownloadInfo temp = this.getRawDownloadInfo();
        if (temp != null) {
            return temp.getUrl() != null;
        }
        return this.url != null;
    }

    public List<String> getChecksums() {
        return this.checksums;
    }

    public List<CompatibilityRule> getRules() {
        return this.rules;
    }

    @Nullable
    public String getHint() {
        return this.hint;
    }

    @Nullable
    public String getFileName() {
        return this.fileName;
    }

    public boolean is(String groupId, String artifactId) {
        return this.getGroupId().equals(groupId) && this.getArtifactId().equals(artifactId);
    }

    public String toString() {
        return new ToStringBuilder(this).append("name", this.getName()).toString();
    }

    @Override
    public int compareTo(Library o) {
        if (this.getName().compareTo(o.getName()) == 0) {
            return Boolean.compare(this.isNative(), o.isNative());
        }
        return this.getName().compareTo(o.getName());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Library)) {
            return false;
        }
        Library other = (Library)obj;
        return this.getName().equals(other.getName()) && this.isNative() == other.isNative();
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.isNative());
    }

    public Library setClassifier(String classifier) {
        return new Library(this.artifact.setClassifier(classifier), this.url, this.downloads, this.checksums, this.extract, this.natives, this.rules, this.hint, this.fileName);
    }

    @Override
    public void validate() throws JsonParseException, TolerableValidationException {
        if (this.artifact == null) {
            throw new JsonParseException("Library.name cannot be null");
        }
    }

    static {
        String[] keys = new String[]{"", Architecture.SYSTEM_ARCH.name().toLowerCase(Locale.ROOT), Architecture.SYSTEM_ARCH.getBits().getBit()};
        String[] variants = new String[]{"", "native", "natives"};
        POSSIBLE_NATIVE_DESCRIPTORS = new String[keys.length * variants.length];
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < keys.length; ++i) {
            for (int j = 0; j < variants.length; ++j) {
                if (!variants[j].isEmpty()) {
                    builder.append(variants[j]).append('-');
                }
                builder.append(OperatingSystem.CURRENT_OS.getMojangName());
                if (!keys[i].isEmpty()) {
                    builder.append('-').append(keys[i]);
                }
                Library.POSSIBLE_NATIVE_DESCRIPTORS[i * variants.length + j] = builder.toString();
                builder.setLength(0);
            }
        }
    }
}

