/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.setting;

import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.Objects;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.text.Font;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.util.Lazy;
import org.jackhuang.hmcl.util.io.JarUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.platform.SystemUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FontManager {
    public static final String[] FONT_EXTENSIONS;
    public static final double DEFAULT_FONT_SIZE = 12.0;
    private static final Lazy<Font> DEFAULT_FONT;
    private static final ObjectProperty<FontReference> fontProperty;

    private static Font tryLoadDefaultFont(Path dir) {
        for (String extension : FONT_EXTENSIONS) {
            Path path = dir.resolve("font." + extension);
            if (!Files.isRegularFile(path, new LinkOption[0])) continue;
            try {
                Font font = Font.loadFont((String)path.toUri().toURL().toExternalForm(), (double)12.0);
                if (font != null) {
                    return font;
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            Logger.LOG.warning("Failed to load font " + path);
        }
        return null;
    }

    public static Font findByFcMatch() {
        Path fcMatch = SystemUtils.which("fc-match");
        if (fcMatch == null) {
            return null;
        }
        try {
            String result = SystemUtils.run(fcMatch.toString(), ":lang=" + Locale.getDefault().toLanguageTag(), "--format", "%{family}\\n%{file}").trim();
            String[] results = result.split("\\n");
            if (results.length != 2 || results[0].isEmpty() || results[1].isEmpty()) {
                Logger.LOG.warning("Unexpected output from fc-match: " + result);
                return null;
            }
            String family = results[0].trim();
            String path = results[1];
            Path file = Paths.get(path, new String[0]).toAbsolutePath().normalize();
            if (!Files.isRegularFile(file, new LinkOption[0])) {
                Logger.LOG.warning("Font file does not exist: " + path);
                return null;
            }
            Font[] fonts = Font.loadFonts((String)file.toUri().toURL().toExternalForm(), (double)12.0);
            if (fonts == null) {
                Logger.LOG.warning("Failed to load font from " + path);
                return null;
            }
            if (fonts.length == 0) {
                Logger.LOG.warning("No fonts loaded from " + path);
                return null;
            }
            for (Font font : fonts) {
                if (!font.getFamily().equalsIgnoreCase(family)) continue;
                return font;
            }
            if (family.indexOf(44) >= 0) {
                for (String string : family.split(",")) {
                    for (Font font : fonts) {
                        if (!font.getFamily().equalsIgnoreCase(string)) continue;
                        return font;
                    }
                }
            }
            Logger.LOG.warning(String.format("Family '%s' not found in font file '%s'", family, path));
            return fonts[0];
        }
        catch (Throwable e) {
            Logger.LOG.warning("Failed to get default font with fc-match", e);
            return null;
        }
    }

    public static ObjectProperty<FontReference> fontProperty() {
        return fontProperty;
    }

    public static FontReference getFont() {
        return (FontReference)fontProperty.get();
    }

    public static void setFont(FontReference font) {
        fontProperty.set((Object)font);
    }

    public static void setFontFamily(String fontFamily) {
        FontManager.setFont(fontFamily != null ? new FontReference(fontFamily) : null);
    }

    private FontManager() {
    }

    static {
        Font defaultFont;
        FONT_EXTENSIONS = new String[]{"ttf", "otf", "woff"};
        DEFAULT_FONT = new Lazy<Font>(() -> {
            Font font = FontManager.tryLoadDefaultFont(Metadata.HMCL_CURRENT_DIRECTORY);
            if (font != null) {
                return font;
            }
            font = FontManager.tryLoadDefaultFont(Metadata.CURRENT_DIRECTORY);
            if (font != null) {
                return font;
            }
            font = FontManager.tryLoadDefaultFont(Metadata.HMCL_GLOBAL_DIRECTORY);
            if (font != null) {
                return font;
            }
            Path thisJar = JarUtils.thisJarPath();
            if (thisJar != null && thisJar.getParent() != null && (font = FontManager.tryLoadDefaultFont(thisJar.getParent())) != null) {
                return font;
            }
            if (OperatingSystem.CURRENT_OS.isLinuxOrBSD() && Locale.getDefault() != Locale.ROOT && !"en".equals(Locale.getDefault().getLanguage())) {
                return FontManager.findByFcMatch();
            }
            return null;
        });
        String fontFamily = ConfigHolder.config().getLauncherFontFamily();
        if (fontFamily == null) {
            fontFamily = System.getProperty("hmcl.font.override");
        }
        if (fontFamily == null) {
            fontFamily = System.getenv("HMCL_FONT");
        }
        FontReference fontReference = fontFamily == null ? ((defaultFont = DEFAULT_FONT.get()) != null ? new FontReference(defaultFont) : null) : new FontReference(fontFamily);
        fontProperty = new SimpleObjectProperty((Object)fontReference);
        Logger.LOG.info("Font: " + (fontReference != null ? fontReference.getFamily() : "System"));
        fontProperty.addListener((obs, oldValue, newValue) -> {
            if (newValue != null) {
                ConfigHolder.config().setLauncherFontFamily(newValue.getFamily());
            } else {
                ConfigHolder.config().setLauncherFontFamily(null);
            }
        });
    }

    public static final class FontReference {
        @NotNull
        private final String family;
        @Nullable
        private final String style;

        public FontReference(@NotNull String family) {
            this.family = Objects.requireNonNull(family);
            this.style = null;
        }

        public FontReference(@NotNull Font font) {
            this.family = font.getFamily();
            this.style = font.getStyle();
        }

        @NotNull
        public String getFamily() {
            return this.family;
        }

        @Nullable
        public String getStyle() {
            return this.style;
        }

        public boolean equals(Object o) {
            if (!(o instanceof FontReference)) {
                return false;
            }
            FontReference that = (FontReference)o;
            return Objects.equals(this.family, that.family) && Objects.equals(this.style, that.style);
        }

        public int hashCode() {
            return Objects.hash(this.family, this.style);
        }

        public String toString() {
            return String.format("FontReference[family='%s', style='%s']", this.family, this.style);
        }
    }
}

