/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.task;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLConnection;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.jackhuang.hmcl.event.Event;
import org.jackhuang.hmcl.event.EventBus;
import org.jackhuang.hmcl.task.DownloadException;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.CacheRepository;
import org.jackhuang.hmcl.util.DigestUtils;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.ToStringBuilder;
import org.jackhuang.hmcl.util.io.ContentEncoding;
import org.jackhuang.hmcl.util.io.NetworkUtils;
import org.jackhuang.hmcl.util.io.ResponseCodeException;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class FetchTask<T>
extends Task<T> {
    protected static final int DEFAULT_RETRY = 3;
    protected final List<URI> uris;
    protected int retry = 3;
    protected CacheRepository repository = CacheRepository.getInstance();
    private static final Timer timer = new Timer("DownloadSpeedRecorder", true);
    private static final AtomicLong downloadSpeed = new AtomicLong(0L);
    public static final EventBus speedEvent = new EventBus();
    public static int DEFAULT_CONCURRENCY;
    private static int downloadExecutorConcurrency;
    private static volatile ThreadPoolExecutor DOWNLOAD_EXECUTOR;

    public FetchTask(@NotNull @NotNull List<@NotNull URI> uris) {
        Objects.requireNonNull(uris);
        this.uris = List.copyOf(uris);
        if (this.uris.isEmpty()) {
            throw new IllegalArgumentException("At least one URL is required");
        }
        this.setExecutor(FetchTask.download());
    }

    public void setRetry(int retry) {
        if (retry <= 0) {
            throw new IllegalArgumentException("Retry count must be greater than 0");
        }
        this.retry = retry;
    }

    public void setCacheRepository(CacheRepository repository) {
        this.repository = repository;
    }

    protected void beforeDownload(URI uri) throws IOException {
    }

    protected abstract void useCachedResult(Path var1) throws IOException;

    protected abstract EnumCheckETag shouldCheckETag();

    protected abstract Context getContext(URLConnection var1, boolean var2, String var3) throws IOException;

    @Override
    public void execute() throws Exception {
        boolean checkETag;
        IOException exception = null;
        URI failedURI = null;
        switch (this.shouldCheckETag()) {
            case CHECK_E_TAG: {
                checkETag = true;
                break;
            }
            case NOT_CHECK_E_TAG: {
                checkETag = false;
                break;
            }
            default: {
                return;
            }
        }
        int repeat = 0;
        block27: for (URI uri : this.uris) {
            for (int retryTime = 0; retryTime < this.retry; ++retryTime) {
                if (this.isCancelled()) break block27;
                ArrayList<URI> redirects = null;
                String bmclapiHash = null;
                try {
                    this.beforeDownload(uri);
                    this.updateProgress(0.0);
                    URLConnection conn = NetworkUtils.createConnection(uri);
                    if (conn instanceof HttpURLConnection) {
                        int code;
                        HttpURLConnection httpConnection = (HttpURLConnection)conn;
                        httpConnection.setRequestProperty("Accept-Encoding", "gzip");
                        if (checkETag) {
                            this.repository.injectConnection(httpConnection);
                        }
                        Map<String, List<String>> requestProperties = httpConnection.getRequestProperties();
                        bmclapiHash = httpConnection.getHeaderField("x-bmclapi-hash");
                        if (DigestUtils.isSha1Digest(bmclapiHash)) {
                            Optional<Path> cache = this.repository.checkExistentFile(null, "SHA-1", bmclapiHash);
                            if (cache.isPresent()) {
                                this.useCachedResult(cache.get());
                                Logger.LOG.info("Using cached file for " + NetworkUtils.dropQuery(uri));
                                return;
                            }
                        } else {
                            bmclapiHash = null;
                        }
                        while ((code = httpConnection.getResponseCode()) >= 300 && code <= 308 && code != 306 && code != 304) {
                            if (redirects == null) {
                                redirects = new ArrayList<URI>();
                            } else if (redirects.size() >= 20) {
                                httpConnection.disconnect();
                                throw new IOException("Too much redirects");
                            }
                            String location = httpConnection.getHeaderField("Location");
                            httpConnection.disconnect();
                            if (StringUtils.isBlank(location)) {
                                throw new IOException("Redirected to an empty location");
                            }
                            URI target = NetworkUtils.toURI(httpConnection.getURL()).resolve(NetworkUtils.toURI(location));
                            redirects.add(target);
                            if (!NetworkUtils.isHttpUri(target)) {
                                throw new IOException("Redirected to not http URI: " + target);
                            }
                            HttpURLConnection redirected = NetworkUtils.createHttpConnection(target);
                            redirected.setUseCaches(checkETag);
                            requestProperties.forEach((key, values) -> values.forEach(element -> redirected.addRequestProperty((String)key, (String)element)));
                            httpConnection = redirected;
                        }
                        conn = httpConnection;
                        int responseCode = ((HttpURLConnection)conn).getResponseCode();
                        if (responseCode == 304) {
                            try {
                                Path cache = this.repository.getCachedRemoteFile(NetworkUtils.toURI(conn.getURL()));
                                this.useCachedResult(cache);
                                Logger.LOG.info("Using cached file for " + NetworkUtils.dropQuery(uri));
                                return;
                            }
                            catch (IOException e) {
                                Logger.LOG.warning("Unable to use cached file, redownload " + NetworkUtils.dropQuery(uri), e);
                                this.repository.removeRemoteEntry(conn.getURL().toURI());
                                --retryTime;
                                continue;
                            }
                        }
                        if (responseCode / 100 == 4) {
                            throw new FileNotFoundException(uri.toString());
                        }
                        if (responseCode / 100 != 2) {
                            throw new ResponseCodeException(uri, responseCode);
                        }
                    }
                    long contentLength = conn.getContentLengthLong();
                    ContentEncoding encoding = ContentEncoding.fromConnection(conn);
                    try (Context context = this.getContext(conn, checkETag, bmclapiHash);
                         CounterInputStream counter = new CounterInputStream(conn.getInputStream());
                         InputStream input = encoding.wrap(counter);){
                        int len;
                        long lastDownloaded = 0L;
                        byte[] buffer = new byte[8192];
                        while (!this.isCancelled() && (len = input.read(buffer)) != -1) {
                            context.write(buffer, 0, len);
                            if (contentLength >= 0L) {
                                this.updateProgress(counter.downloaded, contentLength);
                            }
                            FetchTask.updateDownloadSpeed(counter.downloaded - lastDownloaded);
                            lastDownloaded = counter.downloaded;
                        }
                        if (this.isCancelled()) break block27;
                        FetchTask.updateDownloadSpeed(counter.downloaded - lastDownloaded);
                        if (contentLength >= 0L && counter.downloaded != contentLength) {
                            throw new IOException("Unexpected file size: " + counter.downloaded + ", expected: " + contentLength);
                        }
                        context.withResult(true);
                    }
                    return;
                }
                catch (FileNotFoundException ex) {
                    failedURI = uri;
                    exception = ex;
                    Logger.LOG.warning("Failed to download " + uri + ", not found" + (String)(redirects == null ? "" : ", redirects: " + redirects), ex);
                    continue block27;
                }
                catch (IOException ex) {
                    failedURI = uri;
                    exception = ex;
                    Logger.LOG.warning("Failed to download " + uri + ", repeat times: " + ++repeat + (String)(redirects == null ? "" : ", redirects: " + redirects), ex);
                }
            }
        }
        if (exception != null) {
            throw new DownloadException(failedURI, exception);
        }
    }

    private static void updateDownloadSpeed(long speed) {
        downloadSpeed.addAndGet(speed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static ExecutorService download() {
        if (DOWNLOAD_EXECUTOR != null) return DOWNLOAD_EXECUTOR;
        Class<Schedulers> clazz = Schedulers.class;
        synchronized (Schedulers.class) {
            if (DOWNLOAD_EXECUTOR != null) return DOWNLOAD_EXECUTOR;
            DOWNLOAD_EXECUTOR = Lang.threadPool("Download", true, downloadExecutorConcurrency, 10L, TimeUnit.SECONDS);
            // ** MonitorExit[var0] (shouldn't be in output)
            return DOWNLOAD_EXECUTOR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDownloadExecutorConcurrency(int concurrency) {
        concurrency = Math.max(concurrency, 1);
        Class<Schedulers> clazz = Schedulers.class;
        synchronized (Schedulers.class) {
            downloadExecutorConcurrency = concurrency;
            ThreadPoolExecutor downloadExecutor = DOWNLOAD_EXECUTOR;
            if (downloadExecutor != null) {
                if (downloadExecutor.getMaximumPoolSize() <= concurrency) {
                    downloadExecutor.setMaximumPoolSize(concurrency);
                    downloadExecutor.setCorePoolSize(concurrency);
                } else {
                    downloadExecutor.setCorePoolSize(concurrency);
                    downloadExecutor.setMaximumPoolSize(concurrency);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDownloadExecutorConcurrency() {
        Class<Schedulers> clazz = Schedulers.class;
        synchronized (Schedulers.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return downloadExecutorConcurrency;
        }
    }

    static {
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                speedEvent.channel(SpeedEvent.class).fireEvent(new SpeedEvent(speedEvent, downloadSpeed.getAndSet(0L)));
            }
        }, 0L, 1000L);
        downloadExecutorConcurrency = DEFAULT_CONCURRENCY = Math.min(Runtime.getRuntime().availableProcessors() * 4, 64);
    }

    protected static enum EnumCheckETag {
        CHECK_E_TAG,
        NOT_CHECK_E_TAG,
        CACHED;

    }

    protected static abstract class Context
    implements Closeable {
        private boolean success;

        protected Context() {
        }

        public abstract void write(byte[] var1, int var2, int var3) throws IOException;

        public final void withResult(boolean success) {
            this.success = success;
        }

        protected boolean isSuccess() {
            return this.success;
        }
    }

    private static final class CounterInputStream
    extends FilterInputStream {
        long downloaded;

        CounterInputStream(InputStream in) {
            super(in);
        }

        @Override
        public int read() throws IOException {
            int b = this.in.read();
            if (b >= 0) {
                ++this.downloaded;
            }
            return b;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int n = this.in.read(b, off, len);
            if (n >= 0) {
                this.downloaded += (long)n;
            }
            return n;
        }
    }

    public static class SpeedEvent
    extends Event {
        private final long speed;

        public SpeedEvent(Object source, long speed) {
            super(source);
            this.speed = speed;
        }

        public long getSpeed() {
            return this.speed;
        }

        @Override
        public String toString() {
            return new ToStringBuilder(this).append("speed", this.speed).toString();
        }
    }
}

