/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.task;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URLConnection;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.jackhuang.hmcl.task.FetchTask;
import org.jackhuang.hmcl.util.DigestUtils;
import org.jackhuang.hmcl.util.Hex;
import org.jackhuang.hmcl.util.io.ChecksumMismatchException;
import org.jackhuang.hmcl.util.io.CompressingUtils;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.io.NetworkUtils;
import org.jackhuang.hmcl.util.logging.Logger;

public class FileDownloadTask
extends FetchTask<Void> {
    private final Path file;
    private final IntegrityCheck integrityCheck;
    private boolean caching;
    private Path candidate;
    private final ArrayList<IntegrityCheckHandler> integrityCheckHandlers = new ArrayList();
    public static final IntegrityCheckHandler ZIP_INTEGRITY_CHECK_HANDLER = (filePath, destinationPath) -> {
        FileSystem ignored;
        String ext = FileUtils.getExtension(destinationPath).toLowerCase(Locale.ROOT);
        if ((ext.equals("zip") || ext.equals("jar")) && (ignored = CompressingUtils.createReadOnlyZipFileSystem(filePath)) != null) {
            ignored.close();
        }
    };

    public FileDownloadTask(String uri, Path path) {
        this(List.of(NetworkUtils.toURI(uri)), path, null);
    }

    public FileDownloadTask(String uri, Path path, IntegrityCheck integrityCheck) {
        this(List.of(NetworkUtils.toURI(uri)), path, integrityCheck);
    }

    public FileDownloadTask(URI uri, Path path) {
        this(uri, path, null);
    }

    public FileDownloadTask(URI uri, Path path, IntegrityCheck integrityCheck) {
        this(List.of(uri), path, integrityCheck);
    }

    public FileDownloadTask(List<URI> uris, Path file) {
        this(uris, file, null);
    }

    public FileDownloadTask(List<URI> uris, Path path, IntegrityCheck integrityCheck) {
        super(uris);
        this.file = path;
        this.integrityCheck = integrityCheck;
        this.setName(path.getFileName().toString());
    }

    public Path getPath() {
        return this.file;
    }

    public void setCaching(boolean caching) {
        this.caching = caching;
    }

    public FileDownloadTask setCandidate(Path candidate) {
        this.candidate = candidate;
        return this;
    }

    public void addIntegrityCheckHandler(IntegrityCheckHandler handler) {
        this.integrityCheckHandlers.add(Objects.requireNonNull(handler));
    }

    @Override
    protected FetchTask.EnumCheckETag shouldCheckETag() {
        if (this.integrityCheck != null && this.caching) {
            Optional<Path> cache = this.repository.checkExistentFile(this.candidate, this.integrityCheck.getAlgorithm(), this.integrityCheck.getChecksum());
            if (cache.isPresent()) {
                try {
                    FileUtils.copyFile(cache.get(), this.file);
                    Logger.LOG.trace("Successfully verified file " + this.file + " from " + this.uris.get(0));
                    return FetchTask.EnumCheckETag.CACHED;
                }
                catch (IOException e) {
                    Logger.LOG.warning("Failed to copy cache files", e);
                }
            }
            return FetchTask.EnumCheckETag.NOT_CHECK_E_TAG;
        }
        return FetchTask.EnumCheckETag.CHECK_E_TAG;
    }

    @Override
    protected void beforeDownload(URI uri) {
        Logger.LOG.trace("Downloading " + uri + " to " + this.file);
    }

    @Override
    protected void useCachedResult(Path cache) throws IOException {
        FileUtils.copyFile(cache, this.file);
    }

    @Override
    protected FetchTask.Context getContext(final URLConnection connection, final boolean checkETag, String bmclapiHash) throws IOException {
        String checksum;
        String algorithm;
        final Path temp = Files.createTempFile(null, null, new FileAttribute[0]);
        if (this.integrityCheck != null) {
            algorithm = this.integrityCheck.getAlgorithm();
            checksum = this.integrityCheck.getChecksum();
        } else if (bmclapiHash != null) {
            algorithm = "SHA-1";
            checksum = bmclapiHash;
        } else {
            algorithm = null;
            checksum = null;
        }
        final MessageDigest digest = algorithm != null ? DigestUtils.getDigest(algorithm) : null;
        final OutputStream fileOutput = Files.newOutputStream(temp, new OpenOption[0]);
        return new FetchTask.Context(){

            @Override
            public void write(byte[] buffer, int offset, int len) throws IOException {
                if (digest != null) {
                    digest.update(buffer, offset, len);
                }
                fileOutput.write(buffer, offset, len);
            }

            @Override
            public void close() throws IOException {
                String actualChecksum;
                try {
                    fileOutput.close();
                }
                catch (IOException e) {
                    Logger.LOG.warning("Failed to close file: " + temp, e);
                }
                if (!this.isSuccess()) {
                    try {
                        Files.deleteIfExists(temp);
                    }
                    catch (IOException e) {
                        Logger.LOG.warning("Failed to delete file: " + temp, e);
                    }
                    return;
                }
                for (IntegrityCheckHandler handler : FileDownloadTask.this.integrityCheckHandlers) {
                    handler.checkIntegrity(temp, FileDownloadTask.this.file);
                }
                Files.createDirectories(FileDownloadTask.this.file.toAbsolutePath().getParent(), new FileAttribute[0]);
                try {
                    Files.move(temp, FileDownloadTask.this.file, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Exception e) {
                    throw new IOException("Unable to move temp file from " + temp + " to " + FileDownloadTask.this.file, e);
                }
                if (checksum != null && !checksum.equalsIgnoreCase(actualChecksum = Hex.encodeHex(digest.digest()))) {
                    throw new ChecksumMismatchException(algorithm, checksum, actualChecksum);
                }
                if (FileDownloadTask.this.caching && algorithm != null) {
                    try {
                        FileDownloadTask.this.repository.cacheFile(FileDownloadTask.this.file, algorithm, checksum);
                    }
                    catch (IOException e) {
                        Logger.LOG.warning("Failed to cache file", e);
                    }
                }
                if (checkETag) {
                    FileDownloadTask.this.repository.cacheRemoteFile(connection, FileDownloadTask.this.file);
                }
            }
        };
    }

    public static class IntegrityCheck {
        private final String algorithm;
        private final String checksum;

        public IntegrityCheck(String algorithm, String checksum) {
            this.algorithm = Objects.requireNonNull(algorithm);
            this.checksum = Objects.requireNonNull(checksum);
        }

        public static IntegrityCheck of(String algorithm, String checksum) {
            if (checksum == null) {
                return null;
            }
            return new IntegrityCheck(algorithm, checksum);
        }

        public String getAlgorithm() {
            return this.algorithm;
        }

        public String getChecksum() {
            return this.checksum;
        }

        public String toString() {
            return String.format("IntegrityCheck[algorithm='%s', checksum='%s']", this.algorithm, this.checksum);
        }
    }

    public static interface IntegrityCheckHandler {
        public void checkIntegrity(Path var1, Path var2) throws IOException;
    }
}

