/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.decorator;

import com.jfoenix.controls.JFXDialog;
import com.jfoenix.controls.JFXSnackbar;
import com.jfoenix.controls.events.JFXDialogEvent;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.input.DragEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BackgroundImage;
import javafx.scene.layout.BackgroundPosition;
import javafx.scene.layout.BackgroundRepeat;
import javafx.scene.layout.BackgroundSize;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.util.Duration;
import org.jackhuang.hmcl.Launcher;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorDnD;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.setting.EnumBackgroundImage;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.account.AddAuthlibInjectorServerPane;
import org.jackhuang.hmcl.ui.animation.AnimationUtils;
import org.jackhuang.hmcl.ui.animation.ContainerAnimations;
import org.jackhuang.hmcl.ui.construct.DialogAware;
import org.jackhuang.hmcl.ui.construct.DialogCloseEvent;
import org.jackhuang.hmcl.ui.construct.JFXDialogPane;
import org.jackhuang.hmcl.ui.construct.Navigator;
import org.jackhuang.hmcl.ui.decorator.Decorator;
import org.jackhuang.hmcl.ui.decorator.DecoratorAnimationProducer;
import org.jackhuang.hmcl.ui.decorator.DecoratorPage;
import org.jackhuang.hmcl.ui.decorator.DecoratorWizardDisplayer;
import org.jackhuang.hmcl.ui.wizard.Refreshable;
import org.jackhuang.hmcl.ui.wizard.WizardProvider;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jetbrains.annotations.Nullable;

public class DecoratorController {
    private static final String PROPERTY_DIALOG_CLOSE_HANDLER = DecoratorController.class.getName() + ".dialog.closeListener";
    private final Decorator decorator;
    private final Navigator navigator;
    private JFXDialog dialog;
    private JFXDialogPane dialogPane;
    private int changeBackgroundCount = 0;
    private final InvalidationListener changeBackgroundListener;
    private static final DecoratorAnimationProducer animation = new DecoratorAnimationProducer();

    public DecoratorController(Stage stage, Node mainPage) {
        this.decorator = new Decorator(stage);
        this.decorator.setOnCloseButtonAction(() -> {
            if (AnimationUtils.playWindowAnimation()) {
                Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{new KeyValue((WritableValue)this.decorator.opacityProperty(), (Object)1, FXUtils.EASE), new KeyValue((WritableValue)this.decorator.scaleXProperty(), (Object)1, FXUtils.EASE), new KeyValue((WritableValue)this.decorator.scaleYProperty(), (Object)1, FXUtils.EASE), new KeyValue((WritableValue)this.decorator.scaleZProperty(), (Object)0.3, FXUtils.EASE)}), new KeyFrame(Duration.millis((double)200.0), new KeyValue[]{new KeyValue((WritableValue)this.decorator.opacityProperty(), (Object)0, FXUtils.EASE), new KeyValue((WritableValue)this.decorator.scaleXProperty(), (Object)0.8, FXUtils.EASE), new KeyValue((WritableValue)this.decorator.scaleYProperty(), (Object)0.8, FXUtils.EASE), new KeyValue((WritableValue)this.decorator.scaleZProperty(), (Object)0.8, FXUtils.EASE)})});
                timeline.setOnFinished(event -> Launcher.stopApplication());
                timeline.play();
            } else {
                Launcher.stopApplication();
            }
        });
        this.decorator.titleTransparentProperty().bind((ObservableValue)ConfigHolder.config().titleTransparentProperty());
        this.navigator = new Navigator();
        this.navigator.setOnNavigated((EventHandler<Navigator.NavigationEvent>)((EventHandler)this::onNavigated));
        this.navigator.init(mainPage);
        this.decorator.getContent().setAll((Object[])new Node[]{this.navigator});
        this.decorator.onCloseNavButtonActionProperty().set(e -> this.close());
        this.decorator.onBackNavButtonActionProperty().set(e -> this.back());
        this.decorator.onRefreshNavButtonActionProperty().set(e -> this.refresh());
        this.setupAuthlibInjectorDnD();
        this.decorator.setContentBackground(this.getBackground());
        this.changeBackgroundListener = o -> this.updateBackground();
        WeakInvalidationListener weakListener = new WeakInvalidationListener(this.changeBackgroundListener);
        ConfigHolder.config().backgroundImageTypeProperty().addListener((InvalidationListener)weakListener);
        ConfigHolder.config().backgroundImageProperty().addListener((InvalidationListener)weakListener);
        ConfigHolder.config().backgroundImageUrlProperty().addListener((InvalidationListener)weakListener);
        ConfigHolder.config().backgroundPaintProperty().addListener((InvalidationListener)weakListener);
        ConfigHolder.config().backgroundImageOpacityProperty().addListener((InvalidationListener)weakListener);
        this.decorator.addEventFilter(KeyEvent.ANY, e -> {
            if (!(e.getTarget() instanceof Node)) {
                return;
            }
            Node newTarget = this.dialogPane != null && this.dialogPane.peek().isPresent() ? this.dialogPane.peek().get() : this.navigator.getCurrentPage();
            boolean needsRedirect = true;
            for (Node t = (Node)e.getTarget(); t != null; t = t.getParent()) {
                if (t != newTarget) continue;
                needsRedirect = false;
                break;
            }
            if (!needsRedirect) {
                return;
            }
            e.consume();
            newTarget.fireEvent((Event)e.copyFor(e.getSource(), (EventTarget)newTarget));
        });
        FXUtils.onEscPressed((Node)this.navigator, this::back);
        this.navigator.addEventHandler(KeyEvent.KEY_PRESSED, e -> {
            if (e.getCode() == KeyCode.F11) {
                stage.setFullScreen(!stage.isFullScreen());
                e.consume();
            }
        });
        try {
            MouseButton button = MouseButton.valueOf((String)"BACK");
            this.navigator.addEventFilter(MouseEvent.MOUSE_CLICKED, e -> {
                if (e.getButton() == button) {
                    this.back();
                    e.consume();
                }
            });
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public Decorator getDecorator() {
        return this.decorator;
    }

    private void updateBackground() {
        int currentCount = ++this.changeBackgroundCount;
        Task.supplyAsync(Schedulers.io(), this::getBackground).setName("Update background").whenComplete(Schedulers.javafx(), (background, exception) -> {
            if (exception == null) {
                if (this.changeBackgroundCount == currentCount) {
                    this.decorator.setContentBackground((Background)background);
                }
            } else {
                Logger.LOG.warning("Failed to update background", exception);
            }
        }).start();
    }

    private Background getBackground() {
        EnumBackgroundImage imageType = ConfigHolder.config().getBackgroundImageType();
        Image image = null;
        switch (imageType) {
            case CUSTOM: {
                String backgroundImage = ConfigHolder.config().getBackgroundImage();
                if (backgroundImage == null) break;
                try {
                    image = this.tryLoadImage(Paths.get(backgroundImage, new String[0]));
                }
                catch (Exception e) {
                    Logger.LOG.warning("Couldn't load background image", e);
                }
                break;
            }
            case NETWORK: {
                String backgroundImageUrl = ConfigHolder.config().getBackgroundImageUrl();
                if (backgroundImageUrl == null) break;
                try {
                    image = FXUtils.loadImage(backgroundImageUrl);
                }
                catch (Exception e) {
                    Logger.LOG.warning("Couldn't load background image", e);
                }
                break;
            }
            case CLASSIC: {
                image = FXUtils.newBuiltinImage("/assets/img/background-classic.jpg");
                break;
            }
            case TRANSLUCENT: {
                return new Background(new BackgroundFill[]{new BackgroundFill((Paint)new Color(1.0, 1.0, 1.0, 0.5), CornerRadii.EMPTY, Insets.EMPTY)});
            }
            case PAINT: {
                Paint paint = ConfigHolder.config().getBackgroundPaint();
                double opacity = (double)Lang.clamp(0, ConfigHolder.config().getBackgroundImageOpacity(), 100) / 100.0;
                if (paint instanceof Color || paint == null) {
                    Color color = (Color)paint;
                    if (color == null) {
                        color = Color.WHITE;
                    }
                    if (opacity < 1.0) {
                        color = new Color(color.getRed(), color.getGreen(), color.getBlue(), opacity);
                    }
                    return new Background(new BackgroundFill[]{new BackgroundFill((Paint)color, CornerRadii.EMPTY, Insets.EMPTY)});
                }
                return new Background(new BackgroundFill[]{new BackgroundFill(paint, CornerRadii.EMPTY, Insets.EMPTY)});
            }
        }
        if (image == null) {
            image = this.loadDefaultBackgroundImage();
        }
        return this.createBackgroundWithOpacity(image, ConfigHolder.config().getBackgroundImageOpacity());
    }

    private Background createBackgroundWithOpacity(Image image, int opacity) {
        if (opacity <= 0) {
            return new Background(new BackgroundFill[]{new BackgroundFill((Paint)new Color(1.0, 1.0, 1.0, 0.0), CornerRadii.EMPTY, Insets.EMPTY)});
        }
        if (opacity >= 100) {
            return new Background(new BackgroundImage[]{new BackgroundImage(image, BackgroundRepeat.NO_REPEAT, BackgroundRepeat.NO_REPEAT, BackgroundPosition.DEFAULT, new BackgroundSize(800.0, 480.0, false, false, true, true))});
        }
        WritableImage tempImage = new WritableImage((int)image.getWidth(), (int)image.getHeight());
        PixelReader pixelReader = image.getPixelReader();
        PixelWriter pixelWriter = tempImage.getPixelWriter();
        int y = 0;
        while ((double)y < image.getHeight()) {
            int x = 0;
            while ((double)x < image.getWidth()) {
                Color color = pixelReader.getColor(x, y);
                Color newColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getOpacity() * (double)opacity / 100.0);
                pixelWriter.setColor(x, y, newColor);
                ++x;
            }
            ++y;
        }
        return new Background(new BackgroundImage[]{new BackgroundImage((Image)tempImage, BackgroundRepeat.NO_REPEAT, BackgroundRepeat.NO_REPEAT, BackgroundPosition.DEFAULT, new BackgroundSize(800.0, 480.0, false, false, true, true))});
    }

    private Image loadDefaultBackgroundImage() {
        Image image = this.randomImageIn(Metadata.HMCL_CURRENT_DIRECTORY.resolve("background"));
        if (image != null) {
            return image;
        }
        for (String extension : FXUtils.IMAGE_EXTENSIONS) {
            image = this.tryLoadImage(Metadata.HMCL_CURRENT_DIRECTORY.resolve("background." + extension));
            if (image == null) continue;
            return image;
        }
        image = this.randomImageIn(Metadata.CURRENT_DIRECTORY.resolve("bg"));
        if (image != null) {
            return image;
        }
        for (String extension : FXUtils.IMAGE_EXTENSIONS) {
            image = this.tryLoadImage(Metadata.CURRENT_DIRECTORY.resolve("background." + extension));
            if (image == null) continue;
            return image;
        }
        return FXUtils.newBuiltinImage("/assets/img/background.jpg");
    }

    @Nullable
    private Image randomImageIn(Path imageDir) {
        List candidates;
        if (!Files.isDirectory(imageDir, new LinkOption[0])) {
            return null;
        }
        try (Stream<Path> stream = Files.list(imageDir);){
            candidates = stream.filter(it -> FXUtils.IMAGE_EXTENSIONS.contains(FileUtils.getExtension(it).toLowerCase(Locale.ROOT))).filter(Files::isReadable).collect(Collectors.toList());
        }
        catch (IOException e) {
            Logger.LOG.warning("Failed to list files in ./bg", e);
            return null;
        }
        Random rnd = new Random();
        while (!candidates.isEmpty()) {
            int selected = rnd.nextInt(candidates.size());
            Image loaded = this.tryLoadImage((Path)candidates.get(selected));
            if (loaded != null) {
                return loaded;
            }
            candidates.remove(selected);
        }
        return null;
    }

    @Nullable
    private Image tryLoadImage(Path path) {
        if (!Files.isReadable(path)) {
            return null;
        }
        try {
            return FXUtils.loadImage(path);
        }
        catch (Exception e) {
            Logger.LOG.warning("Couldn't load background image", e);
            return null;
        }
    }

    public void navigate(Node node) {
        this.navigator.navigate(node, animation);
    }

    private void close() {
        if (this.navigator.getCurrentPage() instanceof DecoratorPage) {
            DecoratorPage page = (DecoratorPage)this.navigator.getCurrentPage();
            page.closePage();
            if (page.isPageCloseable()) {
                return;
            }
        }
        this.navigator.clear();
    }

    private void back() {
        if (this.navigator.getCurrentPage() instanceof DecoratorPage) {
            DecoratorPage page = (DecoratorPage)this.navigator.getCurrentPage();
            if (page.back() && this.navigator.canGoBack()) {
                this.navigator.close();
            }
        } else if (this.navigator.canGoBack()) {
            this.navigator.close();
        }
    }

    private void refresh() {
        Refreshable refreshable;
        if (this.navigator.getCurrentPage() instanceof Refreshable && (refreshable = (Refreshable)this.navigator.getCurrentPage()).refreshableProperty().get()) {
            refreshable.refresh();
        }
    }

    private void onNavigated(Navigator.NavigationEvent event) {
        if (event.getSource() != this.navigator) {
            return;
        }
        Node to = event.getNode();
        if (to instanceof Refreshable) {
            this.decorator.canRefreshProperty().bind((ObservableValue)((Refreshable)to).refreshableProperty());
        } else {
            this.decorator.canRefreshProperty().unbind();
            this.decorator.canRefreshProperty().set(false);
        }
        this.decorator.canCloseProperty().set(this.navigator.size() > 2);
        if (to instanceof DecoratorPage) {
            this.decorator.showCloseAsHomeProperty().set(!((DecoratorPage)to).isPageCloseable());
        } else {
            this.decorator.showCloseAsHomeProperty().set(true);
        }
        this.decorator.setNavigationDirection(event.getDirection());
        if (to instanceof DecoratorPage) {
            this.decorator.stateProperty().bind(((DecoratorPage)to).stateProperty());
        } else {
            this.decorator.stateProperty().unbind();
            this.decorator.stateProperty().set((Object)new DecoratorPage.State("", null, this.navigator.canGoBack(), false, true));
        }
        if (to instanceof Region) {
            Region region = (Region)to;
            StackPane parent = (StackPane)region.getParent();
            region.prefWidthProperty().bind((ObservableValue)parent.widthProperty());
            region.prefHeightProperty().bind((ObservableValue)parent.heightProperty());
        }
    }

    public void showDialog(final Node node) {
        FXUtils.checkFxUserThread();
        if (this.dialog == null) {
            if (this.decorator.getDrawerWrapper() == null) {
                Platform.runLater(() -> this.showDialog(node));
                return;
            }
            this.dialog = new JFXDialog();
            this.dialogPane = new JFXDialogPane();
            this.dialog.setContent((Region)this.dialogPane);
            this.decorator.capableDraggingWindow((Node)this.dialog);
            this.decorator.forbidDraggingWindow((Node)this.dialogPane);
            this.dialog.setDialogContainer(this.decorator.getDrawerWrapper());
            this.dialog.setOverlayClose(false);
            this.dialog.show();
            this.navigator.setDisable(true);
        }
        this.dialogPane.push(node);
        EventHandler handler = event -> this.closeDialog(node);
        node.getProperties().put((Object)PROPERTY_DIALOG_CLOSE_HANDLER, (Object)handler);
        node.addEventHandler(DialogCloseEvent.CLOSE, handler);
        if (this.dialog.isVisible()) {
            this.dialog.requestFocus();
            if (node instanceof DialogAware) {
                ((DialogAware)node).onDialogShown();
            }
        } else {
            this.dialog.visibleProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                    if (newValue.booleanValue()) {
                        DecoratorController.this.dialog.requestFocus();
                        if (node instanceof DialogAware) {
                            ((DialogAware)node).onDialogShown();
                        }
                        observable.removeListener((ChangeListener)this);
                    }
                }
            });
        }
    }

    private void closeDialog(Node node) {
        FXUtils.checkFxUserThread();
        Optional.ofNullable(node.getProperties().get((Object)PROPERTY_DIALOG_CLOSE_HANDLER)).ifPresent(handler -> node.removeEventHandler(DialogCloseEvent.CLOSE, (EventHandler)handler));
        if (this.dialog != null) {
            JFXDialogPane pane = this.dialogPane;
            if (pane.size() == 1 && pane.peek().orElse(null) == node) {
                this.dialog.setOnDialogClosed((EventHandler<? super JFXDialogEvent>)((EventHandler)e -> pane.pop(node)));
                this.dialog.close();
                this.dialog = null;
                this.dialogPane = null;
                this.navigator.setDisable(false);
            } else {
                pane.pop(node);
            }
            if (node instanceof DialogAware) {
                ((DialogAware)node).onDialogClosed();
            }
        }
    }

    public void showToast(String content) {
        this.decorator.getSnackbar().fireEvent(new JFXSnackbar.SnackbarEvent(content, null, 2000L, false, null));
    }

    public void startWizard(WizardProvider wizardProvider) {
        this.startWizard(wizardProvider, null);
    }

    public void startWizard(WizardProvider wizardProvider, String category) {
        FXUtils.checkFxUserThread();
        this.navigator.navigate((Node)new DecoratorWizardDisplayer(wizardProvider, category), ContainerAnimations.FADE);
    }

    private void setupAuthlibInjectorDnD() {
        this.decorator.addEventFilter(DragEvent.DRAG_OVER, AuthlibInjectorDnD.dragOverHandler());
        this.decorator.addEventFilter(DragEvent.DRAG_DROPPED, AuthlibInjectorDnD.dragDroppedHandler(url -> Controllers.dialog((Region)new AddAuthlibInjectorServerPane((String)url))));
    }
}

