/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.decorator;

import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.construct.Navigator;
import org.jackhuang.hmcl.ui.construct.PageCloseEvent;
import org.jackhuang.hmcl.ui.decorator.DecoratorPage;
import org.jackhuang.hmcl.ui.decorator.DecoratorTransitionPage;
import org.jackhuang.hmcl.ui.wizard.Navigation;
import org.jackhuang.hmcl.ui.wizard.Refreshable;
import org.jackhuang.hmcl.ui.wizard.TaskExecutorDialogWizardDisplayer;
import org.jackhuang.hmcl.ui.wizard.WizardController;
import org.jackhuang.hmcl.ui.wizard.WizardDisplayer;
import org.jackhuang.hmcl.ui.wizard.WizardPage;
import org.jackhuang.hmcl.ui.wizard.WizardProvider;

public class DecoratorWizardDisplayer
extends DecoratorTransitionPage
implements WizardDisplayer {
    private final WizardController wizardController = new WizardController(this);
    private final WizardDisplayer displayer = new TaskExecutorDialogWizardDisplayer(new ConcurrentLinkedQueue()){

        @Override
        public void onEnd() {
            super.onEnd();
            DecoratorWizardDisplayer.this.fireEvent(new PageCloseEvent());
        }

        @Override
        public void navigateTo(Node page, Navigation.NavigationDirection nav) {
        }
    };
    private final String category;

    public DecoratorWizardDisplayer(WizardProvider provider) {
        this(provider, null);
    }

    public DecoratorWizardDisplayer(WizardProvider provider, String category) {
        this.category = category;
        this.wizardController.setProvider(provider);
        this.wizardController.onStart();
        this.addEventHandler(Navigator.NavigationEvent.NAVIGATED, this::onDecoratorPageNavigating);
    }

    @Override
    public void onStart() {
        this.displayer.onStart();
    }

    @Override
    public void onCancel() {
        this.displayer.onCancel();
    }

    @Override
    public void onEnd() {
        this.displayer.onEnd();
    }

    @Override
    public void navigateTo(Node page, Navigation.NavigationDirection nav) {
        this.displayer.navigateTo(page, nav);
        this.navigate(page, nav.getAnimation());
        String prefix = this.category == null ? "" : this.category + " - ";
        Object title = page instanceof WizardPage ? prefix + ((WizardPage)page).getTitle() : "";
        this.state.set((Object)new DecoratorPage.State((String)title, null, true, this.refreshableProperty().get(), true));
        if (page instanceof Refreshable) {
            this.refreshableProperty().bind((ObservableValue)((Refreshable)page).refreshableProperty());
        } else {
            this.refreshableProperty().unbind();
            this.refreshableProperty().set(false);
        }
    }

    @Override
    public void handleTask(Map<String, Object> settings, Task<?> task) {
        this.displayer.handleTask(settings, task);
    }

    @Override
    public boolean isPageCloseable() {
        return true;
    }

    @Override
    public void closePage() {
        this.wizardController.onCancel();
    }

    @Override
    public boolean back() {
        if (this.wizardController.canPrev()) {
            this.wizardController.onPrev(true);
            return false;
        }
        return true;
    }

    @Override
    public void refresh() {
        ((Refreshable)this.getCurrentPage()).refresh();
    }

    protected Skin createDefaultSkin() {
        return new Skin(this);
    }

    private static class Skin
    extends SkinBase<DecoratorWizardDisplayer> {
        protected Skin(DecoratorWizardDisplayer control) {
            super((Control)control);
            this.getChildren().setAll((Object[])new Node[]{control.transitionPane});
        }
    }
}

