/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.download;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXTextField;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.InstallerItem;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.download.VersionsPage;
import org.jackhuang.hmcl.ui.wizard.WizardController;
import org.jackhuang.hmcl.ui.wizard.WizardPage;
import org.jackhuang.hmcl.util.i18n.I18n;

public abstract class AbstractInstallersPage
extends Control
implements WizardPage {
    protected final WizardController controller;
    protected InstallerItem.InstallerItemGroup group;
    protected JFXTextField txtName = new JFXTextField();
    protected BooleanProperty installable = new SimpleBooleanProperty();

    public AbstractInstallersPage(WizardController controller, String gameVersion, DownloadProvider downloadProvider) {
        this.controller = controller;
        this.group = new InstallerItem.InstallerItemGroup(gameVersion, this.getInstallerItemStyle());
        for (InstallerItem library : this.group.getLibraries()) {
            String libraryId = library.getLibraryId();
            if (libraryId.equals(LibraryAnalyzer.LibraryType.MINECRAFT.getPatchId())) continue;
            library.setOnInstall(() -> {
                if (LibraryAnalyzer.LibraryType.FABRIC_API.getPatchId().equals(libraryId)) {
                    Controllers.dialog(I18n.i18n("install.installer.fabric-api.warning"), I18n.i18n("message.warning"), MessageDialogPane.MessageType.WARNING);
                }
                if (!(library.resolvedStateProperty().get() instanceof InstallerItem.IncompatibleState)) {
                    controller.onNext((Node)new VersionsPage(controller, I18n.i18n("install.installer.choose", I18n.i18n("install.installer." + libraryId)), gameVersion, downloadProvider, libraryId, () -> controller.onPrev(false)));
                }
            });
            library.setOnRemove(() -> {
                controller.getSettings().remove(libraryId);
                this.reload();
            });
        }
    }

    protected InstallerItem.Style getInstallerItemStyle() {
        return InstallerItem.Style.CARD;
    }

    @Override
    public abstract String getTitle();

    protected abstract void reload();

    @Override
    public void onNavigate(Map<String, Object> settings) {
        this.reload();
    }

    @Override
    public abstract void cleanup(Map<String, Object> var1);

    protected abstract void onInstall();

    protected Skin<?> createDefaultSkin() {
        return new InstallersPageSkin(this);
    }

    protected static class InstallersPageSkin
    extends SkinBase<AbstractInstallersPage> {
        protected InstallersPageSkin(AbstractInstallersPage control) {
            super((Control)control);
            BorderPane root = new BorderPane();
            root.setPadding(new Insets(16.0));
            HBox versionNamePane = new HBox(8.0);
            versionNamePane.getStyleClass().add((Object)"card-non-transparent");
            versionNamePane.setStyle("-fx-padding: 20 8 20 16");
            versionNamePane.setAlignment(Pos.CENTER_LEFT);
            control.txtName.setMaxWidth(300.0);
            versionNamePane.getChildren().setAll((Object[])new Node[]{new Label(I18n.i18n("version.name")), control.txtName});
            root.setTop((Node)versionNamePane);
            InstallerItem[] libraries = control.group.getLibraries();
            FlowPane libraryPane = new FlowPane((Node[])libraries);
            libraryPane.setVgap(16.0);
            libraryPane.setHgap(16.0);
            if (libraries.length <= 8) {
                BorderPane.setMargin((Node)libraryPane, (Insets)new Insets(16.0, 0.0, 16.0, 0.0));
                root.setCenter((Node)libraryPane);
            } else {
                ScrollPane scrollPane = new ScrollPane((Node)libraryPane);
                scrollPane.setFitToWidth(true);
                scrollPane.setFitToHeight(true);
                BorderPane.setMargin((Node)scrollPane, (Insets)new Insets(16.0, 0.0, 16.0, 0.0));
                root.setCenter((Node)scrollPane);
            }
            JFXButton installButton = FXUtils.newRaisedButton(I18n.i18n("button.install"));
            installButton.disableProperty().bind((ObservableValue)control.installable.not());
            installButton.setPrefWidth(100.0);
            installButton.setPrefHeight(40.0);
            installButton.setOnAction(e -> control.onInstall());
            BorderPane.setAlignment((Node)installButton, (Pos)Pos.CENTER_RIGHT);
            root.setBottom((Node)installButton);
            this.getChildren().setAll((Object[])new Node[]{root});
        }
    }
}

