/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.download;

import com.jfoenix.controls.JFXButton;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.function.Supplier;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import org.jackhuang.hmcl.download.DefaultDependencyManager;
import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.download.GameBuilder;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.download.RemoteVersion;
import org.jackhuang.hmcl.download.game.GameRemoteVersion;
import org.jackhuang.hmcl.mod.RemoteMod;
import org.jackhuang.hmcl.mod.curse.CurseForgeRemoteModRepository;
import org.jackhuang.hmcl.mod.modrinth.ModrinthRemoteModRepository;
import org.jackhuang.hmcl.setting.DownloadProviders;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.setting.Profiles;
import org.jackhuang.hmcl.task.FileDownloadTask;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.WeakListenerHolder;
import org.jackhuang.hmcl.ui.animation.ContainerAnimations;
import org.jackhuang.hmcl.ui.animation.TransitionPane;
import org.jackhuang.hmcl.ui.construct.AdvancedListBox;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.TabControl;
import org.jackhuang.hmcl.ui.construct.TabHeader;
import org.jackhuang.hmcl.ui.decorator.DecoratorAnimatedPage;
import org.jackhuang.hmcl.ui.decorator.DecoratorPage;
import org.jackhuang.hmcl.ui.download.InstallersPage;
import org.jackhuang.hmcl.ui.download.UpdateInstallerWizardProvider;
import org.jackhuang.hmcl.ui.download.VersionsPage;
import org.jackhuang.hmcl.ui.versions.DownloadListPage;
import org.jackhuang.hmcl.ui.versions.HMCLLocalizedDownloadListPage;
import org.jackhuang.hmcl.ui.versions.VersionPage;
import org.jackhuang.hmcl.ui.versions.Versions;
import org.jackhuang.hmcl.ui.wizard.Navigation;
import org.jackhuang.hmcl.ui.wizard.WizardController;
import org.jackhuang.hmcl.ui.wizard.WizardProvider;
import org.jackhuang.hmcl.util.TaskCancellationAction;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jetbrains.annotations.Nullable;

public class DownloadPage
extends DecoratorAnimatedPage
implements DecoratorPage {
    private final ReadOnlyObjectWrapper<DecoratorPage.State> state = new ReadOnlyObjectWrapper((Object)DecoratorPage.State.fromTitle(I18n.i18n("download"), -1.0));
    private final TabHeader tab;
    private final TabControl.Tab<VersionsPage> newGameTab = new TabControl.Tab("newGameTab");
    private final TabControl.Tab<DownloadListPage> modTab = new TabControl.Tab("modTab");
    private final TabControl.Tab<DownloadListPage> modpackTab = new TabControl.Tab("modpackTab");
    private final TabControl.Tab<DownloadListPage> resourcePackTab = new TabControl.Tab("resourcePackTab");
    private final TabControl.Tab<DownloadListPage> shaderTab = new TabControl.Tab("shaderTab");
    private final TabControl.Tab<DownloadListPage> worldTab = new TabControl.Tab("worldTab");
    private final TransitionPane transitionPane = new TransitionPane();
    private final DownloadNavigator versionPageNavigator = new DownloadNavigator();
    private WeakListenerHolder listenerHolder;

    public DownloadPage() {
        this(null);
    }

    public DownloadPage(String uploadVersion) {
        this.newGameTab.setNodeSupplier(DownloadPage.loadVersionFor(() -> new VersionsPage(this.versionPageNavigator, I18n.i18n("install.installer.choose", I18n.i18n("install.installer.game")), "", DownloadProviders.getDownloadProvider(), "game", this.versionPageNavigator::onGameSelected)));
        this.modpackTab.setNodeSupplier(DownloadPage.loadVersionFor(() -> {
            DownloadListPage page = HMCLLocalizedDownloadListPage.ofModPack((profile, __, file) -> Versions.downloadModpackImpl(profile, uploadVersion, file), false);
            JFXButton installLocalModpackButton = FXUtils.newRaisedButton(I18n.i18n("install.modpack"));
            installLocalModpackButton.setOnAction(e -> Versions.importModpack());
            page.getActions().add((Object)installLocalModpackButton);
            return page;
        }));
        this.modTab.setNodeSupplier(DownloadPage.loadVersionFor(() -> HMCLLocalizedDownloadListPage.ofMod((profile, version, file) -> DownloadPage.download(profile, version, file, "mods"), true)));
        this.resourcePackTab.setNodeSupplier(DownloadPage.loadVersionFor(() -> HMCLLocalizedDownloadListPage.ofResourcePack((profile, version, file) -> DownloadPage.download(profile, version, file, "resourcepacks"), true)));
        this.shaderTab.setNodeSupplier(DownloadPage.loadVersionFor(() -> new DownloadListPage(ModrinthRemoteModRepository.SHADER_PACKS, (profile, version, file) -> DownloadPage.download(profile, version, file, "shaderpacks"), true)));
        this.worldTab.setNodeSupplier(DownloadPage.loadVersionFor(() -> new DownloadListPage(CurseForgeRemoteModRepository.WORLDS)));
        this.tab = new TabHeader(this.newGameTab, this.modpackTab, this.modTab, this.resourcePackTab, this.shaderTab, this.worldTab);
        Profiles.registerVersionsListener(this::loadVersions);
        this.tab.select(this.newGameTab);
        FXUtils.onChangeAndOperate(this.tab.getSelectionModel().selectedItemProperty(), newValue -> this.transitionPane.setContent((Node)newValue.getNode(), ContainerAnimations.FADE));
        AdvancedListBox sideBar = new AdvancedListBox().startCategory(I18n.i18n("download.game").toUpperCase(Locale.ROOT)).addNavigationDrawerTab(this.tab, this.newGameTab, I18n.i18n("game"), SVG.STADIA_CONTROLLER).addNavigationDrawerTab(this.tab, this.modpackTab, I18n.i18n("modpack"), SVG.PACKAGE2).startCategory(I18n.i18n("download.content").toUpperCase(Locale.ROOT)).addNavigationDrawerTab(this.tab, this.modTab, I18n.i18n("mods"), SVG.EXTENSION).addNavigationDrawerTab(this.tab, this.resourcePackTab, I18n.i18n("resourcepack"), SVG.TEXTURE).addNavigationDrawerTab(this.tab, this.shaderTab, I18n.i18n("download.shader"), SVG.WB_SUNNY).addNavigationDrawerTab(this.tab, this.worldTab, I18n.i18n("world"), SVG.PUBLIC);
        FXUtils.setLimitWidth((Region)sideBar, 200.0);
        this.setLeft(new Node[]{sideBar});
        this.setCenter(new Node[]{this.transitionPane});
    }

    private void selectTabIfCurseForgeAvailable(TabControl.Tab<?> newTab) {
        if (CurseForgeRemoteModRepository.isAvailable()) {
            this.tab.select(newTab);
        } else {
            Controllers.dialog(I18n.i18n("download.curseforge.unavailable"));
        }
    }

    private static <T extends Node> Supplier<T> loadVersionFor(Supplier<T> nodeSupplier) {
        return () -> {
            Node node = (Node)nodeSupplier.get();
            if (node instanceof VersionPage.VersionLoadable) {
                ((VersionPage.VersionLoadable)node).loadVersion(Profiles.getSelectedProfile(), null);
            }
            return node;
        };
    }

    public static void download(Profile profile, @Nullable String version, RemoteMod.Version file, String subdirectoryName) {
        if (version == null) {
            version = profile.getSelectedVersion();
        }
        Path runDirectory = profile.getRepository().hasVersion(version) ? profile.getRepository().getRunDirectory(version).toPath() : profile.getRepository().getBaseDirectory().toPath();
        Controllers.prompt(I18n.i18n("archive.file.name"), (result, resolve, reject) -> {
            if (!OperatingSystem.isNameValid(result)) {
                reject.accept(I18n.i18n("install.new_game.malformed"));
                return;
            }
            Path dest = runDirectory.resolve(subdirectoryName).resolve((String)result);
            Controllers.taskDialog(Task.composeAsync(() -> {
                FileDownloadTask task = new FileDownloadTask(file.getFile().getUrl(), dest);
                task.setName(file.getName());
                return task;
            }).whenComplete(Schedulers.javafx(), exception -> {
                if (exception != null) {
                    if (exception instanceof CancellationException) {
                        Controllers.showToast(I18n.i18n("message.cancelled"));
                    } else {
                        Controllers.dialog(DownloadProviders.localizeErrorMessage(exception), I18n.i18n("install.failed.downloading"), MessageDialogPane.MessageType.ERROR);
                    }
                } else {
                    Controllers.showToast(I18n.i18n("install.success"));
                }
            }), I18n.i18n("message.downloading"), TaskCancellationAction.NORMAL);
            resolve.run();
        }, file.getFile().getFilename());
    }

    private void loadVersions(Profile profile) {
        this.listenerHolder = new WeakListenerHolder();
        FXUtils.runInFX(() -> {
            if (profile == Profiles.getSelectedProfile()) {
                this.listenerHolder.add(FXUtils.onWeakChangeAndOperate(profile.selectedVersionProperty(), version -> {
                    if (this.modTab.isInitialized()) {
                        this.modTab.getNode().loadVersion(profile, null);
                    }
                    if (this.modpackTab.isInitialized()) {
                        this.modpackTab.getNode().loadVersion(profile, null);
                    }
                    if (this.resourcePackTab.isInitialized()) {
                        this.resourcePackTab.getNode().loadVersion(profile, null);
                    }
                    if (this.shaderTab.isInitialized()) {
                        this.shaderTab.getNode().loadVersion(profile, null);
                    }
                    if (this.worldTab.isInitialized()) {
                        this.worldTab.getNode().loadVersion(profile, null);
                    }
                }));
            }
        });
    }

    @Override
    public ReadOnlyObjectProperty<DecoratorPage.State> stateProperty() {
        return this.state.getReadOnlyProperty();
    }

    public void showGameDownloads() {
        this.tab.select(this.newGameTab);
    }

    public void showModpackDownloads() {
        this.tab.select(this.modpackTab);
    }

    public DownloadListPage showModDownloads() {
        this.tab.select(this.modTab);
        return this.modTab.getNode();
    }

    public void showWorldDownloads() {
        this.tab.select(this.worldTab);
    }

    private static final class DownloadNavigator
    implements Navigation {
        private final Map<String, Object> settings = new HashMap<String, Object>();

        private DownloadNavigator() {
        }

        @Override
        public void onStart() {
        }

        @Override
        public void onNext() {
        }

        @Override
        public void onPrev(boolean cleanUp) {
        }

        @Override
        public boolean canPrev() {
            return false;
        }

        @Override
        public void onFinish() {
        }

        @Override
        public void onEnd() {
        }

        @Override
        public void onCancel() {
        }

        @Override
        public Map<String, Object> getSettings() {
            return this.settings;
        }

        public void onGameSelected() {
            Profile profile = Profiles.getSelectedProfile();
            if (profile.getRepository().isLoaded()) {
                Controllers.getDecorator().startWizard(new VanillaInstallWizardProvider(profile, (GameRemoteVersion)this.settings.get("game")), I18n.i18n("install.new_game"));
            }
        }
    }

    private static class VanillaInstallWizardProvider
    implements WizardProvider {
        private final Profile profile;
        private final DefaultDependencyManager dependencyManager;
        private final DownloadProvider downloadProvider;
        private final GameRemoteVersion gameVersion;
        public static final String PROFILE = "PROFILE";

        public VanillaInstallWizardProvider(Profile profile, GameRemoteVersion gameVersion) {
            this.profile = profile;
            this.gameVersion = gameVersion;
            this.downloadProvider = DownloadProviders.getDownloadProvider();
            this.dependencyManager = profile.getDependency(this.downloadProvider);
        }

        @Override
        public void start(Map<String, Object> settings) {
            settings.put(PROFILE, this.profile);
            settings.put(LibraryAnalyzer.LibraryType.MINECRAFT.getPatchId(), this.gameVersion);
        }

        private Task<Void> finishVersionDownloadingAsync(Map<String, Object> settings) {
            GameBuilder builder = this.dependencyManager.gameBuilder();
            String name = (String)settings.get("name");
            builder.name(name);
            builder.gameVersion(((RemoteVersion)settings.get(LibraryAnalyzer.LibraryType.MINECRAFT.getPatchId())).getGameVersion());
            for (Map.Entry<String, Object> entry : settings.entrySet()) {
                if (LibraryAnalyzer.LibraryType.MINECRAFT.getPatchId().equals(entry.getKey()) || !(entry.getValue() instanceof RemoteVersion)) continue;
                builder.version((RemoteVersion)entry.getValue());
            }
            return builder.buildAsync().whenComplete(any -> this.profile.getRepository().refreshVersions()).thenRunAsync(Schedulers.javafx(), () -> this.profile.setSelectedVersion(name));
        }

        @Override
        public Object finish(Map<String, Object> settings) {
            settings.put("title", I18n.i18n("install.new_game.installation"));
            settings.put("success_message", I18n.i18n("install.success"));
            settings.put("failure_callback", (settings1, exception, next) -> UpdateInstallerWizardProvider.alertFailureMessage(exception, next));
            return this.finishVersionDownloadingAsync(settings);
        }

        @Override
        public Node createPage(WizardController controller, int step, Map<String, Object> settings) {
            switch (step) {
                case 0: {
                    return new InstallersPage(controller, this.profile.getRepository(), ((RemoteVersion)controller.getSettings().get("game")).getGameVersion(), this.downloadProvider);
                }
            }
            throw new IllegalStateException("error step " + step + ", settings: " + settings + ", pages: " + controller.getPages());
        }

        @Override
        public boolean cancel() {
            return true;
        }
    }
}

