/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.download;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXListView;
import com.jfoenix.controls.JFXSpinner;
import com.jfoenix.controls.JFXTextField;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Paint;
import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.download.RemoteVersion;
import org.jackhuang.hmcl.download.VersionList;
import org.jackhuang.hmcl.download.fabric.FabricAPIRemoteVersion;
import org.jackhuang.hmcl.download.fabric.FabricRemoteVersion;
import org.jackhuang.hmcl.download.forge.ForgeRemoteVersion;
import org.jackhuang.hmcl.download.game.GameRemoteVersion;
import org.jackhuang.hmcl.download.liteloader.LiteLoaderRemoteVersion;
import org.jackhuang.hmcl.download.neoforge.NeoForgeRemoteVersion;
import org.jackhuang.hmcl.download.optifine.OptiFineRemoteVersion;
import org.jackhuang.hmcl.download.quilt.QuiltAPIRemoteVersion;
import org.jackhuang.hmcl.download.quilt.QuiltRemoteVersion;
import org.jackhuang.hmcl.setting.Theme;
import org.jackhuang.hmcl.setting.VersionIconType;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.animation.ContainerAnimations;
import org.jackhuang.hmcl.ui.animation.TransitionPane;
import org.jackhuang.hmcl.ui.construct.ComponentList;
import org.jackhuang.hmcl.ui.construct.IconedTwoLineListItem;
import org.jackhuang.hmcl.ui.construct.RipplerContainer;
import org.jackhuang.hmcl.ui.construct.SpinnerPane;
import org.jackhuang.hmcl.ui.wizard.Navigation;
import org.jackhuang.hmcl.ui.wizard.Refreshable;
import org.jackhuang.hmcl.ui.wizard.WizardPage;
import org.jackhuang.hmcl.util.Holder;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.versioning.GameVersionNumber;

public final class VersionsPage
extends Control
implements WizardPage,
Refreshable {
    private final String gameVersion;
    private final String libraryId;
    private final String title;
    private final Navigation navigation;
    private final VersionList<?> versionList;
    private final Runnable callback;
    private final ObservableList<RemoteVersion> versions = FXCollections.observableArrayList();
    private final ObjectProperty<Status> status = new SimpleObjectProperty((Object)Status.LOADING);

    public VersionsPage(Navigation navigation, String title, String gameVersion, DownloadProvider downloadProvider, String libraryId, Runnable callback) {
        this.title = title;
        this.gameVersion = gameVersion;
        this.libraryId = libraryId;
        this.navigation = navigation;
        this.versionList = downloadProvider.getVersionListById(libraryId);
        this.callback = callback;
        this.refresh();
    }

    protected Skin<?> createDefaultSkin() {
        return new VersionsPageSkin(this);
    }

    @Override
    public void refresh() {
        this.status.set((Object)Status.LOADING);
        Task<Void> task = this.versionList.refreshAsync(this.gameVersion).thenSupplyAsync(() -> this.versionList.getVersions(this.gameVersion).stream().sorted().collect(Collectors.toList())).whenComplete(Schedulers.javafx(), (items, exception) -> {
            if (exception == null) {
                this.versions.setAll((Collection)items);
                this.status.set((Object)Status.SUCCESS);
            } else {
                Logger.LOG.warning("Failed to fetch versions list", exception);
                this.status.set((Object)Status.FAILED);
            }
        });
        task.start();
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void cleanup(Map<String, Object> settings) {
        settings.remove(this.libraryId);
    }

    private void onRefresh() {
        this.refresh();
    }

    private void onBack() {
        this.navigation.onPrev(true);
    }

    private void onSponsor() {
        FXUtils.openLink("https://bmclapidoc.bangbang93.com");
    }

    private static enum Status {
        LOADING,
        FAILED,
        SUCCESS;

    }

    private static final class VersionsPageSkin
    extends SkinBase<VersionsPage> {
        private final JFXListView<RemoteVersion> list;
        private final TransitionPane transitionPane;
        private final JFXSpinner spinner;
        private final JFXTextField nameField;
        private final JFXComboBox<VersionTypeFilter> categoryField = new JFXComboBox();

        VersionsPageSkin(VersionsPage control) {
            super((Control)control);
            BorderPane root = new BorderPane();
            GridPane searchPane = new GridPane();
            root.setTop((Node)searchPane);
            searchPane.getStyleClass().addAll((Object[])new String[]{"card"});
            BorderPane.setMargin((Node)searchPane, (Insets)new Insets(10.0, 10.0, 0.0, 10.0));
            ColumnConstraints nameColumn = new ColumnConstraints();
            nameColumn.setMinWidth(Double.NEGATIVE_INFINITY);
            ColumnConstraints column1 = new ColumnConstraints();
            column1.setHgrow(Priority.ALWAYS);
            ColumnConstraints column2 = new ColumnConstraints();
            column2.setMaxWidth(150.0);
            ColumnConstraints column3 = new ColumnConstraints();
            if (control.versionList.hasType()) {
                searchPane.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{nameColumn, column1, nameColumn, column2, column3});
            } else {
                searchPane.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{nameColumn, column1, column3});
            }
            searchPane.setHgap(16.0);
            searchPane.setVgap(10.0);
            int rowIndex = 0;
            this.nameField = new JFXTextField();
            this.nameField.setPromptText(I18n.i18n("version.search.prompt"));
            this.nameField.textProperty().addListener(o -> this.updateList());
            if ("game".equals(control.libraryId)) {
                this.categoryField.getItems().setAll((Object[])new VersionTypeFilter[]{VersionTypeFilter.ALL, VersionTypeFilter.RELEASE, VersionTypeFilter.SNAPSHOTS, VersionTypeFilter.APRIL_FOOLS, VersionTypeFilter.OLD});
                this.categoryField.getSelectionModel().select((Object)VersionTypeFilter.RELEASE);
            } else {
                this.categoryField.getItems().setAll((Object[])new VersionTypeFilter[]{VersionTypeFilter.ALL, VersionTypeFilter.RELEASE, VersionTypeFilter.SNAPSHOTS});
                this.categoryField.getSelectionModel().select((Object)VersionTypeFilter.ALL);
            }
            this.categoryField.setConverter(FXUtils.stringConverter(type -> I18n.i18n("version.game." + type.name().toLowerCase(Locale.ROOT))));
            this.categoryField.getSelectionModel().selectedItemProperty().addListener(o -> this.updateList());
            JFXButton refreshButton = FXUtils.newRaisedButton(I18n.i18n("button.refresh"));
            refreshButton.setOnAction(event -> control.onRefresh());
            if (control.versionList.hasType()) {
                searchPane.addRow(rowIndex++, new Node[]{new Label(I18n.i18n("version.search")), this.nameField, new Label(I18n.i18n("version.game.type")), this.categoryField, refreshButton});
            } else {
                searchPane.addRow(rowIndex++, new Node[]{new Label(I18n.i18n("version.search")), this.nameField, refreshButton});
            }
            SpinnerPane spinnerPane = new SpinnerPane();
            root.setCenter((Node)spinnerPane);
            this.transitionPane = new TransitionPane();
            this.spinner = new JFXSpinner();
            StackPane centerWrapper = new StackPane();
            centerWrapper.setStyle("-fx-padding: 10;");
            ComponentList centrePane = new ComponentList();
            centrePane.getStyleClass().add((Object)"no-padding");
            this.list = new JFXListView();
            this.list.getStyleClass().add((Object)"jfx-list-view-float");
            VBox.setVgrow(this.list, (Priority)Priority.ALWAYS);
            control.versions.addListener(o -> this.updateList());
            Holder lastCell = new Holder();
            this.list.setCellFactory(listView -> new RemoteVersionListCell(lastCell, control.libraryId));
            FXUtils.onClicked(this.list, () -> {
                if (this.list.getSelectionModel().getSelectedIndex() < 0) {
                    return;
                }
                control.navigation.getSettings().put(control.libraryId, this.list.getSelectionModel().getSelectedItem());
                control.callback.run();
            });
            ComponentList.setVgrow(this.list, Priority.ALWAYS);
            FXUtils.ignoreEvent(this.list, KeyEvent.KEY_PRESSED, e -> e.getCode() == KeyCode.ESCAPE);
            centrePane.getContent().setAll((Object[])new Node[]{this.list});
            centerWrapper.getChildren().setAll((Object[])new Node[]{centrePane});
            StackPane failedPane = new StackPane();
            failedPane.getStyleClass().add((Object)"notice-pane");
            Label label = new Label(I18n.i18n("download.failed.refresh"));
            FXUtils.onClicked((Node)label, () -> control.onRefresh());
            failedPane.getChildren().setAll((Object[])new Node[]{label});
            StackPane emptyPane = new StackPane();
            emptyPane.getStyleClass().add((Object)"notice-pane");
            Label label2 = new Label(I18n.i18n("download.failed.empty"));
            FXUtils.onClicked((Node)label2, () -> control.onBack());
            emptyPane.getChildren().setAll((Object[])new Node[]{label2});
            FXUtils.onChangeAndOperate(control.status, status -> {
                if (status == Status.LOADING) {
                    this.transitionPane.setContent((Node)this.spinner, ContainerAnimations.FADE);
                } else if (status == Status.SUCCESS) {
                    this.transitionPane.setContent((Node)centerWrapper, ContainerAnimations.FADE);
                } else {
                    this.transitionPane.setContent((Node)failedPane, ContainerAnimations.FADE);
                }
            });
            root.setCenter((Node)this.transitionPane);
            this.getChildren().setAll((Object[])new Node[]{root});
        }

        private void updateList() {
            String nameQuery;
            Stream<RemoteVersion> versions = ((VersionsPage)this.getSkinnable()).versions.stream();
            VersionTypeFilter filter = (VersionTypeFilter)((Object)this.categoryField.getSelectionModel().getSelectedItem());
            if (filter != null) {
                versions = versions.filter(it -> {
                    RemoteVersion.Type versionType = it.getVersionType();
                    switch (filter) {
                        case RELEASE: {
                            return versionType == RemoteVersion.Type.RELEASE;
                        }
                        case SNAPSHOTS: {
                            return versionType == RemoteVersion.Type.SNAPSHOT || versionType == RemoteVersion.Type.PENDING;
                        }
                        case APRIL_FOOLS: {
                            return versionType == RemoteVersion.Type.SNAPSHOT && GameVersionNumber.asGameVersion(it.getGameVersion()).isSpecial();
                        }
                        case OLD: {
                            return versionType == RemoteVersion.Type.OLD;
                        }
                    }
                    return true;
                });
            }
            if (!StringUtils.isBlank(nameQuery = this.nameField.getText())) {
                if (nameQuery.startsWith("regex:")) {
                    try {
                        Pattern pattern = Pattern.compile(nameQuery.substring("regex:".length()));
                        versions = versions.filter(it -> pattern.matcher(it.getSelfVersion()).find());
                    }
                    catch (Throwable e) {
                        Logger.LOG.warning("Illegal regular expression: " + nameQuery, e);
                    }
                } else {
                    String lowerQueryString = nameQuery.toLowerCase(Locale.ROOT);
                    versions = versions.filter(it -> it.getSelfVersion().toLowerCase(Locale.ROOT).contains(lowerQueryString));
                }
            }
            this.list.getItems().setAll((Collection)versions.collect(Collectors.toList()));
            this.list.scrollTo(0);
        }
    }

    private static class RemoteVersionListCell
    extends ListCell<RemoteVersion> {
        private final IconedTwoLineListItem content = new IconedTwoLineListItem();
        private final RipplerContainer ripplerContainer = new RipplerContainer((Node)this.content);
        private final StackPane pane = new StackPane();
        private final Holder<RemoteVersionListCell> lastCell;

        RemoteVersionListCell(Holder<RemoteVersionListCell> lastCell, String libraryId) {
            this.lastCell = lastCell;
            if ("game".equals(libraryId)) {
                this.content.getExternalLinkButton().setGraphic(SVG.GLOBE_BOOK.createIcon((Paint)Theme.blackFill(), -1.0));
                FXUtils.installFastTooltip((Node)this.content.getExternalLinkButton(), I18n.i18n("wiki.tooltip"));
            }
            this.pane.getStyleClass().add((Object)"md-list-cell");
            StackPane.setMargin((Node)this.content, (Insets)new Insets(10.0, 16.0, 10.0, 16.0));
            this.pane.getChildren().setAll((Object[])new Node[]{this.ripplerContainer});
        }

        public void updateItem(RemoteVersion remoteVersion, boolean empty) {
            super.updateItem((Object)remoteVersion, empty);
            if (this == this.lastCell.value && !this.isVisible()) {
                return;
            }
            this.lastCell.value = this;
            if (empty) {
                this.setGraphic(null);
                return;
            }
            this.setGraphic((Node)this.pane);
            this.content.setTitle(remoteVersion.getSelfVersion());
            if (remoteVersion.getReleaseDate() != null) {
                this.content.setSubtitle(I18n.formatDateTime(remoteVersion.getReleaseDate()));
            } else {
                this.content.setSubtitle(null);
            }
            if (remoteVersion instanceof GameRemoteVersion) {
                RemoteVersion.Type versionType = remoteVersion.getVersionType();
                String wikiSuffix = this.getWikiUrlSuffix(remoteVersion.getGameVersion());
                switch (versionType) {
                    case RELEASE: {
                        this.content.getTags().setAll((Object[])new String[]{I18n.i18n("version.game.release")});
                        this.content.setImage(VersionIconType.GRASS.getIcon());
                        this.content.setExternalLink(I18n.i18n("wiki.version.game", wikiSuffix));
                        break;
                    }
                    case PENDING: 
                    case SNAPSHOT: {
                        if (versionType == RemoteVersion.Type.SNAPSHOT && GameVersionNumber.asGameVersion(remoteVersion.getGameVersion()).isSpecial()) {
                            this.content.getTags().setAll((Object[])new String[]{I18n.i18n("version.game.april_fools")});
                            this.content.setImage(VersionIconType.APRIL_FOOLS.getIcon());
                        } else {
                            this.content.getTags().setAll((Object[])new String[]{I18n.i18n("version.game.snapshot")});
                            this.content.setImage(VersionIconType.COMMAND.getIcon());
                        }
                        this.content.setExternalLink(I18n.i18n("wiki.version.game", wikiSuffix));
                        break;
                    }
                    default: {
                        this.content.getTags().setAll((Object[])new String[]{I18n.i18n("version.game.old")});
                        this.content.setImage(VersionIconType.CRAFT_TABLE.getIcon());
                        this.content.setExternalLink(I18n.i18n("wiki.version.game", wikiSuffix));
                        break;
                    }
                }
            } else {
                VersionIconType iconType = remoteVersion instanceof LiteLoaderRemoteVersion ? VersionIconType.CHICKEN : (remoteVersion instanceof OptiFineRemoteVersion ? VersionIconType.OPTIFINE : (remoteVersion instanceof ForgeRemoteVersion ? VersionIconType.FORGE : (remoteVersion instanceof NeoForgeRemoteVersion ? VersionIconType.NEO_FORGE : (remoteVersion instanceof FabricRemoteVersion || remoteVersion instanceof FabricAPIRemoteVersion ? VersionIconType.FABRIC : (remoteVersion instanceof QuiltRemoteVersion || remoteVersion instanceof QuiltAPIRemoteVersion ? VersionIconType.QUILT : null)))));
                this.content.setImage(iconType != null ? iconType.getIcon() : null);
                if (this.content.getSubtitle() == null) {
                    this.content.setSubtitle(remoteVersion.getGameVersion());
                } else {
                    this.content.getTags().setAll((Object[])new String[]{remoteVersion.getGameVersion()});
                }
                this.content.setExternalLink(null);
            }
        }

        private String getWikiUrlSuffix(String gameVersion) {
            String id;
            switch (id = gameVersion.toLowerCase(Locale.ROOT)) {
                case "0.30-1": 
                case "0.30-2": 
                case "c0.30_01c": {
                    return I18n.i18n("wiki.version.game.search", "Classic_0.30");
                }
                case "in-20100206-2103": {
                    return I18n.i18n("wiki.version.game.search", "Indev_20100206");
                }
                case "inf-20100630-1": {
                    return I18n.i18n("wiki.version.game.search", "Infdev_20100630");
                }
                case "inf-20100630-2": {
                    return I18n.i18n("wiki.version.game.search", "Alpha_v1.0.0");
                }
                case "1.19_deep_dark_experimental_snapshot-1": {
                    return "1.19-exp1";
                }
                case "in-20100130": {
                    return I18n.i18n("wiki.version.game.search", "Indev_0.31_20100130");
                }
                case "b1.6-tb3": {
                    return I18n.i18n("wiki.version.game.search", "Beta_1.6_Test_Build_3");
                }
                case "1.14_combat-212796": {
                    return I18n.i18n("wiki.version.game.search", "1.14.3_-_Combat_Test");
                }
                case "1.14_combat-0": {
                    return I18n.i18n("wiki.version.game.search", "Combat_Test_2");
                }
                case "1.14_combat-3": {
                    return I18n.i18n("wiki.version.game.search", "Combat_Test_3");
                }
                case "1_15_combat-1": {
                    return I18n.i18n("wiki.version.game.search", "Combat_Test_4");
                }
                case "1_15_combat-6": {
                    return I18n.i18n("wiki.version.game.search", "Combat_Test_5");
                }
                case "1_16_combat-0": {
                    return I18n.i18n("wiki.version.game.search", "Combat_Test_6");
                }
                case "1_16_combat-1": {
                    return I18n.i18n("wiki.version.game.search", "Combat_Test_7");
                }
                case "1_16_combat-2": {
                    return I18n.i18n("wiki.version.game.search", "Combat_Test_7b");
                }
                case "1_16_combat-3": {
                    return I18n.i18n("wiki.version.game.search", "Combat_Test_7c");
                }
                case "1_16_combat-4": {
                    return I18n.i18n("wiki.version.game.search", "Combat_Test_8");
                }
                case "1_16_combat-5": {
                    return I18n.i18n("wiki.version.game.search", "Combat_Test_8b");
                }
                case "1_16_combat-6": {
                    return I18n.i18n("wiki.version.game.search", "Combat_Test_8c");
                }
            }
            if (id.startsWith("1.0.0-rc2")) {
                return "RC2";
            }
            if (id.startsWith("2.0")) {
                return I18n.i18n("wiki.version.game.search", "2.0");
            }
            if (id.startsWith("b1.8-pre1")) {
                return "Beta_1.8-pre1";
            }
            if (id.startsWith("b1.1-")) {
                return I18n.i18n("wiki.version.game.search", "Beta_1.1");
            }
            if (id.startsWith("a1.1.0")) {
                return "Alpha_v1.1.0";
            }
            if (id.startsWith("a1.0.14")) {
                return "Alpha_v1.0.14";
            }
            if (id.startsWith("a1.0.13_01")) {
                return "Alpha_v1.0.13_01";
            }
            if (id.startsWith("in-20100214")) {
                return I18n.i18n("wiki.version.game.search", "Indev_20100214");
            }
            if (id.contains("experimental-snapshot")) {
                return id.replace("_experimental-snapshot-", "-exp");
            }
            if (id.startsWith("inf-")) {
                return id.replace("inf-", "Infdev_");
            }
            if (id.startsWith("in-")) {
                return id.replace("in-", "Indev_");
            }
            if (id.startsWith("rd-")) {
                return "pre-Classic_" + id;
            }
            if (id.startsWith("b")) {
                return id.replace("b", "Beta_");
            }
            if (id.startsWith("a")) {
                return id.replace("a", "Alpha_v");
            }
            if (id.startsWith("c")) {
                return id.replace("c", "Classic_").replace("st", "SURVIVAL_TEST");
            }
            return I18n.i18n("wiki.version.game.search", id);
        }
    }

    private static enum VersionTypeFilter {
        ALL,
        RELEASE,
        SNAPSHOTS,
        APRIL_FOOLS,
        OLD;

    }
}

