/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.export;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXSlider;
import com.jfoenix.controls.JFXTextArea;
import com.jfoenix.controls.JFXTextField;
import com.jfoenix.controls.JFXToggleButton;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TextInputControl;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import javafx.util.Callback;
import org.jackhuang.hmcl.auth.Account;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorServer;
import org.jackhuang.hmcl.game.HMCLGameRepository;
import org.jackhuang.hmcl.mod.ModpackExportInfo;
import org.jackhuang.hmcl.mod.mcbbs.McbbsModpackManifest;
import org.jackhuang.hmcl.setting.Accounts;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.setting.VersionSetting;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.ComponentList;
import org.jackhuang.hmcl.ui.construct.HintPane;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.NumberValidator;
import org.jackhuang.hmcl.ui.construct.RequiredValidator;
import org.jackhuang.hmcl.ui.construct.TwoLineListItem;
import org.jackhuang.hmcl.ui.construct.URLValidator;
import org.jackhuang.hmcl.ui.wizard.WizardController;
import org.jackhuang.hmcl.ui.wizard.WizardPage;
import org.jackhuang.hmcl.util.DataSizeUnit;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.JarUtils;
import org.jackhuang.hmcl.util.platform.SystemInfo;

public final class ModpackInfoPage
extends Control
implements WizardPage {
    private final WizardController controller;
    private final HMCLGameRepository gameRepository;
    private final ModpackExportInfo.Options options;
    private final String versionName;
    private final boolean canIncludeLauncher;
    private final ModpackExportInfo exportInfo = new ModpackExportInfo();
    private final SimpleStringProperty name = new SimpleStringProperty("");
    private final SimpleStringProperty author = new SimpleStringProperty("");
    private final SimpleStringProperty version = new SimpleStringProperty("1.0");
    private final SimpleStringProperty description = new SimpleStringProperty("");
    private final SimpleStringProperty url = new SimpleStringProperty("");
    private final SimpleBooleanProperty forceUpdate = new SimpleBooleanProperty();
    private final SimpleBooleanProperty packWithLauncher = new SimpleBooleanProperty();
    private final SimpleStringProperty fileApi = new SimpleStringProperty("");
    private final SimpleIntegerProperty minMemory = new SimpleIntegerProperty(0);
    private final SimpleStringProperty authlibInjectorServer = new SimpleStringProperty();
    private final SimpleStringProperty launchArguments = new SimpleStringProperty("");
    private final SimpleStringProperty javaArguments = new SimpleStringProperty("");
    private final SimpleStringProperty mcbbsThreadId = new SimpleStringProperty("");
    private final SimpleBooleanProperty noCreateRemoteFiles = new SimpleBooleanProperty();
    private final SimpleBooleanProperty skipCurseForgeRemoteFiles = new SimpleBooleanProperty();
    public static final String MODPACK_INFO = "modpack.info";
    public static final String MODPACK_FILE = "modpack.file";
    public static final String MODPACK_INFO_OPTION = "modpack.info.option";

    public ModpackInfoPage(WizardController controller, HMCLGameRepository gameRepository, String version) {
        this.controller = controller;
        this.gameRepository = gameRepository;
        this.options = Lang.tryCast(controller.getSettings().get(MODPACK_INFO_OPTION), ModpackExportInfo.Options.class).orElseThrow(() -> new IllegalArgumentException("Settings.MODPACK_INFO_OPTION is required"));
        this.versionName = version;
        this.name.set(version);
        this.author.set(Optional.ofNullable(Accounts.getSelectedAccount()).map(Account::getUsername).orElse(""));
        VersionSetting versionSetting = gameRepository.getVersionSetting(this.versionName);
        this.minMemory.set(Optional.ofNullable(versionSetting.getMinMemory()).orElse(0).intValue());
        this.launchArguments.set(versionSetting.getMinecraftArgs());
        this.javaArguments.set(versionSetting.getJavaArgs());
        this.canIncludeLauncher = JarUtils.thisJarPath() != null;
    }

    private void onNext() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(I18n.i18n("modpack.wizard.step.initialization.save"));
        if (this.controller.getSettings().get("modpack.type") == "modrinth") {
            fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(I18n.i18n("modpack"), new String[]{"*.mrpack"}));
            fileChooser.setInitialFileName(this.name.get() + ".mrpack");
        } else {
            fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(I18n.i18n("modpack"), new String[]{"*.zip"}));
            fileChooser.setInitialFileName(this.name.get() + ".zip");
        }
        File file = fileChooser.showSaveDialog((Window)Controllers.getStage());
        if (file == null) {
            this.controller.onEnd();
            return;
        }
        this.exportInfo.setName(this.name.get());
        this.exportInfo.setFileApi(this.fileApi.get());
        this.exportInfo.setVersion(this.version.get());
        this.exportInfo.setAuthor(this.author.get());
        this.exportInfo.setDescription(this.description.get());
        this.exportInfo.setPackWithLauncher(this.packWithLauncher.get());
        this.exportInfo.setUrl(this.url.get());
        this.exportInfo.setForceUpdate(this.forceUpdate.get());
        this.exportInfo.setPackWithLauncher(this.packWithLauncher.get());
        this.exportInfo.setMinMemory(this.minMemory.get());
        this.exportInfo.setLaunchArguments(this.launchArguments.get());
        this.exportInfo.setJavaArguments(this.javaArguments.get());
        this.exportInfo.setAuthlibInjectorServer(this.authlibInjectorServer.get());
        this.exportInfo.setNoCreateRemoteFiles(this.noCreateRemoteFiles.get());
        this.exportInfo.setSkipCurseForgeRemoteFiles(this.skipCurseForgeRemoteFiles.get());
        if (StringUtils.isNotBlank(this.mcbbsThreadId.get())) {
            this.exportInfo.setOrigins(Collections.singletonList(new McbbsModpackManifest.Origin("mcbbs", Integer.parseInt(this.mcbbsThreadId.get()))));
        }
        this.controller.getSettings().put(MODPACK_INFO, this.exportInfo);
        this.controller.getSettings().put(MODPACK_FILE, file);
        this.controller.onNext();
    }

    @Override
    public void cleanup(Map<String, Object> settings) {
        this.controller.getSettings().remove(MODPACK_INFO);
    }

    @Override
    public String getTitle() {
        return I18n.i18n("modpack.wizard.step.1.title");
    }

    protected Skin<?> createDefaultSkin() {
        return new ModpackInfoPageSkin(this);
    }

    public static class ModpackInfoPageSkin
    extends SkinBase<ModpackInfoPage> {
        private ObservableList<Node> originList;

        public ModpackInfoPageSkin(ModpackInfoPage skinnable) {
            super((Control)skinnable);
            JFXToggleButton button;
            HintPane pane;
            Insets insets = new Insets(5.0, 0.0, 12.0, 0.0);
            Insets componentListMargin = new Insets(16.0, 0.0, 16.0, 0.0);
            ScrollPane scroll = new ScrollPane();
            scroll.setFitToWidth(true);
            scroll.setFitToHeight(true);
            this.getChildren().setAll((Object[])new Node[]{scroll});
            ArrayList<JFXTextField> validatingFields = new ArrayList<JFXTextField>();
            BorderPane borderPane = new BorderPane();
            borderPane.setStyle("-fx-padding: 16;");
            scroll.setContent((Node)borderPane);
            if (skinnable.controller.getSettings().get("modpack.type") == "server") {
                Hyperlink hyperlink = new Hyperlink(I18n.i18n("modpack.wizard.step.initialization.server"));
                hyperlink.setOnAction(e -> FXUtils.openLink("https://docs.hmcl.net/modpack/serverpack.html"));
                borderPane.setTop((Node)hyperlink);
            }
            if (skinnable.controller.getSettings().get("modpack.type") == "modrinth") {
                pane = new HintPane(MessageDialogPane.MessageType.INFO);
                pane.setText(I18n.i18n("modpack.wizard.step.initialization.modrinth.info"));
                borderPane.setTop((Node)pane);
            } else {
                pane = new HintPane(MessageDialogPane.MessageType.INFO);
                pane.setText(I18n.i18n("modpack.wizard.step.initialization.warning"));
                borderPane.setTop((Node)pane);
            }
            ComponentList list = new ComponentList();
            BorderPane.setMargin((Node)list, (Insets)componentListMargin);
            borderPane.setCenter((Node)list);
            BorderPane borderPane1 = new BorderPane();
            borderPane1.setLeft((Node)new Label(I18n.i18n("modpack.wizard.step.initialization.exported_version")));
            Label versionNameLabel = new Label();
            versionNameLabel.setText(skinnable.versionName);
            borderPane1.setRight((Node)versionNameLabel);
            list.getContent().add((Object)borderPane1);
            GridPane pane2 = new GridPane();
            list.getContent().add((Object)pane2);
            pane2.setHgap(16.0);
            pane2.setVgap(8.0);
            pane2.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{new ColumnConstraints(), FXUtils.getColumnHgrowing()});
            int rowIndex = 0;
            JFXTextField txtModpackName = new JFXTextField();
            txtModpackName.textProperty().bindBidirectional((Property)skinnable.name);
            txtModpackName.getValidators().add((Object)new RequiredValidator());
            validatingFields.add(txtModpackName);
            pane2.addRow(rowIndex++, new Node[]{new Label(I18n.i18n("modpack.name")), txtModpackName});
            JFXTextField txtModpackAuthor = new JFXTextField();
            txtModpackAuthor.textProperty().bindBidirectional((Property)skinnable.author);
            txtModpackAuthor.getValidators().add((Object)new RequiredValidator());
            validatingFields.add(txtModpackAuthor);
            pane2.addRow(rowIndex++, new Node[]{new Label(I18n.i18n("archive.author")), txtModpackAuthor});
            JFXTextField txtModpackVersion = new JFXTextField();
            txtModpackVersion.textProperty().bindBidirectional((Property)skinnable.version);
            txtModpackVersion.getValidators().add((Object)new RequiredValidator());
            validatingFields.add(txtModpackVersion);
            pane2.addRow(rowIndex++, new Node[]{new Label(I18n.i18n("archive.version")), txtModpackVersion});
            if (skinnable.options.isRequireFileApi()) {
                JFXTextField txtModpackFileApi = new JFXTextField();
                txtModpackFileApi.textProperty().bindBidirectional((Property)skinnable.fileApi);
                validatingFields.add(txtModpackFileApi);
                if (skinnable.options.isValidateFileApi()) {
                    txtModpackFileApi.getValidators().add((Object)new RequiredValidator());
                }
                txtModpackFileApi.getValidators().add((Object)new URLValidator(true));
                pane2.addRow(rowIndex++, new Node[]{new Label(I18n.i18n("modpack.file_api")), txtModpackFileApi});
            }
            if (skinnable.options.isRequireLaunchArguments()) {
                JFXTextField txtLaunchArguments = new JFXTextField();
                txtLaunchArguments.textProperty().bindBidirectional((Property)skinnable.launchArguments);
                pane2.addRow(rowIndex++, new Node[]{new Label(I18n.i18n("settings.advanced.minecraft_arguments")), txtLaunchArguments});
            }
            if (skinnable.options.isRequireJavaArguments()) {
                JFXTextField txtJavaArguments = new JFXTextField();
                txtJavaArguments.textProperty().bindBidirectional((Property)skinnable.javaArguments);
                pane2.addRow(rowIndex++, new Node[]{new Label(I18n.i18n("settings.advanced.jvm_args")), txtJavaArguments});
            }
            if (skinnable.options.isRequireUrl()) {
                JFXTextField txtModpackUrl = new JFXTextField();
                txtModpackUrl.textProperty().bindBidirectional((Property)skinnable.url);
                pane2.addRow(rowIndex++, new Node[]{new Label(I18n.i18n("modpack.origin.url")), txtModpackUrl});
            }
            if (skinnable.options.isRequireOrigins()) {
                JFXTextField txtMcbbs = new JFXTextField();
                FXUtils.setValidateWhileTextChanged((Node)txtMcbbs, true);
                txtMcbbs.getValidators().add((Object)new NumberValidator(I18n.i18n("input.number"), true));
                txtMcbbs.textProperty().bindBidirectional((Property)skinnable.mcbbsThreadId);
                validatingFields.add(txtMcbbs);
                pane2.addRow(rowIndex++, new Node[]{new Label(I18n.i18n("modpack.origin.mcbbs")), txtMcbbs});
            }
            if (skinnable.options.isRequireMinMemory()) {
                pane2 = new VBox();
                Label title = new Label(I18n.i18n("settings.memory"));
                VBox.setMargin((Node)title, (Insets)new Insets(0.0, 0.0, 8.0, 0.0));
                HBox lowerBoundPane = new HBox(8.0);
                lowerBoundPane.setAlignment(Pos.CENTER);
                VBox.setMargin((Node)lowerBoundPane, (Insets)new Insets(0.0, 0.0, 0.0, 16.0));
                Label label = new Label(I18n.i18n("settings.memory.lower_bound"));
                JFXSlider slider = new JFXSlider(0.0, 1.0, 0.0);
                HBox.setMargin((Node)slider, (Insets)new Insets(0.0, 0.0, 0.0, 8.0));
                HBox.setHgrow((Node)slider, (Priority)Priority.ALWAYS);
                slider.setValueFactory((Callback<JFXSlider, StringBinding>)((Callback)self -> Bindings.createStringBinding(() -> (int)(self.getValue() * 100.0) + "%", (Observable[])new Observable[]{self.valueProperty()})));
                AtomicBoolean changedByTextField = new AtomicBoolean(false);
                FXUtils.onChangeAndOperate(skinnable.minMemory, minMemory -> {
                    changedByTextField.set(true);
                    slider.setValue((double)minMemory.intValue() * 1.0 / DataSizeUnit.MEGABYTES.convertFromBytes(SystemInfo.getTotalMemorySize()));
                    changedByTextField.set(false);
                });
                slider.valueProperty().addListener((value, oldVal, newVal) -> {
                    if (changedByTextField.get()) {
                        return;
                    }
                    skinnable.minMemory.set((int)(((Number)value.getValue()).doubleValue() * DataSizeUnit.MEGABYTES.convertFromBytes(SystemInfo.getTotalMemorySize())));
                });
                JFXTextField txtMinMemory = new JFXTextField();
                FXUtils.bindInt(txtMinMemory, (Property<Number>)skinnable.minMemory);
                txtMinMemory.getValidators().add((Object)new NumberValidator(I18n.i18n("input.number"), false));
                FXUtils.setLimitWidth((Region)txtMinMemory, 60.0);
                validatingFields.add(txtMinMemory);
                lowerBoundPane.getChildren().setAll((Object[])new Node[]{label, slider, txtMinMemory, new Label("MiB")});
                pane2.getChildren().setAll((Object[])new Node[]{title, lowerBoundPane});
                list.getContent().add((Object)pane2);
            }
            pane2 = new VBox(8.0);
            JFXTextArea area = new JFXTextArea();
            area.textProperty().bindBidirectional((Property)skinnable.description);
            area.setMinHeight(400.0);
            pane2.getChildren().setAll((Object[])new Node[]{new Label(I18n.i18n("modpack.desc")), area});
            list.getContent().add((Object)pane2);
            if (skinnable.options.isRequireAuthlibInjectorServer()) {
                JFXComboBox cboServers = new JFXComboBox();
                cboServers.setMaxWidth(Double.MAX_VALUE);
                cboServers.setCellFactory(FXUtils.jfxListCellFactory(server -> new TwoLineListItem(server.getName(), server.getUrl())));
                cboServers.setConverter(FXUtils.stringConverter(AuthlibInjectorServer::getName));
                Bindings.bindContent((List)cboServers.getItems(), ConfigHolder.config().getAuthlibInjectorServers());
                skinnable.authlibInjectorServer.bind((ObservableValue)Bindings.createStringBinding(() -> Optional.ofNullable((AuthlibInjectorServer)cboServers.getSelectionModel().getSelectedItem()).map(AuthlibInjectorServer::getUrl).orElse(null), (Observable[])new Observable[0]));
                BorderPane pane3 = new BorderPane();
                Label left = new Label(I18n.i18n("account.injector.server"));
                BorderPane.setAlignment((Node)left, (Pos)Pos.CENTER_LEFT);
                pane3.setLeft((Node)left);
                pane3.setRight(cboServers);
                list.getContent().add((Object)pane3);
            }
            if (skinnable.options.isRequireForceUpdate()) {
                pane2 = new BorderPane();
                pane2.setLeft((Node)new Label(I18n.i18n("modpack.wizard.step.initialization.force_update")));
                list.getContent().add((Object)pane2);
                button = new JFXToggleButton();
                button.selectedProperty().bindBidirectional((Property)skinnable.forceUpdate);
                button.setSize(8.0);
                button.setMinHeight(16.0);
                button.setMaxHeight(16.0);
                pane2.setRight((Node)button);
            }
            pane2 = new BorderPane();
            pane2.setLeft((Node)new Label(I18n.i18n("modpack.wizard.step.initialization.include_launcher")));
            list.getContent().add((Object)pane2);
            button = new JFXToggleButton();
            button.setDisable(!skinnable.canIncludeLauncher);
            button.selectedProperty().bindBidirectional((Property)skinnable.packWithLauncher);
            button.setSize(8.0);
            button.setMinHeight(16.0);
            button.setMaxHeight(16.0);
            pane2.setRight((Node)button);
            if (skinnable.options.isRequireNoCreateRemoteFiles()) {
                BorderPane noCreateRemoteFiles = new BorderPane();
                noCreateRemoteFiles.setLeft((Node)new Label(I18n.i18n("modpack.wizard.step.initialization.no_create_remote_files")));
                list.getContent().add((Object)noCreateRemoteFiles);
                JFXToggleButton noCreateRemoteFilesButton = new JFXToggleButton();
                noCreateRemoteFilesButton.selectedProperty().bindBidirectional((Property)skinnable.noCreateRemoteFiles);
                noCreateRemoteFilesButton.setSize(8.0);
                noCreateRemoteFilesButton.setMinHeight(16.0);
                noCreateRemoteFilesButton.setMaxHeight(16.0);
                noCreateRemoteFiles.setRight((Node)noCreateRemoteFilesButton);
            }
            if (skinnable.options.isRequireSkipCurseForgeRemoteFiles()) {
                BorderPane skipCurseForgeRemoteFiles = new BorderPane();
                skipCurseForgeRemoteFiles.setLeft((Node)new Label(I18n.i18n("modpack.wizard.step.initialization.skip_curseforge_remote_files")));
                list.getContent().add((Object)skipCurseForgeRemoteFiles);
                JFXToggleButton skipCurseForgeRemoteFilesButton = new JFXToggleButton();
                skipCurseForgeRemoteFilesButton.selectedProperty().bindBidirectional((Property)skinnable.skipCurseForgeRemoteFiles);
                skipCurseForgeRemoteFilesButton.setSize(8.0);
                skipCurseForgeRemoteFilesButton.setMinHeight(16.0);
                skipCurseForgeRemoteFilesButton.setMaxHeight(16.0);
                skipCurseForgeRemoteFiles.setRight((Node)skipCurseForgeRemoteFilesButton);
            }
            HBox hbox = new HBox();
            hbox.setAlignment(Pos.CENTER_RIGHT);
            borderPane.setBottom((Node)hbox);
            JFXButton nextButton = FXUtils.newRaisedButton(I18n.i18n("wizard.next"));
            nextButton.setOnAction(e -> skinnable.onNext());
            nextButton.setPrefWidth(100.0);
            nextButton.setPrefHeight(40.0);
            nextButton.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> validatingFields.stream().map(field -> !field.validate()).reduce(false, (left, right) -> left != false || right != false), (Observable[])((Observable[])validatingFields.stream().map(TextInputControl::textProperty).toArray(StringProperty[]::new))));
            hbox.getChildren().add((Object)nextButton);
            FXUtils.smoothScrolling(scroll);
        }
    }
}

