/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXCheckBox;
import com.jfoenix.controls.JFXDialogLayout;
import com.jfoenix.controls.JFXListView;
import com.jfoenix.controls.JFXPopup;
import com.jfoenix.controls.JFXTextField;
import com.jfoenix.controls.datamodels.treetable.RecursiveTreeObject;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javafx.animation.PauseTransition;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SkinBase;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Paint;
import javafx.util.Duration;
import org.jackhuang.hmcl.mod.LocalModFile;
import org.jackhuang.hmcl.mod.ModLoaderType;
import org.jackhuang.hmcl.mod.RemoteMod;
import org.jackhuang.hmcl.mod.RemoteModRepository;
import org.jackhuang.hmcl.mod.curse.CurseForgeRemoteModRepository;
import org.jackhuang.hmcl.mod.modrinth.ModrinthRemoteModRepository;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.setting.Theme;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.ToolbarListPageSkin;
import org.jackhuang.hmcl.ui.animation.ContainerAnimations;
import org.jackhuang.hmcl.ui.animation.TransitionPane;
import org.jackhuang.hmcl.ui.construct.ComponentList;
import org.jackhuang.hmcl.ui.construct.DialogCloseEvent;
import org.jackhuang.hmcl.ui.construct.IconedMenuItem;
import org.jackhuang.hmcl.ui.construct.JFXHyperlink;
import org.jackhuang.hmcl.ui.construct.MDListCell;
import org.jackhuang.hmcl.ui.construct.PopupMenu;
import org.jackhuang.hmcl.ui.construct.SpinnerPane;
import org.jackhuang.hmcl.ui.construct.TwoLineListItem;
import org.jackhuang.hmcl.ui.versions.DownloadPage;
import org.jackhuang.hmcl.ui.versions.HMCLLocalizedDownloadListPage;
import org.jackhuang.hmcl.ui.versions.ModListPage;
import org.jackhuang.hmcl.ui.versions.ModTranslations;
import org.jackhuang.hmcl.util.Holder;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Lazy;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.CompressingUtils;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.io.NetworkUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

class ModListPageSkin
extends SkinBase<ModListPage> {
    private final TransitionPane toolbarPane;
    private final HBox searchBar;
    private final HBox toolbarNormal;
    private final HBox toolbarSelecting;
    private final JFXListView<ModInfoObject> listView;
    private final JFXTextField searchField;
    private boolean isSearching = false;
    private static final Lazy<PopupMenu> menu = new Lazy<PopupMenu>(PopupMenu::new);
    private static final Lazy<JFXPopup> popup = new Lazy<JFXPopup>(() -> new JFXPopup((Region)menu.get()));

    ModListPageSkin(ModListPage skinnable) {
        super((Control)skinnable);
        StackPane pane = new StackPane();
        pane.setPadding(new Insets(10.0));
        pane.getStyleClass().addAll((Object[])new String[]{"notice-pane"});
        ComponentList root = new ComponentList();
        root.getStyleClass().add((Object)"no-padding");
        this.listView = new JFXListView();
        this.toolbarPane = new TransitionPane();
        this.searchBar = new HBox();
        this.toolbarNormal = new HBox();
        this.toolbarSelecting = new HBox();
        this.searchBar.setAlignment(Pos.CENTER);
        this.searchBar.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
        this.searchField = new JFXTextField();
        this.searchField.setPromptText(I18n.i18n("search"));
        HBox.setHgrow((Node)this.searchField, (Priority)Priority.ALWAYS);
        PauseTransition pause = new PauseTransition(Duration.millis((double)100.0));
        pause.setOnFinished(e -> this.search());
        this.searchField.textProperty().addListener((observable, oldValue, newValue) -> {
            pause.setRate(1.0);
            pause.playFromStart();
        });
        JFXButton closeSearchBar = ToolbarListPageSkin.createToolbarButton2(null, SVG.CLOSE, () -> {
            this.changeToolbar(this.toolbarNormal);
            this.isSearching = false;
            this.searchField.clear();
            Bindings.bindContent((List)this.listView.getItems(), ((ModListPage)this.getSkinnable()).getItems());
        });
        FXUtils.onEscPressed((Node)this.searchField, () -> ((JFXButton)closeSearchBar).fire());
        this.searchBar.getChildren().setAll((Object[])new Node[]{this.searchField, closeSearchBar});
        Object[] objectArray = new Node[6];
        objectArray[0] = ToolbarListPageSkin.createToolbarButton2(I18n.i18n("button.refresh"), SVG.REFRESH, skinnable::refresh);
        objectArray[1] = ToolbarListPageSkin.createToolbarButton2(I18n.i18n("mods.add"), SVG.ADD, skinnable::add);
        objectArray[2] = ToolbarListPageSkin.createToolbarButton2(I18n.i18n("folder.mod"), SVG.FOLDER_OPEN, skinnable::openModFolder);
        objectArray[3] = ToolbarListPageSkin.createToolbarButton2(I18n.i18n("mods.check_updates"), SVG.UPDATE, skinnable::checkUpdates);
        objectArray[4] = ToolbarListPageSkin.createToolbarButton2(I18n.i18n("download"), SVG.DOWNLOAD, skinnable::download);
        objectArray[5] = ToolbarListPageSkin.createToolbarButton2(I18n.i18n("search"), SVG.SEARCH, () -> this.changeToolbar(this.searchBar));
        this.toolbarNormal.getChildren().setAll(objectArray);
        this.toolbarSelecting.getChildren().setAll((Object[])new Node[]{ToolbarListPageSkin.createToolbarButton2(I18n.i18n("button.remove"), SVG.DELETE, () -> Controllers.confirm(I18n.i18n("button.remove.confirm"), I18n.i18n("button.remove"), () -> skinnable.removeSelected((ObservableList<ModInfoObject>)this.listView.getSelectionModel().getSelectedItems()), null)), ToolbarListPageSkin.createToolbarButton2(I18n.i18n("mods.enable"), SVG.CHECK, () -> skinnable.enableSelected((ObservableList<ModInfoObject>)this.listView.getSelectionModel().getSelectedItems())), ToolbarListPageSkin.createToolbarButton2(I18n.i18n("mods.disable"), SVG.CLOSE, () -> skinnable.disableSelected((ObservableList<ModInfoObject>)this.listView.getSelectionModel().getSelectedItems())), ToolbarListPageSkin.createToolbarButton2(I18n.i18n("button.select_all"), SVG.SELECT_ALL, () -> this.listView.getSelectionModel().selectAll()), ToolbarListPageSkin.createToolbarButton2(I18n.i18n("button.cancel"), SVG.CANCEL, () -> this.listView.getSelectionModel().clearSelection())});
        FXUtils.onChangeAndOperate(this.listView.getSelectionModel().selectedItemProperty(), selectedItem -> {
            if (selectedItem == null) {
                this.changeToolbar(this.isSearching ? this.searchBar : this.toolbarNormal);
            } else {
                this.changeToolbar(this.toolbarSelecting);
            }
        });
        root.getContent().add((Object)this.toolbarPane);
        root.addEventHandler(KeyEvent.KEY_PRESSED, e -> {
            if (e.getCode() == KeyCode.ESCAPE && this.listView.getSelectionModel().getSelectedItem() != null) {
                this.listView.getSelectionModel().clearSelection();
                e.consume();
            }
        });
        SpinnerPane center = new SpinnerPane();
        ComponentList.setVgrow((Node)center, Priority.ALWAYS);
        center.getStyleClass().add((Object)"large-spinner-pane");
        center.loadingProperty().bind((ObservableValue)skinnable.loadingProperty());
        Holder lastCell = new Holder();
        this.listView.setCellFactory(x -> new ModInfoListCell(this.listView, lastCell));
        this.listView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        Bindings.bindContent((List)this.listView.getItems(), skinnable.getItems());
        skinnable.getItems().addListener(c -> {
            if (this.isSearching) {
                this.search();
            }
        });
        this.listView.setOnContextMenuRequested(event -> {
            ModInfoObject selectedItem = (ModInfoObject)this.listView.getSelectionModel().getSelectedItem();
            if (selectedItem != null && this.listView.getSelectionModel().getSelectedItems().size() == 1) {
                this.listView.getSelectionModel().clearSelection();
                Controllers.dialog((Region)new ModInfoDialog(selectedItem));
            }
        });
        FXUtils.ignoreEvent(this.listView, KeyEvent.KEY_PRESSED, e -> e.getCode() == KeyCode.ESCAPE);
        center.setContent((Node)this.listView);
        root.getContent().add((Object)center);
        Label label = new Label(I18n.i18n("mods.not_modded"));
        label.prefWidthProperty().bind((ObservableValue)pane.widthProperty().add(-100));
        FXUtils.onChangeAndOperate(skinnable.moddedProperty(), modded -> {
            if (modded.booleanValue()) {
                pane.getChildren().setAll((Object[])new Node[]{root});
            } else {
                pane.getChildren().setAll((Object[])new Node[]{label});
            }
        });
        this.getChildren().setAll((Object[])new Node[]{pane});
    }

    private void changeToolbar(HBox newToolbar) {
        Node oldToolbar = this.toolbarPane.getCurrentNode();
        if (newToolbar != oldToolbar) {
            this.toolbarPane.setContent((Node)newToolbar, ContainerAnimations.FADE);
            if (newToolbar == this.searchBar) {
                this.searchField.requestFocus();
            }
        }
    }

    private void search() {
        this.isSearching = true;
        Bindings.unbindContent((Object)this.listView.getItems(), ((ModListPage)this.getSkinnable()).getItems());
        String queryString = this.searchField.getText();
        if (StringUtils.isBlank(queryString)) {
            this.listView.getItems().setAll(((ModListPage)this.getSkinnable()).getItems());
        } else {
            Predicate<String> predicate;
            this.listView.getItems().clear();
            if (queryString.startsWith("regex:")) {
                try {
                    Pattern pattern = Pattern.compile(queryString.substring("regex:".length()));
                    predicate = s -> s != null && pattern.matcher((CharSequence)s).find();
                }
                catch (Throwable e) {
                    Logger.LOG.warning("Illegal regular expression", e);
                    return;
                }
            } else {
                String lowerQueryString = queryString.toLowerCase(Locale.ROOT);
                predicate = s -> s != null && s.toLowerCase(Locale.ROOT).contains(lowerQueryString);
            }
            for (ModInfoObject item : ((ModListPage)this.getSkinnable()).getItems()) {
                LocalModFile modInfo = item.getModInfo();
                if (!predicate.test(modInfo.getFileName()) && !predicate.test(modInfo.getName()) && !predicate.test(modInfo.getVersion()) && !predicate.test(modInfo.getGameVersion()) && !predicate.test(modInfo.getId()) && !predicate.test(Objects.toString((Object)modInfo.getModLoaderType())) && !predicate.test(item.getMod() != null ? item.getMod().getDisplayName() : null)) continue;
                this.listView.getItems().add((Object)item);
            }
        }
    }

    static class ModInfoObject
    extends RecursiveTreeObject<ModInfoObject>
    implements Comparable<ModInfoObject> {
        private final BooleanProperty active;
        private final LocalModFile localModFile;
        private final String title;
        private final String message;
        private final ModTranslations.Mod mod;

        ModInfoObject(LocalModFile localModFile) {
            this.localModFile = localModFile;
            this.active = localModFile.activeProperty();
            StringBuilder title = new StringBuilder(localModFile.getName());
            if (StringUtils.isNotBlank(localModFile.getVersion())) {
                title.append(" ").append(localModFile.getVersion());
            }
            this.title = title.toString();
            StringBuilder message = new StringBuilder(localModFile.getFileName());
            if (StringUtils.isNotBlank(localModFile.getGameVersion())) {
                message.append(", ").append(I18n.i18n("mods.game.version")).append(": ").append(localModFile.getGameVersion());
            }
            if (StringUtils.isNotBlank(localModFile.getAuthors())) {
                message.append(", ").append(I18n.i18n("archive.author")).append(": ").append(localModFile.getAuthors());
            }
            this.message = message.toString();
            this.mod = ModTranslations.MOD.getModById(localModFile.getId());
        }

        String getTitle() {
            return this.title;
        }

        String getSubtitle() {
            return this.message;
        }

        LocalModFile getModInfo() {
            return this.localModFile;
        }

        public ModTranslations.Mod getMod() {
            return this.mod;
        }

        @Override
        public int compareTo(@NotNull ModInfoObject o) {
            return this.localModFile.getFileName().toLowerCase().compareTo(o.localModFile.getFileName().toLowerCase());
        }
    }

    class ModInfoDialog
    extends JFXDialogLayout {
        ModInfoDialog(ModInfoObject modInfo) {
            HBox titleContainer = new HBox();
            titleContainer.setSpacing(8.0);
            ImageView imageView = new ImageView();
            Task.supplyAsync(() -> {
                try (FileSystem fs = CompressingUtils.createReadOnlyZipFileSystem(modInfo.getModInfo().getFile());){
                    Image image;
                    String path;
                    Path iconPath;
                    Path iconPath2;
                    String logoPath = modInfo.getModInfo().getLogoPath();
                    if (StringUtils.isNotBlank(logoPath) && Files.exists(iconPath2 = fs.getPath(logoPath, new String[0]), new LinkOption[0])) {
                        try {
                            Image image2 = FXUtils.loadImage(iconPath2, 40, 40, true, true);
                            if (!image2.isError() && image2.getWidth() == image2.getHeight()) {
                                Image image3 = image2;
                                return image3;
                            }
                        }
                        catch (Throwable e) {
                            Logger.LOG.warning("Failed to load image " + logoPath, e);
                        }
                    }
                    ArrayList<String> defaultPaths = new ArrayList<String>(Arrays.asList("icon.png", "logo.png", "mod_logo.png", "pack.png", "logoFile.png"));
                    String id = modInfo.getModInfo().getId();
                    if (StringUtils.isNotBlank(id)) {
                        defaultPaths.addAll(Arrays.asList("assets/" + id + "/icon.png", "assets/" + id.replace("-", "") + "/icon.png", id + ".png", id + "-logo.png", id + "-icon.png", id + "_logo.png", id + "_icon.png"));
                    }
                    Iterator iterator = defaultPaths.iterator();
                    do {
                        if (!iterator.hasNext()) return null;
                    } while (!Files.exists(iconPath = fs.getPath(path = (String)iterator.next(), new String[0]), new LinkOption[0]) || (image = FXUtils.loadImage(iconPath, 40, 40, true, true)).isError() || image.getWidth() != image.getHeight());
                    Image image4 = image;
                    return image4;
                }
                catch (Exception e) {
                    Logger.LOG.warning("Failed to load icon", e);
                }
                return null;
            }).whenComplete(Schedulers.javafx(), (image, exception) -> {
                if (image != null) {
                    imageView.setImage(image);
                } else {
                    imageView.setImage(FXUtils.newBuiltinImage("/assets/img/command.png", 40.0, 40.0, true, true));
                }
            }).start();
            TwoLineListItem title = new TwoLineListItem();
            title.setTitle(modInfo.getModInfo().getName());
            if (StringUtils.isNotBlank(modInfo.getModInfo().getVersion())) {
                title.getTags().setAll((Object[])new String[]{modInfo.getModInfo().getVersion()});
            }
            title.setSubtitle(FileUtils.getName(modInfo.getModInfo().getFile()));
            titleContainer.getChildren().setAll((Object[])new Node[]{FXUtils.limitingSize((Node)imageView, 40.0, 40.0), title});
            this.setHeading(new Node[]{titleContainer});
            Label description = new Label(modInfo.getModInfo().getDescription().toString());
            FXUtils.copyOnDoubleClick((Labeled)description);
            this.setBody(new Node[]{description});
            if (StringUtils.isNotBlank(modInfo.getModInfo().getId())) {
                for (Pair item : Arrays.asList(Pair.pair("mods.curseforge", CurseForgeRemoteModRepository.MODS), Pair.pair("mods.modrinth", ModrinthRemoteModRepository.MODS))) {
                    RemoteModRepository repository = (RemoteModRepository)item.getValue();
                    JFXHyperlink button = new JFXHyperlink(I18n.i18n((String)item.getKey()));
                    Task.runAsync(() -> {
                        Optional<RemoteMod.Version> versionOptional = repository.getRemoteVersionByLocalFile(modInfo.getModInfo(), modInfo.getModInfo().getFile());
                        if (versionOptional.isPresent()) {
                            RemoteMod remoteMod = repository.getModById(versionOptional.get().getModid());
                            FXUtils.runInFX(() -> {
                                block7: for (ModLoaderType modLoaderType : ((RemoteMod.Version)versionOptional.get()).getLoaders()) {
                                    ObservableList<String> tags;
                                    String loaderName;
                                    switch (modLoaderType) {
                                        case FORGE: {
                                            loaderName = I18n.i18n("install.installer.forge");
                                            break;
                                        }
                                        case NEO_FORGED: {
                                            loaderName = I18n.i18n("install.installer.neoforge");
                                            break;
                                        }
                                        case FABRIC: {
                                            loaderName = I18n.i18n("install.installer.fabric");
                                            break;
                                        }
                                        case LITE_LOADER: {
                                            loaderName = I18n.i18n("install.installer.liteloader");
                                            break;
                                        }
                                        case QUILT: {
                                            loaderName = I18n.i18n("install.installer.quilt");
                                            break;
                                        }
                                        default: {
                                            continue block7;
                                        }
                                    }
                                    if ((tags = title.getTags()).contains(loaderName)) continue;
                                    tags.add(loaderName);
                                }
                                button.setOnAction(e -> {
                                    this.fireEvent(new DialogCloseEvent());
                                    Controllers.navigate((Node)new DownloadPage(repository instanceof CurseForgeRemoteModRepository ? HMCLLocalizedDownloadListPage.ofCurseForgeMod(null, false) : HMCLLocalizedDownloadListPage.ofModrinthMod(null, false), remoteMod, new Profile.ProfileVersion(((ModListPage)ModListPageSkin.this.getSkinnable()).getProfile(), ((ModListPage)ModListPageSkin.this.getSkinnable()).getVersionId()), (profile, version, file) -> org.jackhuang.hmcl.ui.download.DownloadPage.download(profile, version, file, "mods")));
                                });
                                button.setDisable(false);
                            });
                        }
                    }).start();
                    button.setDisable(true);
                    this.getActions().add((Object)button);
                }
            }
            if (StringUtils.isNotBlank(modInfo.getModInfo().getUrl())) {
                JFXHyperlink officialPageButton = new JFXHyperlink(I18n.i18n("mods.url"));
                officialPageButton.setOnAction(e -> {
                    this.fireEvent(new DialogCloseEvent());
                    FXUtils.openLink(modInfo.getModInfo().getUrl());
                });
                this.getActions().add((Object)officialPageButton);
            }
            if (modInfo.getMod() == null || StringUtils.isBlank(modInfo.getMod().getMcmod())) {
                JFXHyperlink searchButton = new JFXHyperlink(I18n.i18n("mods.mcmod.search"));
                searchButton.setOnAction(e -> {
                    this.fireEvent(new DialogCloseEvent());
                    FXUtils.openLink(NetworkUtils.withQuery("https://search.mcmod.cn/s", Lang.mapOf(Pair.pair("key", modInfo.getModInfo().getName()), Pair.pair("site", "all"), Pair.pair("filter", "0"))));
                });
                this.getActions().add((Object)searchButton);
            } else {
                JFXHyperlink mcmodButton = new JFXHyperlink(I18n.i18n("mods.mcmod.page"));
                mcmodButton.setOnAction(e -> {
                    this.fireEvent(new DialogCloseEvent());
                    FXUtils.openLink(ModTranslations.MOD.getMcmodUrl(modInfo.getMod()));
                });
                this.getActions().add((Object)mcmodButton);
            }
            JFXButton okButton = new JFXButton();
            okButton.getStyleClass().add((Object)"dialog-accept");
            okButton.setText(I18n.i18n("button.ok"));
            okButton.setOnAction(e -> this.fireEvent(new DialogCloseEvent()));
            this.getActions().add((Object)okButton);
            FXUtils.onEscPressed((Node)this, () -> ((JFXButton)okButton).fire());
        }
    }

    final class ModInfoListCell
    extends MDListCell<ModInfoObject> {
        JFXCheckBox checkBox;
        TwoLineListItem content;
        JFXButton restoreButton;
        JFXButton infoButton;
        JFXButton revealButton;
        BooleanProperty booleanProperty;

        ModInfoListCell(JFXListView<ModInfoObject> listView, Holder<Object> lastCell) {
            super(listView, lastCell);
            this.checkBox = new JFXCheckBox();
            this.content = new TwoLineListItem();
            this.restoreButton = new JFXButton();
            this.infoButton = new JFXButton();
            this.revealButton = new JFXButton();
            HBox container = new HBox(8.0);
            container.setPickOnBounds(false);
            container.setAlignment(Pos.CENTER_LEFT);
            HBox.setHgrow((Node)this.content, (Priority)Priority.ALWAYS);
            this.content.setMouseTransparent(true);
            this.setSelectable();
            this.restoreButton.getStyleClass().add((Object)"toggle-icon4");
            this.restoreButton.setGraphic(FXUtils.limitingSize(SVG.RESTORE.createIcon((Paint)Theme.blackFill(), 24.0), 24.0, 24.0));
            FXUtils.installFastTooltip((Node)this.restoreButton, I18n.i18n("mods.restore"));
            this.revealButton.getStyleClass().add((Object)"toggle-icon4");
            this.revealButton.setGraphic(FXUtils.limitingSize(SVG.FOLDER.createIcon((Paint)Theme.blackFill(), 24.0), 24.0, 24.0));
            this.infoButton.getStyleClass().add((Object)"toggle-icon4");
            this.infoButton.setGraphic(FXUtils.limitingSize(SVG.INFO.createIcon((Paint)Theme.blackFill(), 24.0), 24.0, 24.0));
            container.getChildren().setAll((Object[])new Node[]{this.checkBox, this.content, this.restoreButton, this.revealButton, this.infoButton});
            StackPane.setMargin((Node)container, (Insets)new Insets(8.0));
            this.getContainer().getChildren().setAll((Object[])new Node[]{container});
        }

        @Override
        protected void updateControl(ModInfoObject dataItem, boolean empty) {
            if (empty) {
                return;
            }
            this.content.setTitle(dataItem.getTitle());
            this.content.getTags().clear();
            switch (dataItem.getModInfo().getModLoaderType()) {
                case FORGE: {
                    this.content.getTags().add((Object)I18n.i18n("install.installer.forge"));
                    break;
                }
                case NEO_FORGED: {
                    this.content.getTags().add((Object)I18n.i18n("install.installer.neoforge"));
                    break;
                }
                case FABRIC: {
                    this.content.getTags().add((Object)I18n.i18n("install.installer.fabric"));
                    break;
                }
                case LITE_LOADER: {
                    this.content.getTags().add((Object)I18n.i18n("install.installer.liteloader"));
                    break;
                }
                case QUILT: {
                    this.content.getTags().add((Object)I18n.i18n("install.installer.quilt"));
                }
            }
            if (dataItem.getMod() != null && I18n.isUseChinese()) {
                this.content.getTags().add((Object)dataItem.getMod().getDisplayName());
            }
            this.content.setSubtitle(dataItem.getSubtitle());
            if (this.booleanProperty != null) {
                this.checkBox.selectedProperty().unbindBidirectional((Property)this.booleanProperty);
            }
            this.booleanProperty = dataItem.active;
            this.checkBox.selectedProperty().bindBidirectional((Property)this.booleanProperty);
            this.restoreButton.setVisible(!dataItem.getModInfo().getMod().getOldFiles().isEmpty());
            this.restoreButton.setOnAction(e -> {
                menu.get().getContent().setAll((Collection)dataItem.getModInfo().getMod().getOldFiles().stream().map(localModFile -> new IconedMenuItem(null, localModFile.getVersion(), () -> ((ModListPage)ModListPageSkin.this.getSkinnable()).rollback(dataItem.getModInfo(), (LocalModFile)localModFile), popup.get())).collect(Collectors.toList()));
                popup.get().show((Node)this.restoreButton, JFXPopup.PopupVPosition.TOP, JFXPopup.PopupHPosition.RIGHT, 0.0, this.restoreButton.getHeight());
            });
            this.revealButton.setOnAction(e -> FXUtils.showFileInExplorer(dataItem.getModInfo().getFile()));
            this.infoButton.setOnAction(e -> Controllers.dialog((Region)new ModInfoDialog(dataItem)));
        }
    }
}

