/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jackhuang.hmcl.mod.RemoteModRepository;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jetbrains.annotations.Nullable;

public enum ModTranslations {
    MOD("/assets/mod_data.txt"){

        @Override
        public String getMcmodUrl(Mod mod) {
            return String.format("https://www.mcmod.cn/class/%s.html", mod.getMcmod());
        }
    }
    ,
    MODPACK("/assets/modpack_data.txt"){

        @Override
        public String getMcmodUrl(Mod mod) {
            return String.format("https://www.mcmod.cn/modpack/%s.html", mod.getMcmod());
        }
    }
    ,
    EMPTY(""){

        @Override
        public String getMcmodUrl(Mod mod) {
            return "";
        }
    };

    private final String resourceName;
    private List<Mod> mods;
    private Map<String, Mod> modIdMap;
    private Map<String, Mod> curseForgeMap;
    private List<Pair<String, Mod>> keywords;
    private int maxKeywordLength = -1;

    public static ModTranslations getTranslationsByRepositoryType(RemoteModRepository.Type type) {
        switch (type) {
            case MOD: {
                return MOD;
            }
            case MODPACK: {
                return MODPACK;
            }
        }
        return EMPTY;
    }

    private ModTranslations(String resourceName) {
        this.resourceName = resourceName;
    }

    @Nullable
    public Mod getModByCurseForgeId(String id) {
        if (StringUtils.isBlank(id) || !this.loadCurseForgeMap()) {
            return null;
        }
        return this.curseForgeMap.get(id);
    }

    @Nullable
    public Mod getModById(String id) {
        if (StringUtils.isBlank(id) || !this.loadModIdMap()) {
            return null;
        }
        return this.modIdMap.get(id);
    }

    public abstract String getMcmodUrl(Mod var1);

    public List<Mod> searchMod(String query) {
        if (!this.loadKeywords()) {
            return Collections.emptyList();
        }
        StringBuilder newQuery = query.chars().filter(ch -> !Character.isSpaceChar(ch)).collect(StringBuilder::new, (sb, value) -> sb.append((char)value), StringBuilder::append);
        query = newQuery.toString();
        StringUtils.LongestCommonSubsequence lcs = new StringUtils.LongestCommonSubsequence(query.length(), this.maxKeywordLength);
        ArrayList<Pair<Integer, Mod>> modList = new ArrayList<Pair<Integer, Mod>>();
        for (Pair<String, Mod> keyword : this.keywords) {
            int value2 = lcs.calc(query, keyword.getKey());
            if (value2 < Math.max(1, query.length() - 3)) continue;
            modList.add(Pair.pair(value2, keyword.getValue()));
        }
        return modList.stream().sorted((a, b) -> -((Integer)a.getKey()).compareTo((Integer)b.getKey())).map(Pair::getValue).collect(Collectors.toList());
    }

    private boolean loadFromResource() {
        boolean bl;
        if (this.mods != null) {
            return true;
        }
        if (StringUtils.isBlank(this.resourceName)) {
            this.mods = Collections.emptyList();
            return true;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(ModTranslations.class.getResourceAsStream(this.resourceName), StandardCharsets.UTF_8));
        try {
            this.mods = reader.lines().filter(line -> !line.startsWith("#")).map(Mod::new).collect(Collectors.toList());
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                Logger.LOG.warning("Failed to load " + this.resourceName, e);
                return false;
            }
        }
        reader.close();
        return bl;
    }

    private boolean loadCurseForgeMap() {
        if (this.curseForgeMap != null) {
            return true;
        }
        if (this.mods == null && !this.loadFromResource()) {
            return false;
        }
        this.curseForgeMap = new HashMap<String, Mod>();
        for (Mod mod : this.mods) {
            if (!StringUtils.isNotBlank(mod.getCurseforge())) continue;
            this.curseForgeMap.put(mod.getCurseforge(), mod);
        }
        return true;
    }

    private boolean loadModIdMap() {
        if (this.modIdMap != null) {
            return true;
        }
        if (this.mods == null && !this.loadFromResource()) {
            return false;
        }
        this.modIdMap = new HashMap<String, Mod>();
        for (Mod mod : this.mods) {
            for (String id : mod.getModIds()) {
                if (!StringUtils.isNotBlank(id) || "examplemod".equals(id)) continue;
                this.modIdMap.put(id, mod);
            }
        }
        return true;
    }

    private boolean loadKeywords() {
        if (this.keywords != null) {
            return true;
        }
        if (this.mods == null && !this.loadFromResource()) {
            return false;
        }
        this.keywords = new ArrayList<Pair<String, Mod>>();
        this.maxKeywordLength = -1;
        for (Mod mod : this.mods) {
            if (StringUtils.isNotBlank(mod.getName())) {
                this.keywords.add(Pair.pair(mod.getName(), mod));
                this.maxKeywordLength = Math.max(this.maxKeywordLength, mod.getName().length());
            }
            if (StringUtils.isNotBlank(mod.getSubname())) {
                this.keywords.add(Pair.pair(mod.getSubname(), mod));
                this.maxKeywordLength = Math.max(this.maxKeywordLength, mod.getSubname().length());
            }
            if (!StringUtils.isNotBlank(mod.getAbbr())) continue;
            this.keywords.add(Pair.pair(mod.getAbbr(), mod));
            this.maxKeywordLength = Math.max(this.maxKeywordLength, mod.getAbbr().length());
        }
        return true;
    }

    public static final class Mod {
        private final String curseforge;
        private final String mcmod;
        private final List<String> modIds;
        private final String name;
        private final String subname;
        private final String abbr;

        public Mod(String line) {
            String[] items = line.split(";", -1);
            if (items.length != 6) {
                throw new IllegalArgumentException("Illegal mod data line, 6 items expected " + line);
            }
            this.curseforge = items[0];
            this.mcmod = items[1];
            this.modIds = Collections.unmodifiableList(Arrays.asList(items[2].split(",")));
            this.name = items[3];
            this.subname = items[4];
            this.abbr = items[5];
        }

        public Mod(String curseforge, String mcmod, List<String> modIds, String name, String subname, String abbr) {
            this.curseforge = curseforge;
            this.mcmod = mcmod;
            this.modIds = modIds;
            this.name = name;
            this.subname = subname;
            this.abbr = abbr;
        }

        public String getDisplayName() {
            StringBuilder builder = new StringBuilder();
            if (StringUtils.isNotBlank(this.abbr)) {
                builder.append("[").append(this.abbr.trim()).append("] ");
            }
            builder.append(this.name);
            if (StringUtils.isNotBlank(this.subname)) {
                builder.append(" (").append(this.subname).append(")");
            }
            return builder.toString();
        }

        public String getCurseforge() {
            return this.curseforge;
        }

        public String getMcmod() {
            return this.mcmod;
        }

        public List<String> getModIds() {
            return this.modIds;
        }

        public String getName() {
            return this.name;
        }

        public String getSubname() {
            return this.subname;
        }

        public String getAbbr() {
            return this.abbr;
        }
    }
}

