/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util;

import java.util.Objects;
import org.jackhuang.hmcl.game.World;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.util.versioning.GameVersionNumber;
import org.jetbrains.annotations.NotNull;

public final class ChunkBaseApp {
    private static final String CHUNK_BASE_URL = "https://www.chunkbase.com";
    private static final GameVersionNumber MIN_GAME_VERSION = GameVersionNumber.asGameVersion("1.7");
    private static final String[] SEED_MAP_GAME_VERSIONS = new String[]{"1.21.5", "1.21.4", "1.21.2", "1.21", "1.20", "1.19.3", "1.19", "1.18", "1.17", "1.16", "1.15", "1.14", "1.13", "1.12", "1.11", "1.10", "1.9", "1.8", "1.7"};
    public static final String[] STRONGHOLD_FINDER_GAME_VERSIONS = new String[]{"1.20", "1.19.3", "1.19", "1.18", "1.16", "1.13", "1.9", "1.7"};
    public static final String[] NETHER_FORTRESS_GAME_VERSIONS = new String[]{"1.18", "1.16", "1.7"};
    public static final String[] END_CITY_GAME_VERSIONS = new String[]{"1.19", "1.13"};
    private final StringBuilder builder;

    public static boolean isSupported(@NotNull World world) {
        return world.getSeed() != null && world.getGameVersion() != null && GameVersionNumber.asGameVersion(world.getGameVersion()).compareTo(MIN_GAME_VERSION) >= 0;
    }

    public static ChunkBaseApp newBuilder(String app, long seed) {
        return new ChunkBaseApp(new StringBuilder(CHUNK_BASE_URL).append("/apps/").append(app).append("#seed=").append(seed));
    }

    public static void openSeedMap(World world) {
        assert (ChunkBaseApp.isSupported(world));
        ChunkBaseApp.newBuilder("seed-map", Objects.requireNonNull(world.getSeed())).addPlatform(GameVersionNumber.asGameVersion(world.getGameVersion()), world.isLargeBiomes(), SEED_MAP_GAME_VERSIONS).open();
    }

    public static void openStrongholdFinder(World world) {
        assert (ChunkBaseApp.isSupported(world));
        ChunkBaseApp.newBuilder("stronghold-finder", Objects.requireNonNull(world.getSeed())).addPlatform(GameVersionNumber.asGameVersion(world.getGameVersion()), world.isLargeBiomes(), STRONGHOLD_FINDER_GAME_VERSIONS).open();
    }

    public static void openNetherFortressFinder(World world) {
        assert (ChunkBaseApp.isSupported(world));
        ChunkBaseApp.newBuilder("nether-fortress-finder", Objects.requireNonNull(world.getSeed())).addPlatform(GameVersionNumber.asGameVersion(world.getGameVersion()), false, NETHER_FORTRESS_GAME_VERSIONS).open();
    }

    public static void openEndCityFinder(World world) {
        assert (ChunkBaseApp.isSupported(world));
        ChunkBaseApp.newBuilder("endcity-finder", Objects.requireNonNull(world.getSeed())).addPlatform(GameVersionNumber.asGameVersion(world.getGameVersion()), false, END_CITY_GAME_VERSIONS).open();
    }

    private ChunkBaseApp(StringBuilder builder) {
        this.builder = builder;
    }

    public ChunkBaseApp add(String key, String value) {
        this.builder.append('&').append(key).append('=').append(value);
        return this;
    }

    public ChunkBaseApp addPlatform(GameVersionNumber gameVersion, boolean largeBiomes, String[] versionList) {
        String version = null;
        for (String candidateVersion : versionList) {
            if (gameVersion.compareTo(candidateVersion) < 0) continue;
            version = candidateVersion;
            break;
        }
        if (version == null) {
            version = versionList[versionList.length - 1];
        }
        this.add("platform", "java_" + version.replace('.', '_') + (largeBiomes ? "_lb" : ""));
        return this;
    }

    public void open() {
        FXUtils.openLink(this.builder.toString());
    }

    public String toString() {
        return this.builder.toString();
    }
}

