/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jackhuang.hmcl.util.gson.FileTypeAdapter;
import org.jackhuang.hmcl.util.gson.InstantTypeAdapter;
import org.jackhuang.hmcl.util.gson.JsonTypeAdapterFactory;
import org.jackhuang.hmcl.util.gson.LowerCaseEnumTypeAdapterFactory;
import org.jackhuang.hmcl.util.gson.UUIDTypeAdapter;
import org.jackhuang.hmcl.util.gson.ValidationTypeAdapterFactory;

public final class JsonUtils {
    public static final Gson GSON = JsonUtils.defaultGsonBuilder().create();
    public static final Gson UGLY_GSON = new GsonBuilder().registerTypeAdapterFactory(JsonTypeAdapterFactory.INSTANCE).registerTypeAdapterFactory(ValidationTypeAdapterFactory.INSTANCE).registerTypeAdapterFactory(LowerCaseEnumTypeAdapterFactory.INSTANCE).create();

    private JsonUtils() {
    }

    public static <T> TypeToken<List<T>> listTypeOf(Class<T> elementType) {
        return TypeToken.getParameterized(List.class, new Type[]{elementType});
    }

    public static <T> TypeToken<List<T>> listTypeOf(TypeToken<T> elementType) {
        return TypeToken.getParameterized(List.class, new Type[]{elementType.getType()});
    }

    public static <K, V> TypeToken<Map<K, V>> mapTypeOf(Class<K> keyType, Class<V> valueType) {
        return TypeToken.getParameterized(Map.class, new Type[]{keyType, valueType});
    }

    public static <K, V> TypeToken<Map<K, V>> mapTypeOf(Class<K> keyType, TypeToken<V> valueType) {
        return TypeToken.getParameterized(Map.class, new Type[]{keyType, valueType.getType()});
    }

    public static <T> T fromJsonFile(Path file, Class<T> classOfT) throws IOException {
        return JsonUtils.fromJsonFile(file, TypeToken.get(classOfT));
    }

    public static <T> T fromJsonFile(Path file, TypeToken<T> type) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(file);){
            Object t = GSON.fromJson((Reader)reader, type.getType());
            return t;
        }
    }

    public static <T> T fromJsonFully(InputStream json, Class<T> classOfT) throws IOException, JsonParseException {
        try (InputStreamReader reader = new InputStreamReader(json, StandardCharsets.UTF_8);){
            T t = GSON.fromJson((Reader)reader, classOfT);
            return t;
        }
    }

    public static <T> T fromJsonFully(InputStream json, TypeToken<T> type) throws IOException, JsonParseException {
        try (InputStreamReader reader = new InputStreamReader(json, StandardCharsets.UTF_8);){
            T t = GSON.fromJson((Reader)reader, type);
            return t;
        }
    }

    public static <T> T fromNonNullJson(String json, Class<T> classOfT) throws JsonParseException {
        T parsed = GSON.fromJson(json, classOfT);
        if (parsed == null) {
            throw new JsonParseException("Json object cannot be null.");
        }
        return parsed;
    }

    public static <T> T fromNonNullJson(String json, TypeToken<T> type) throws JsonParseException {
        T parsed = GSON.fromJson(json, type);
        if (parsed == null) {
            throw new JsonParseException("Json object cannot be null.");
        }
        return parsed;
    }

    public static <T> T fromNonNullJsonFully(InputStream json, Class<T> classOfT) throws IOException, JsonParseException {
        try (InputStreamReader reader = new InputStreamReader(json, StandardCharsets.UTF_8);){
            T parsed = GSON.fromJson((Reader)reader, classOfT);
            if (parsed == null) {
                throw new JsonParseException("Json object cannot be null.");
            }
            T t = parsed;
            return t;
        }
    }

    public static <T> T fromNonNullJsonFully(InputStream json, TypeToken<T> type) throws IOException, JsonParseException {
        try (InputStreamReader reader = new InputStreamReader(json, StandardCharsets.UTF_8);){
            T parsed = GSON.fromJson((Reader)reader, type);
            if (parsed == null) {
                throw new JsonParseException("Json object cannot be null.");
            }
            T t = parsed;
            return t;
        }
    }

    public static <T> T fromMaybeMalformedJson(String json, Class<T> classOfT) throws JsonParseException {
        try {
            return GSON.fromJson(json, classOfT);
        }
        catch (JsonSyntaxException e) {
            return null;
        }
    }

    public static <T> T fromMaybeMalformedJson(String json, TypeToken<T> type) throws JsonParseException {
        try {
            return GSON.fromJson(json, type);
        }
        catch (JsonSyntaxException e) {
            return null;
        }
    }

    public static void writeToJsonFile(Path file, Object value) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
            GSON.toJson(value, (Appendable)writer);
        }
    }

    public static GsonBuilder defaultGsonBuilder() {
        return new GsonBuilder().enableComplexMapKeySerialization().setPrettyPrinting().registerTypeAdapter((Type)((Object)Instant.class), InstantTypeAdapter.INSTANCE).registerTypeAdapter((Type)((Object)UUID.class), UUIDTypeAdapter.INSTANCE).registerTypeAdapter((Type)((Object)File.class), FileTypeAdapter.INSTANCE).registerTypeAdapterFactory(ValidationTypeAdapterFactory.INSTANCE).registerTypeAdapterFactory(LowerCaseEnumTypeAdapterFactory.INSTANCE).registerTypeAdapterFactory(JsonTypeAdapterFactory.INSTANCE);
    }
}

