/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.gson;

import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import javafx.scene.paint.Color;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;

public final class PaintAdapter
extends TypeAdapter<Paint> {
    @Override
    public void write(JsonWriter out, Paint value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        if (value instanceof Color) {
            Color color = (Color)value;
            int red = (int)Math.round(color.getRed() * 255.0);
            int green = (int)Math.round(color.getGreen() * 255.0);
            int blue = (int)Math.round(color.getBlue() * 255.0);
            int opacity = (int)Math.round(color.getOpacity() * 255.0);
            out.value(String.format("#%02x%02x%02x%02x", red, green, blue, opacity));
        } else if (value instanceof LinearGradient || value instanceof RadialGradient) {
            out.value(value.toString());
        } else {
            throw new JsonParseException("Unsupported Paint type: " + value.getClass().getName());
        }
    }

    @Override
    public Paint read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        String value = in.nextString();
        return Paint.valueOf((String)value);
    }
}

