/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.io;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.GZIPInputStream;
import org.glavo.chardet.DetectedCharset;
import org.glavo.chardet.UniversalDetector;
import org.jackhuang.hmcl.util.platform.OperatingSystem;

public final class IOUtils {
    public static final int DEFAULT_BUFFER_SIZE = 8192;

    private IOUtils() {
    }

    public static BufferedReader newBufferedReaderMaybeNativeEncoding(Path file) throws IOException {
        if (OperatingSystem.NATIVE_CHARSET == StandardCharsets.UTF_8) {
            return Files.newBufferedReader(file);
        }
        FileChannel channel = FileChannel.open(file, new OpenOption[0]);
        try {
            long oldPosition = channel.position();
            DetectedCharset detectedCharset = UniversalDetector.detectCharset(channel);
            Charset charset = detectedCharset != null && detectedCharset.isSupported() && (detectedCharset.getCharset() == StandardCharsets.UTF_8 || detectedCharset.getCharset() == StandardCharsets.US_ASCII) ? StandardCharsets.UTF_8 : OperatingSystem.NATIVE_CHARSET;
            channel.position(oldPosition);
            return new BufferedReader(new InputStreamReader(Channels.newInputStream(channel), charset));
        }
        catch (Throwable e) {
            IOUtils.closeQuietly(channel, e);
            throw e;
        }
    }

    public static byte[] readFully(InputStream stream) throws IOException {
        try (InputStream inputStream = stream;){
            byte[] byArray = stream.readAllBytes();
            return byArray;
        }
    }

    public static String readFullyAsString(InputStream stream) throws IOException {
        return new String(IOUtils.readFully(stream), StandardCharsets.UTF_8);
    }

    public static String readFullyAsString(InputStream stream, Charset charset) throws IOException {
        return new String(IOUtils.readFully(stream), charset);
    }

    public static void skipNBytes(InputStream input, long n) throws IOException {
        while (n > 0L) {
            long ns = input.skip(n);
            if (ns > 0L && ns <= n) {
                n -= ns;
                continue;
            }
            if (ns == 0L) {
                if (input.read() == -1) {
                    throw new EOFException();
                }
                --n;
                continue;
            }
            throw new IOException("Unexpected skip bytes. Expected: " + n + ", Actual: " + ns);
        }
    }

    public static void copyTo(InputStream src, OutputStream dest, byte[] buf) throws IOException {
        int len;
        while ((len = src.read(buf)) != -1) {
            dest.write(buf, 0, len);
        }
    }

    public static InputStream wrapFromGZip(InputStream inputStream) throws IOException {
        return new GZIPInputStream(inputStream);
    }

    public static void closeQuietly(AutoCloseable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void closeQuietly(AutoCloseable closeable, Throwable exception) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Throwable e) {
            exception.addSuppressed(e);
        }
    }
}

