/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.platform.linux;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.ref.SoftReference;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.glavo.pci.ids.PCIIDsDatabase;
import org.glavo.pci.ids.model.Device;
import org.glavo.pci.ids.model.Vendor;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.hardware.GraphicsCard;
import org.jackhuang.hmcl.util.platform.hardware.HardwareVendor;
import org.jackhuang.hmcl.util.platform.linux.LinuxHardwareDetector;

final class LinuxGPUDetector {
    private static volatile SoftReference<PCIIDsDatabase> databaseCache;
    private static final Pattern PCI_MODALIAS_PATTERN;
    private static final Pattern PCI_DEVICE_PATTERN;
    private static final Pattern OF_DEVICE_PATTERN;

    private static PCIIDsDatabase getPCIIDsDatabase() {
        PCIIDsDatabase pciIDsDatabase;
        SoftReference<PCIIDsDatabase> databaseWeakReference = databaseCache;
        if (databaseCache != null && (pciIDsDatabase = databaseWeakReference.get()) != null) {
            return pciIDsDatabase;
        }
        for (String path : new String[]{"/usr/share/misc/pci.ids", "/usr/share/hwdata/pci.ids", "/usr/local/share/hwdata/pci.ids"}) {
            Path p = Paths.get(path, new String[0]);
            if (!Files.isRegularFile(p, new LinkOption[0])) continue;
            try {
                pciIDsDatabase = PCIIDsDatabase.load(p);
                databaseCache = new SoftReference<PCIIDsDatabase>(pciIDsDatabase);
                return pciIDsDatabase;
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    private static void detectDriver(GraphicsCard.Builder builder, Path deviceDir) {
        try {
            Path driverDir = Files.readSymbolicLink(deviceDir.resolve("driver"));
            if (driverDir.getNameCount() > 0) {
                String name = driverDir.getName(driverDir.getNameCount() - 1).toString();
                builder.setDriver(name);
                Path versionFile = deviceDir.resolve("driver/module/version");
                if (Files.isRegularFile(versionFile, new LinkOption[0])) {
                    builder.setDriverVersion(Files.readString(versionFile).trim());
                } else if ("zx".equals(name) && Files.isRegularFile(versionFile = deviceDir.resolve("zx_info/driver_version"), new LinkOption[0])) {
                    builder.setDriverVersion(Files.readString(versionFile).trim());
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static GraphicsCard detectPCI(Path deviceDir, String modalias) throws IOException {
        Vendor vendor;
        PCIIDsDatabase database;
        int subclassId;
        int deviceId;
        int vendorId;
        GraphicsCard.Builder builder;
        Matcher matcher;
        block40: {
            matcher = PCI_MODALIAS_PATTERN.matcher(modalias);
            if (!matcher.matches()) {
                return null;
            }
            builder = GraphicsCard.builder();
            vendorId = Integer.parseInt(matcher.group("vendorId"), 16);
            deviceId = Integer.parseInt(matcher.group("deviceId"), 16);
            int classId = Integer.parseInt(matcher.group("classId"), 16);
            subclassId = Integer.parseInt(matcher.group("subclassId"), 16);
            if (classId != 3) {
                return null;
            }
            Path pciPath = Files.readSymbolicLink(deviceDir);
            int nameCount = pciPath.getNameCount();
            if (nameCount == 0) {
                return null;
            }
            matcher = PCI_DEVICE_PATTERN.matcher(pciPath.getName(nameCount - 1).toString());
            if (!matcher.matches()) {
                return null;
            }
            int pciDomain = Integer.parseInt(matcher.group("pciDomain"), 16);
            int pciBus = Integer.parseInt(matcher.group("pciBus"), 16);
            int pciDevice = Integer.parseInt(matcher.group("pciDevice"), 16);
            int pciFunc = Integer.parseInt(matcher.group("pciFunc"), 16);
            builder.setVendor(HardwareVendor.ofPciVendorId(vendorId));
            LinuxGPUDetector.detectDriver(builder, deviceDir);
            try {
                if (builder.getVendor() == HardwareVendor.AMD) {
                    Path hwmon = deviceDir.resolve("hwmon");
                    try (Stream<Path> subDirs2 = Files.list(hwmon);){
                        for (Path subDir : Lang.toIterable(subDirs2)) {
                            if (!Files.isDirectory(subDir, new LinkOption[0]) || subDir.getFileName().toString().startsWith(".")) continue;
                            builder.setType(Files.exists(subDir.resolve("in1_input"), new LinkOption[0]) ? GraphicsCard.Type.Integrated : GraphicsCard.Type.Discrete);
                            break;
                        }
                    }
                    catch (IOException subDirs2) {
                        // empty catch block
                    }
                    Path revisionFile = deviceDir.resolve("revision");
                    if (!Files.isRegularFile(revisionFile, new LinkOption[0])) break block40;
                    String revisionString = Files.readString(revisionFile).trim();
                    int revision = Integer.decode(revisionString);
                    String prefix = String.format("%X,\t%X,\t", deviceId, revision);
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(LinuxHardwareDetector.class.getResourceAsStream("/assets/platform/amdgpu.ids"), StandardCharsets.UTF_8));){
                        String line;
                        while ((line = reader.readLine()) != null) {
                            if (!line.startsWith(prefix)) continue;
                            builder.setName(line.substring(prefix.length()));
                            break block40;
                        }
                        break block40;
                    }
                }
                if (builder.getVendor() == HardwareVendor.INTEL) {
                    builder.setType(pciDevice == 20 ? GraphicsCard.Type.Integrated : GraphicsCard.Type.Discrete);
                }
            }
            catch (Throwable hwmon) {
                // empty catch block
            }
        }
        if ((builder.getName() == null || builder.getVendor() == null) && (database = LinuxGPUDetector.getPCIIDsDatabase()) != null && (vendor = database.findVendor(vendorId)) != null) {
            Device device;
            if (builder.getVendor() == null) {
                builder.setVendor(HardwareVendor.of(vendor.getName()));
            }
            if (builder.getName() == null && (device = (Device)vendor.getDevices().get(deviceId)) != null) {
                matcher = Pattern.compile(".*\\[(?<name>.*)]").matcher(device.getName());
                if (matcher.matches()) {
                    builder.setName(GraphicsCard.cleanName(builder.getVendor() + " " + matcher.group("name")));
                } else {
                    builder.setName(builder.getVendor() + " " + device.getName());
                }
            }
        }
        if (builder.getName() == null) {
            String subclassStr;
            switch (subclassId) {
                case 0: {
                    subclassStr = " (VGA compatible)";
                    break;
                }
                case 1: {
                    subclassStr = " (XGA compatible)";
                    break;
                }
                case 2: {
                    subclassStr = " (3D)";
                    break;
                }
                default: {
                    subclassStr = "";
                }
            }
            builder.setName(String.format("%s Device %04X%s", builder.getVendor() != null ? builder.getVendor().toString() : "Unknown", deviceId, subclassStr));
        }
        if (builder.getType() == null) {
            if (builder.getVendor() == HardwareVendor.NVIDIA) {
                if (builder.getName().startsWith("GeForce") || builder.getName().startsWith("Quadro") || builder.getName().startsWith("Tesla")) {
                    builder.setType(GraphicsCard.Type.Discrete);
                }
            } else if (builder.getVendor() == HardwareVendor.MOORE_THREADS && builder.getName().startsWith("MTT ")) {
                builder.setType(GraphicsCard.Type.Discrete);
            }
        }
        return builder.build();
    }

    private static GraphicsCard detectOF(Path deviceDir, String modalias) throws IOException {
        Matcher matcher = OF_DEVICE_PATTERN.matcher(modalias);
        if (!matcher.matches()) {
            return null;
        }
        GraphicsCard.Builder builder = new GraphicsCard.Builder();
        String compatible = matcher.group("compatible");
        int idx = compatible.indexOf(44);
        if (idx < 0) {
            String name = compatible.trim().toUpperCase(Locale.ROOT);
            if (name.equals("IMG-GPU")) {
                builder.setVendor(HardwareVendor.IMG);
            } else {
                builder.setName(name);
            }
        } else {
            String vendorName = compatible.substring(0, idx).trim();
            HardwareVendor vendor = HardwareVendor.getKnown(vendorName);
            if (vendor == null) {
                vendor = new HardwareVendor(StringUtils.capitalizeFirst(vendorName));
            }
            builder.setVendor(vendor);
            String name = compatible.substring(idx + 1).trim().toUpperCase(Locale.ROOT);
            if (vendor == HardwareVendor.IMG) {
                if (!name.equals("GPU")) {
                    builder.setName(vendor + " " + name);
                }
            } else {
                builder.setName(vendor + " " + name);
            }
        }
        builder.setType(GraphicsCard.Type.Integrated);
        LinuxGPUDetector.detectDriver(builder, deviceDir);
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<GraphicsCard> detect() {
        Path drm = Paths.get("/sys/class/drm", new String[0]);
        if (!Files.isDirectory(drm, new LinkOption[0])) {
            return Collections.emptyList();
        }
        ArrayList<GraphicsCard> cards = new ArrayList<GraphicsCard>();
        try (Stream<Path> stream = Files.list(drm);){
            for (Path deviceRoot : Lang.toIterable(stream)) {
                Path deviceDir;
                Path modaliasFile;
                String name;
                Path dirName = deviceRoot.getFileName();
                if (dirName == null || !(name = dirName.toString()).startsWith("card") || name.indexOf(45) >= 0 || !Files.isRegularFile(modaliasFile = (deviceDir = deviceRoot.resolve("device")).resolve("modalias"), new LinkOption[0])) continue;
                try {
                    String modalias = Files.readString(modaliasFile).trim();
                    GraphicsCard graphicsCard = null;
                    if (modalias.startsWith("pci:")) {
                        graphicsCard = LinuxGPUDetector.detectPCI(deviceDir, modalias);
                    } else if (modalias.startsWith("of:")) {
                        graphicsCard = LinuxGPUDetector.detectOF(deviceDir, modalias);
                    }
                    if (graphicsCard == null) continue;
                    cards.add(graphicsCard);
                }
                catch (IOException iOException) {}
            }
        }
        catch (Throwable e) {
            Logger.LOG.warning("Failed to get graphics card info", e);
        }
        finally {
            databaseCache = null;
        }
        return Collections.unmodifiableList(cards);
    }

    private LinuxGPUDetector() {
    }

    static {
        PCI_MODALIAS_PATTERN = Pattern.compile("pci:v(?<vendorId>\\p{XDigit}{8})d(?<deviceId>\\p{XDigit}{8})sv(?<subVendorId>\\p{XDigit}{8})sd(?<subDeviceId>\\p{XDigit}{8})bc(?<classId>\\p{XDigit}{2})sc(?<subclassId>\\p{XDigit}{2})i\\p{XDigit}{2}");
        PCI_DEVICE_PATTERN = Pattern.compile("(?<pciDomain>\\p{XDigit}+):(?<pciBus>\\p{XDigit}+):(?<pciDevice>\\p{XDigit}+)\\.(?<pciFunc>\\p{XDigit}+)");
        OF_DEVICE_PATTERN = Pattern.compile("of:N(img)?gpuT[^C]*C(?<compatible>.*)");
    }
}

