/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.platform.windows;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jackhuang.hmcl.util.KeyValuePairUtils;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.platform.SystemUtils;
import org.jackhuang.hmcl.util.platform.hardware.GraphicsCard;
import org.jackhuang.hmcl.util.platform.hardware.HardwareVendor;
import org.jackhuang.hmcl.util.platform.windows.WinReg;
import org.jetbrains.annotations.Nullable;

final class WindowsGPUDetector {
    private static GraphicsCard.Type fromDacType(String adapterDACType) {
        if (StringUtils.isBlank(adapterDACType) || "Internal".equalsIgnoreCase(adapterDACType) || "InternalDAC".equalsIgnoreCase(adapterDACType)) {
            return GraphicsCard.Type.Integrated;
        }
        return GraphicsCard.Type.Discrete;
    }

    private static List<GraphicsCard> detectByCim() {
        try {
            String getCimInstance = OperatingSystem.SYSTEM_VERSION.startsWith("6.1") ? "Get-WmiObject" : "Get-CimInstance";
            List videoControllers = SystemUtils.run(Arrays.asList("powershell.exe", "-NoProfile", "-Command", String.join((CharSequence)" | ", getCimInstance + " -Class Win32_VideoController", "Select-Object Name,AdapterCompatibility,DriverVersion,AdapterDACType", "Format-List")), inputStream -> KeyValuePairUtils.loadList(new BufferedReader(new InputStreamReader((InputStream)inputStream, OperatingSystem.NATIVE_CHARSET))));
            ArrayList<GraphicsCard> cards = new ArrayList<GraphicsCard>(videoControllers.size());
            for (Map videoController : videoControllers) {
                String name = (String)videoController.get("Name");
                String adapterCompatibility = (String)videoController.get("AdapterCompatibility");
                String driverVersion = (String)videoController.get("DriverVersion");
                String adapterDACType = (String)videoController.get("AdapterDACType");
                if (!StringUtils.isNotBlank(name)) continue;
                cards.add(GraphicsCard.builder().setName(GraphicsCard.cleanName(name)).setVendor(HardwareVendor.of(adapterCompatibility)).setDriverVersion(driverVersion).setType(WindowsGPUDetector.fromDacType(adapterDACType)).build());
            }
            return cards;
        }
        catch (Throwable e) {
            Logger.LOG.warning("Failed to get graphics card info", e);
            return List.of();
        }
    }

    @Nullable
    private static String regValueToString(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String[]) {
            return String.join((CharSequence)" ", (String[])object);
        }
        return object.toString();
    }

    private static List<GraphicsCard> detectByRegistry(WinReg reg) {
        WinReg.HKEY hkey = WinReg.HKEY.HKEY_LOCAL_MACHINE;
        String displayDevices = "SYSTEM\\CurrentControlSet\\Control\\Class\\{4d36e968-e325-11ce-bfc1-08002be10318}\\";
        Pattern graphicsCardPattern = Pattern.compile("\\\\[0-9]+\\\\?$");
        ArrayList<GraphicsCard> result = new ArrayList<GraphicsCard>();
        for (String subkey : reg.querySubKeys(hkey, "SYSTEM\\CurrentControlSet\\Control\\Class\\{4d36e968-e325-11ce-bfc1-08002be10318}\\")) {
            if (!graphicsCardPattern.matcher(subkey).find()) continue;
            String name = WindowsGPUDetector.regValueToString(reg.queryValue(hkey, subkey, "HardwareInformation.AdapterString"));
            String vendor = WindowsGPUDetector.regValueToString(reg.queryValue(hkey, subkey, "ProviderName"));
            String driverVersion = WindowsGPUDetector.regValueToString(reg.queryValue(hkey, subkey, "DriverVersion"));
            String dacType = WindowsGPUDetector.regValueToString(reg.queryValue(hkey, subkey, "HardwareInformation.DacType"));
            GraphicsCard.Builder builder = GraphicsCard.builder();
            if (name != null) {
                builder.setName(GraphicsCard.cleanName(name));
            }
            if (vendor != null) {
                builder.setVendor(HardwareVendor.of(vendor));
            }
            if (driverVersion != null) {
                builder.setDriverVersion(driverVersion);
            }
            if (dacType != null) {
                builder.setType(WindowsGPUDetector.fromDacType(dacType));
            }
            result.add(builder.build());
        }
        return result;
    }

    @Nullable
    static List<GraphicsCard> detect() {
        try {
            List<GraphicsCard> res;
            WinReg reg = WinReg.INSTANCE;
            if (reg != null && !(res = WindowsGPUDetector.detectByRegistry(reg)).isEmpty()) {
                return res;
            }
            return WindowsGPUDetector.detectByCim();
        }
        catch (Throwable e) {
            Logger.LOG.warning("Failed to get graphics cards", e);
            return null;
        }
    }

    private WindowsGPUDetector() {
    }
}

