/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.versioning;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jackhuang.hmcl.util.versioning.VersionNumber;
import org.jackhuang.hmcl.util.versioning.VersionRange;
import org.jetbrains.annotations.NotNull;

public abstract class GameVersionNumber
implements Comparable<GameVersionNumber> {
    final String value;

    public static String[] getDefaultGameVersions() {
        return Versions.DEFAULT_GAME_VERSIONS;
    }

    public static GameVersionNumber asGameVersion(String version) {
        try {
            if (!version.isEmpty()) {
                char ch = version.charAt(0);
                switch (ch) {
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'i': 
                    case 'r': {
                        return Old.parse(version);
                    }
                }
                if (version.equals("0.0")) {
                    return Release.ZERO;
                }
                if (version.startsWith("1.")) {
                    return Release.parse(version);
                }
                if (version.length() == 6 && version.charAt(2) == 'w') {
                    return Snapshot.parse(version);
                }
            }
        }
        catch (IllegalArgumentException ch) {
            // empty catch block
        }
        Special special = Versions.SPECIALS.get(version);
        if (special == null) {
            special = new Special(version);
        }
        return special;
    }

    public static GameVersionNumber asGameVersion(Optional<String> version) {
        return version.isPresent() ? GameVersionNumber.asGameVersion(version.get()) : GameVersionNumber.unknown();
    }

    public static GameVersionNumber unknown() {
        return Release.ZERO;
    }

    public static int compare(String version1, String version2) {
        return GameVersionNumber.asGameVersion(version1).compareTo(GameVersionNumber.asGameVersion(version2));
    }

    public static VersionRange<GameVersionNumber> between(String minimum, String maximum) {
        return VersionRange.between(GameVersionNumber.asGameVersion(minimum), GameVersionNumber.asGameVersion(maximum));
    }

    public static VersionRange<GameVersionNumber> atLeast(String minimum) {
        return VersionRange.atLeast(GameVersionNumber.asGameVersion(minimum));
    }

    public static VersionRange<GameVersionNumber> atMost(String maximum) {
        return VersionRange.atMost(GameVersionNumber.asGameVersion(maximum));
    }

    GameVersionNumber(String value) {
        this.value = value;
    }

    public boolean isSpecial() {
        return this instanceof Special;
    }

    abstract Type getType();

    abstract int compareToImpl(@NotNull GameVersionNumber var1);

    @Override
    public int compareTo(@NotNull String other) {
        return this.compareTo(GameVersionNumber.asGameVersion(other));
    }

    @Override
    public int compareTo(@NotNull GameVersionNumber other) {
        if (this.getType() != other.getType()) {
            return Integer.compare(this.getType().ordinal(), other.getType().ordinal());
        }
        return this.compareToImpl(other);
    }

    public String toString() {
        return this.value;
    }

    static final class Versions {
        static final HashMap<String, Special> SPECIALS = new HashMap();
        static final String[] DEFAULT_GAME_VERSIONS;
        static final int[] SNAPSHOT_INTS;
        static final Release[] SNAPSHOT_PREV;

        Versions() {
        }

        static {
            ArrayDeque<String> defaultGameVersions = new ArrayDeque<String>(64);
            ArrayList<Snapshot> snapshots = new ArrayList<Snapshot>(1024);
            ArrayList<Release> snapshotPrev = new ArrayList<Release>(1024);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(GameVersionNumber.class.getResourceAsStream("/assets/game/versions.txt"), StandardCharsets.US_ASCII));){
                String line;
                Release currentRelease = null;
                GameVersionNumber prev = null;
                while ((line = reader.readLine()) != null) {
                    if (line.isEmpty()) continue;
                    GameVersionNumber version = GameVersionNumber.asGameVersion(line);
                    if (currentRelease == null) {
                        currentRelease = (Release)version;
                    }
                    if (version instanceof Snapshot) {
                        Snapshot snapshot = (Snapshot)version;
                        snapshots.add(snapshot);
                        snapshotPrev.add(currentRelease);
                    } else if (version instanceof Release) {
                        currentRelease = (Release)version;
                        if (currentRelease.eaType == Integer.MAX_VALUE) {
                            defaultGameVersions.addFirst(currentRelease.value);
                        }
                    } else if (version instanceof Special) {
                        Special special = (Special)version;
                        special.prev = prev;
                        SPECIALS.put(special.value, special);
                    } else {
                        throw new AssertionError((Object)("version: " + version));
                    }
                    prev = version;
                }
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            DEFAULT_GAME_VERSIONS = defaultGameVersions.toArray(new String[0]);
            SNAPSHOT_INTS = new int[snapshots.size()];
            for (int i = 0; i < snapshots.size(); ++i) {
                Versions.SNAPSHOT_INTS[i] = ((Snapshot)snapshots.get((int)i)).intValue;
            }
            SNAPSHOT_PREV = snapshotPrev.toArray(new Release[SNAPSHOT_INTS.length]);
        }
    }

    static final class Old
    extends GameVersionNumber {
        final Type type;
        final VersionNumber versionNumber;

        static Old parse(String value) {
            Type type;
            int prefixLength = 1;
            switch (value.charAt(0)) {
                case 'r': {
                    if (!value.startsWith("rd-")) {
                        throw new IllegalArgumentException(value);
                    }
                    type = Type.PRE_CLASSIC;
                    prefixLength = "rd-".length();
                    break;
                }
                case 'i': {
                    if (!value.startsWith("inf-")) {
                        throw new IllegalArgumentException(value);
                    }
                    type = Type.INFDEV;
                    prefixLength = "inf-".length();
                    break;
                }
                case 'a': {
                    type = Type.ALPHA;
                    break;
                }
                case 'b': {
                    type = Type.BETA;
                    break;
                }
                case 'c': {
                    type = Type.CLASSIC;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(value);
                }
            }
            if (value.length() < prefixLength + 1 || !Character.isDigit(value.charAt(prefixLength))) {
                throw new IllegalArgumentException(value);
            }
            return new Old(value, type, VersionNumber.asVersion(value.substring(prefixLength)));
        }

        private Old(String value, Type type, VersionNumber versionNumber) {
            super(value);
            this.type = type;
            this.versionNumber = versionNumber;
        }

        @Override
        Type getType() {
            return this.type;
        }

        @Override
        int compareToImpl(@NotNull GameVersionNumber other) {
            return this.versionNumber.compareTo(((Old)other).versionNumber);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Old)) {
                return false;
            }
            Old other = (Old)o;
            return this.type == other.type && this.versionNumber.compareTo(other.versionNumber) == 0;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.versionNumber.hashCode()});
        }
    }

    static final class Release
    extends GameVersionNumber {
        private static final Pattern PATTERN = Pattern.compile("1\\.(?<minor>[0-9]+)(\\.(?<patch>[0-9]+))?((?<eaType>(-[a-zA-Z]+| Pre-Release ))(?<eaVersion>.+))?");
        static final int TYPE_GA = Integer.MAX_VALUE;
        static final int TYPE_UNKNOWN = 0;
        static final int TYPE_EXP = 1;
        static final int TYPE_PRE = 2;
        static final int TYPE_RC = 3;
        static final Release ZERO = new Release("0.0", 0, 0, 0, Integer.MAX_VALUE, VersionNumber.ZERO);
        private final int major;
        private final int minor;
        private final int patch;
        private final int eaType;
        private final VersionNumber eaVersion;

        static Release parse(String value) {
            Matcher matcher = PATTERN.matcher(value);
            if (!matcher.matches()) {
                throw new IllegalArgumentException(value);
            }
            int minor = Integer.parseInt(matcher.group("minor"));
            String patchString = matcher.group("patch");
            int patch = patchString != null ? Integer.parseInt(patchString) : 0;
            String eaTypeString = matcher.group("eaType");
            int eaType = eaTypeString == null ? Integer.MAX_VALUE : ("-pre".equals(eaTypeString) || " Pre-Release ".equals(eaTypeString) ? 2 : ("-rc".equals(eaTypeString) ? 3 : ("-exp".equals(eaTypeString) ? 1 : 0)));
            String eaVersionString = matcher.group("eaVersion");
            VersionNumber eaVersion = eaVersionString != null ? VersionNumber.asVersion(eaVersionString) : VersionNumber.ZERO;
            return new Release(value, 1, minor, patch, eaType, eaVersion);
        }

        Release(String value, int major, int minor, int patch, int eaType, VersionNumber eaVersion) {
            super(value);
            this.major = major;
            this.minor = minor;
            this.patch = patch;
            this.eaType = eaType;
            this.eaVersion = eaVersion;
        }

        @Override
        Type getType() {
            return Type.NEW;
        }

        int compareToRelease(Release other) {
            int c = Integer.compare(this.major, other.major);
            if (c != 0) {
                return c;
            }
            c = Integer.compare(this.minor, other.minor);
            if (c != 0) {
                return c;
            }
            c = Integer.compare(this.patch, other.patch);
            if (c != 0) {
                return c;
            }
            c = Integer.compare(this.eaType, other.eaType);
            if (c != 0) {
                return c;
            }
            return this.eaVersion.compareTo(other.eaVersion);
        }

        int compareToSnapshot(Snapshot other) {
            int idx = Arrays.binarySearch(Versions.SNAPSHOT_INTS, other.intValue);
            if (idx >= 0) {
                return this.compareToRelease(Versions.SNAPSHOT_PREV[idx]) <= 0 ? -1 : 1;
            }
            if ((idx = -(idx + 1)) == Versions.SNAPSHOT_INTS.length) {
                return -1;
            }
            return this.compareToRelease(Versions.SNAPSHOT_PREV[idx]) <= 0 ? -1 : 1;
        }

        @Override
        int compareToImpl(@NotNull GameVersionNumber other) {
            if (other instanceof Release) {
                return this.compareToRelease((Release)other);
            }
            if (other instanceof Snapshot) {
                return this.compareToSnapshot((Snapshot)other);
            }
            if (other instanceof Special) {
                return -((Special)other).compareToReleaseOrSnapshot(this);
            }
            throw new AssertionError(other.getClass());
        }

        public int hashCode() {
            return Objects.hash(this.major, this.minor, this.patch, this.eaType, this.eaVersion);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Release other = (Release)o;
            return this.major == other.major && this.minor == other.minor && this.patch == other.patch && this.eaType == other.eaType && this.eaVersion.equals(other.eaVersion);
        }
    }

    static final class Snapshot
    extends GameVersionNumber {
        final int intValue;

        static Snapshot parse(String value) {
            int week;
            int year;
            if (value.length() != 6 || value.charAt(2) != 'w') {
                throw new IllegalArgumentException(value);
            }
            try {
                year = Integer.parseInt(value.substring(0, 2));
                week = Integer.parseInt(value.substring(3, 5));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(value);
            }
            char suffix = value.charAt(5);
            if ((suffix < 'a' || suffix > 'z') && suffix != '~') {
                throw new IllegalArgumentException(value);
            }
            return new Snapshot(value, year, week, suffix);
        }

        static int toInt(int year, int week, char suffix) {
            return year << 16 | week << 8 | suffix;
        }

        Snapshot(String value, int year, int week, char suffix) {
            super(value);
            this.intValue = Snapshot.toInt(year, week, suffix);
        }

        @Override
        Type getType() {
            return Type.NEW;
        }

        @Override
        int compareToImpl(@NotNull GameVersionNumber other) {
            if (other instanceof Release) {
                return -((Release)other).compareToSnapshot(this);
            }
            if (other instanceof Snapshot) {
                return Integer.compare(this.intValue, ((Snapshot)other).intValue);
            }
            if (other instanceof Special) {
                return -((Special)other).compareToReleaseOrSnapshot(this);
            }
            throw new AssertionError(other.getClass());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Snapshot other = (Snapshot)o;
            return this.intValue == other.intValue;
        }

        public int hashCode() {
            return this.intValue;
        }
    }

    static final class Special
    extends GameVersionNumber {
        private VersionNumber versionNumber;
        private GameVersionNumber prev;

        Special(String value) {
            super(value);
        }

        @Override
        Type getType() {
            return Type.NEW;
        }

        boolean isUnknown() {
            return this.prev == null;
        }

        VersionNumber asVersionNumber() {
            if (this.versionNumber != null) {
                return this.versionNumber;
            }
            this.versionNumber = VersionNumber.asVersion(this.value);
            return this.versionNumber;
        }

        GameVersionNumber getPrevNormalVersion() {
            GameVersionNumber v = this.prev;
            while (v instanceof Special) {
                v = ((Special)v).prev;
            }
            if (v == null) {
                throw new AssertionError((Object)("version: " + this.value));
            }
            return v;
        }

        int compareToReleaseOrSnapshot(GameVersionNumber other) {
            if (this.isUnknown()) {
                return 1;
            }
            if (this.getPrevNormalVersion().compareTo(other) >= 0) {
                return 1;
            }
            return -1;
        }

        int compareToSpecial(Special other) {
            if (this.isUnknown()) {
                return other.isUnknown() ? this.asVersionNumber().compareTo(other.asVersionNumber()) : 1;
            }
            if (other.isUnknown()) {
                return -1;
            }
            if (this.value.equals(other.value)) {
                return 0;
            }
            int c = this.getPrevNormalVersion().compareTo(other.getPrevNormalVersion());
            if (c != 0) {
                return c;
            }
            GameVersionNumber v = this.prev;
            while (v instanceof Special) {
                if (v == other) {
                    return 1;
                }
                v = ((Special)v).prev;
            }
            return -1;
        }

        @Override
        int compareToImpl(@NotNull GameVersionNumber o) {
            if (o instanceof Release) {
                return this.compareToReleaseOrSnapshot(o);
            }
            if (o instanceof Snapshot) {
                return this.compareToReleaseOrSnapshot(o);
            }
            if (o instanceof Special) {
                return this.compareToSpecial((Special)o);
            }
            throw new AssertionError(o.getClass());
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Special other = (Special)o;
            return Objects.equals(this.value, other.value);
        }
    }

    static enum Type {
        PRE_CLASSIC,
        CLASSIC,
        INFDEV,
        ALPHA,
        BETA,
        NEW;

    }
}

