/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.blocks;

import com.lazrproductions.cuffed.CuffedMod;
import com.lazrproductions.cuffed.api.CuffedAPI;
import com.lazrproductions.cuffed.blocks.ReinforcedBarsBlock;
import com.lazrproductions.cuffed.blocks.entity.LockableBlockEntity;
import com.lazrproductions.cuffed.init.ModBlocks;
import com.lazrproductions.cuffed.init.ModItems;
import com.lazrproductions.cuffed.items.KeyItem;
import com.lazrproductions.cuffed.items.KeyRingItem;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CellDoor
extends DoorBlock
implements EntityBlock {
    public static final BooleanProperty IN_BARS = BooleanProperty.m_61465_((String)"in_bars");
    private final BlockSetType type;
    protected static final VoxelShape BARS_NS_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
    protected static final VoxelShape BARS_NORTH_RIGHT_OPEN_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)-7.0, (double)2.0, (double)16.0, (double)9.0);
    protected static final VoxelShape BARS_NORTH_LEFT_OPEN_AABB = Block.m_49796_((double)14.0, (double)0.0, (double)-7.0, (double)16.0, (double)16.0, (double)9.0);
    protected static final VoxelShape BARS_SOUTH_RIGHT_OPEN_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)7.0, (double)2.0, (double)16.0, (double)23.0);
    protected static final VoxelShape BARS_SOUTH_LEFT_OPEN_AABB = Block.m_49796_((double)14.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)23.0);
    protected static final VoxelShape BARS_EW_AABB = Block.m_49796_((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0);
    protected static final VoxelShape BARS_WEST_RIGHT_OPEN_AABB = Block.m_49796_((double)7.0, (double)0.0, (double)0.0, (double)23.0, (double)16.0, (double)2.0);
    protected static final VoxelShape BARS_WEST_LEFT_OPEN_AABB = Block.m_49796_((double)7.0, (double)0.0, (double)14.0, (double)23.0, (double)16.0, (double)16.0);
    protected static final VoxelShape BARS_EAST_RIGHT_OPEN_AABB = Block.m_49796_((double)-7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)2.0);
    protected static final VoxelShape BARS_EAST_LEFT_OPEN_AABB = Block.m_49796_((double)-7.0, (double)0.0, (double)14.0, (double)9.0, (double)16.0, (double)16.0);

    public CellDoor(BlockBehaviour.Properties p, BlockSetType setType) {
        super(p, setType);
        this.type = setType;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_52726_, (Comparable)Direction.NORTH)).m_61124_((Property)f_52727_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_52728_, (Comparable)DoorHingeSide.LEFT)).m_61124_((Property)f_52729_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_52730_, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)IN_BARS, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter getter, @Nonnull BlockPos pos, @Nonnull CollisionContext ctx) {
        if (this.isInBars(state)) {
            Direction facing = (Direction)state.m_61143_((Property)f_52726_);
            if (facing == Direction.NORTH || facing == Direction.SOUTH) {
                if (!((Boolean)state.m_61143_((Property)f_52727_)).booleanValue()) {
                    return BARS_NS_AABB;
                }
                if (facing == Direction.NORTH) {
                    return state.m_61143_((Property)f_52728_) == DoorHingeSide.RIGHT ? BARS_SOUTH_LEFT_OPEN_AABB : BARS_SOUTH_RIGHT_OPEN_AABB;
                }
                return state.m_61143_((Property)f_52728_) == DoorHingeSide.RIGHT ? BARS_NORTH_RIGHT_OPEN_AABB : BARS_NORTH_LEFT_OPEN_AABB;
            }
            if (!((Boolean)state.m_61143_((Property)f_52727_)).booleanValue()) {
                return BARS_EW_AABB;
            }
            if (facing == Direction.WEST) {
                return state.m_61143_((Property)f_52728_) == DoorHingeSide.RIGHT ? BARS_WEST_RIGHT_OPEN_AABB : BARS_WEST_LEFT_OPEN_AABB;
            }
            return state.m_61143_((Property)f_52728_) == DoorHingeSide.RIGHT ? BARS_EAST_LEFT_OPEN_AABB : BARS_EAST_RIGHT_OPEN_AABB;
        }
        return super.m_5940_(state, getter, pos, ctx);
    }

    public BlockSetType m_278711_() {
        return this.type;
    }

    @Nullable
    public BlockState m_5573_(@Nonnull BlockPlaceContext ctx) {
        BlockPos blockpos = ctx.m_8083_();
        Level level = ctx.m_43725_();
        if (blockpos.m_123342_() < level.m_151558_() - 1 && level.m_8055_(blockpos.m_7494_()).m_60629_(ctx)) {
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_52726_, (Comparable)ctx.m_8125_())).m_61124_((Property)f_52728_, (Comparable)this.m_52804_(ctx))).m_61124_((Property)f_52729_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_52727_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_52730_, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)IN_BARS, (Comparable)Boolean.valueOf(this.checkForBars(level, blockpos, ctx.m_8125_())));
        }
        return null;
    }

    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hitResult) {
        if (!level.m_5776_() && hand == InteractionHand.MAIN_HAND) {
            BlockEntity blockEntity;
            ItemStack stack = player.m_150109_().m_36056_();
            BlockPos bottomPos = pos;
            if (level.m_8055_(pos.m_7495_()).m_60734_() instanceof CellDoor) {
                bottomPos = pos.m_7495_();
            }
            if ((blockEntity = level.m_7702_(bottomPos)) instanceof LockableBlockEntity) {
                LockableBlockEntity lockable = (LockableBlockEntity)blockEntity;
                boolean isKeyThatIsBoundToThisLock = stack.m_150930_((Item)ModItems.KEY.get()) && KeyItem.isBoundToLock(stack, lockable.getLockId());
                boolean isKeyRingThatIsBoundToThisLock = stack.m_150930_((Item)ModItems.KEY_RING.get()) && KeyRingItem.hasBoundId(stack, lockable.getLockId());
                boolean isCreativeKey = stack.m_150930_((Item)ModItems.CREATIVE_KEY.get());
                boolean isCreativeBindBreaker = stack.m_150930_((Item)ModItems.CREATIVE_BIND_BREAKER.get());
                boolean isLockpick = stack.m_150930_((Item)ModItems.LOCKPICK.get());
                if (!isLockpick) {
                    if (isCreativeBindBreaker) {
                        lockable.resetBinding();
                        player.m_213846_((Component)Component.m_237110_((String)"item.cuffed.creative_bind_breaker.use", (Object[])new Object[]{Component.m_237115_((String)this.m_7705_())}));
                        return InteractionResult.SUCCESS;
                    }
                    if (isKeyThatIsBoundToThisLock || isKeyRingThatIsBoundToThisLock || isCreativeKey) {
                        boolean willEndUpLocked = !lockable.isLocked();
                        lockable.setLocked(willEndUpLocked, level, player, bottomPos);
                        return InteractionResult.SUCCESS;
                    }
                    if (!lockable.isLocked()) {
                        state = (BlockState)state.m_61122_((Property)f_52727_);
                        level.m_7731_(pos, state, 10);
                        this.playSound(level, pos, (Boolean)state.m_61143_((Property)f_52727_));
                        level.m_142346_((Entity)player, this.m_52815_(state) ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
                        return InteractionResult.SUCCESS;
                    }
                } else {
                    CuffedAPI.Networking.sendLockpickBeginPickingCellDoorPacketToClient((ServerPlayer)player, pos, (Integer)CuffedMod.SERVER_CONFIG.LOCKPICKING_SPEED_INCREASE_PER_PICK_FOR_BREAKING_CELL_DOORS.get(), (Integer)CuffedMod.SERVER_CONFIG.LOCKPICKING_PROGRESS_PER_PICK_FOR_BREAKING_CELL_DOORS.get());
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
            }
        }
        return InteractionResult.FAIL;
    }

    private void playSound(Level level, BlockPos pos, boolean open) {
        level.m_5594_(null, pos, open ? SoundEvents.f_12056_ : SoundEvents.f_12056_, SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.1f + 0.9f);
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_52730_, f_52726_, f_52727_, f_52728_, f_52729_, IN_BARS});
    }

    public BlockState m_7417_(@Nonnull BlockState state, @Nonnull Direction updateDirection, @Nonnull BlockState otherState, @Nonnull LevelAccessor level, @Nonnull BlockPos pos, @Nonnull BlockPos otherPos) {
        boolean flag5;
        Direction facing = (Direction)state.m_61143_((Property)f_52726_);
        boolean isBottom = state.m_61143_((Property)f_52730_) == DoubleBlockHalf.LOWER;
        boolean flag3 = false;
        if (isBottom) {
            BlockPos top = pos.m_7494_();
            if (this.checkForBars((Level)level, top, facing)) {
                flag3 = true;
            }
        } else {
            BlockPos below = pos.m_7495_();
            if (this.checkForBars((Level)level, below, facing)) {
                flag3 = true;
            }
        }
        boolean flag = this.checkForBars((Level)level, pos, facing);
        boolean flag2 = this.isInBars(state);
        if (flag != flag2 && flag == flag3) {
            return (BlockState)state.m_61124_((Property)IN_BARS, (Comparable)Boolean.valueOf(flag));
        }
        boolean flag4 = isBottom && pos.m_7494_().equals((Object)otherPos) && otherState.m_60713_((Block)ModBlocks.CELL_DOOR.get());
        boolean bl = flag5 = !isBottom && pos.m_7495_().equals((Object)otherPos) && otherState.m_60713_((Block)ModBlocks.CELL_DOOR.get());
        if (flag4 || flag5) {
            // empty if block
        }
        return super.m_7417_(state, updateDirection, otherState, level, pos, otherPos);
    }

    public void m_6861_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Block block, @Nonnull BlockPos pos2, boolean query) {
    }

    public boolean isInBars(BlockState state) {
        return (Boolean)state.m_61143_((Property)IN_BARS);
    }

    public boolean checkForBars(Level level, BlockPos pos, Direction facing) {
        if (facing == Direction.NORTH || facing == Direction.SOUTH) {
            BlockState other = level.m_8055_(pos.m_122024_());
            boolean leftIs = other.m_204336_(BlockTags.f_13032_) || other.m_60734_() instanceof IronBarsBlock || other.m_60734_() instanceof ReinforcedBarsBlock;
            other = level.m_8055_(pos.m_122029_());
            boolean rightIs = other.m_204336_(BlockTags.f_13032_) || other.m_60734_() instanceof IronBarsBlock || other.m_60734_() instanceof ReinforcedBarsBlock;
            return leftIs && rightIs;
        }
        BlockState other = level.m_8055_(pos.m_122012_());
        boolean leftIs = other.m_204336_(BlockTags.f_13032_) || other.m_60734_() instanceof IronBarsBlock || other.m_60734_() instanceof ReinforcedBarsBlock || other.m_60734_() instanceof CellDoor;
        other = level.m_8055_(pos.m_122019_());
        boolean rightIs = other.m_204336_(BlockTags.f_13032_) || other.m_60734_() instanceof IronBarsBlock || other.m_60734_() instanceof ReinforcedBarsBlock || other.m_60734_() instanceof CellDoor;
        return leftIs && rightIs;
    }

    private DoorHingeSide m_52804_(BlockPlaceContext p_52805_) {
        boolean flag1;
        Level blockgetter = p_52805_.m_43725_();
        BlockPos blockpos = p_52805_.m_8083_();
        Direction direction = p_52805_.m_8125_();
        BlockPos blockpos1 = blockpos.m_7494_();
        Direction direction1 = direction.m_122428_();
        BlockPos blockpos2 = blockpos.m_121945_(direction1);
        BlockState blockstate = blockgetter.m_8055_(blockpos2);
        BlockPos blockpos3 = blockpos1.m_121945_(direction1);
        BlockState blockstate1 = blockgetter.m_8055_(blockpos3);
        Direction direction2 = direction.m_122427_();
        BlockPos blockpos4 = blockpos.m_121945_(direction2);
        BlockState blockstate2 = blockgetter.m_8055_(blockpos4);
        BlockPos blockpos5 = blockpos1.m_121945_(direction2);
        BlockState blockstate3 = blockgetter.m_8055_(blockpos5);
        int i = (blockstate.m_60838_((BlockGetter)blockgetter, blockpos2) ? -1 : 0) + (blockstate1.m_60838_((BlockGetter)blockgetter, blockpos3) ? -1 : 0) + (blockstate2.m_60838_((BlockGetter)blockgetter, blockpos4) ? 1 : 0) + (blockstate3.m_60838_((BlockGetter)blockgetter, blockpos5) ? 1 : 0);
        boolean flag = blockstate.m_60713_((Block)this) && blockstate.m_61143_((Property)f_52730_) == DoubleBlockHalf.LOWER;
        boolean bl = flag1 = blockstate2.m_60713_((Block)this) && blockstate2.m_61143_((Property)f_52730_) == DoubleBlockHalf.LOWER;
        if ((!flag || flag1) && i <= 0) {
            if ((!flag1 || flag) && i >= 0) {
                int j = direction.m_122429_();
                int k = direction.m_122431_();
                Vec3 vec3 = p_52805_.m_43720_();
                double d0 = vec3.f_82479_ - (double)blockpos.m_123341_();
                double d1 = vec3.f_82481_ - (double)blockpos.m_123343_();
                return !(j < 0 && d1 < 0.5 || j > 0 && d1 > 0.5 || k < 0 && d0 > 0.5 || k > 0 && d0 < 0.5) ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
            }
            return DoorHingeSide.LEFT;
        }
        return DoorHingeSide.RIGHT;
    }

    @Nullable
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        if (state.m_61143_((Property)f_52730_) == DoubleBlockHalf.LOWER) {
            return new LockableBlockEntity(pos, state, this.m_7705_());
        }
        return null;
    }
}

