/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.event;

import com.lazrproductions.cuffed.api.CuffedAPI;
import com.lazrproductions.cuffed.cap.base.IRestrainableCapability;
import com.lazrproductions.cuffed.client.gui.screen.GenericScreen;
import com.lazrproductions.cuffed.effect.RestrainedEffectInstance;
import com.lazrproductions.cuffed.entity.base.IRestrainableEntity;
import com.lazrproductions.cuffed.init.ModTags;
import com.lazrproductions.cuffed.restraints.custom.DuckTapeHeadRestraint;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ModClientEvents {
    static final String[] variants = new String[]{"mph", "mhm", "hmm", "fmp", "mpr", "mrp"};

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Minecraft inst = Minecraft.m_91087_();
            Screen screen = inst.f_91080_;
            if (screen instanceof GenericScreen) {
                GenericScreen sc = (GenericScreen)screen;
                sc.m_86600_();
            }
            if (inst.f_91074_ != null) {
                IRestrainableCapability cap = CuffedAPI.Capabilities.getRestrainableCapability((Player)inst.f_91074_);
                cap.tickClient((Player)inst.f_91074_);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player p = event.getEntity();
        if (p != null) {
            IRestrainableCapability cap = CuffedAPI.Capabilities.getRestrainableCapability(p);
            cap.onLoginClient(p);
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        Player p = event.getEntity();
        if (p != null) {
            IRestrainableCapability cap = CuffedAPI.Capabilities.getRestrainableCapability(p);
            cap.onLogoutClient(p);
        }
    }

    @SubscribeEvent
    public void onEntityDied(LivingDeathEvent event) {
        Player player;
        IRestrainableCapability cap;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (cap = CuffedAPI.Capabilities.getRestrainableCapability(player = (Player)livingEntity)) != null) {
            cap.onDeathClient(player);
        }
    }

    @SubscribeEvent
    public void onLand(LivingFallEvent event) {
        Player player;
        IRestrainableCapability cap;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (cap = CuffedAPI.Capabilities.getRestrainableCapability(player = (Player)livingEntity)) != null) {
            cap.onLandClient(player, event.getDistance(), event.getDamageMultiplier());
        }
    }

    @SubscribeEvent
    public void onJump(LivingEvent.LivingJumpEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            IRestrainableEntity res;
            Player player = (Player)livingEntity;
            IRestrainableCapability cap = CuffedAPI.Capabilities.getRestrainableCapability(player);
            if (cap != null) {
                cap.onJumpClient(player);
            }
            if (RestrainedEffectInstance.decodeNoJumping((res = (IRestrainableEntity)player).getRestraintCode())) {
                if (player.m_20142_() && RestrainedEffectInstance.decodeNoMovement(res.getRestraintCode())) {
                    player.m_20334_(0.0, -1.0, 0.0);
                } else {
                    player.m_20334_(player.m_20184_().f_82479_, -1.0, player.m_20184_().f_82481_);
                }
            }
        }
    }

    @SubscribeEvent
    public void renderGUI(RenderGuiOverlayEvent.Post event) {
        Minecraft inst = Minecraft.m_91087_();
        LocalPlayer p = inst.f_91074_;
        if (p != null) {
            IRestrainableCapability cap = CuffedAPI.Capabilities.getRestrainableCapability((Player)p);
            cap.renderOverlay((Player)p, event.getGuiGraphics(), event.getPartialTick(), event.getWindow());
        }
    }

    @SubscribeEvent
    public void chat(ClientChatEvent event) {
        IRestrainableEntity e;
        Minecraft instance = Minecraft.m_91087_();
        LocalPlayer localPlayer = instance.f_91074_;
        if (localPlayer instanceof IRestrainableEntity && (e = (IRestrainableEntity)localPlayer).getHeadRestraintId().equals((Object)DuckTapeHeadRestraint.ID)) {
            event.setMessage(this.mufflifyPhrase(event.getMessage()));
        }
    }

    String mufflifyPhrase(String message) {
        String[] words = message.split(" ");
        Object output = "";
        for (int i = 0; i < words.length; ++i) {
            output = (String)output + this.mufflifyWord(words[i]);
            if (i >= words.length - 1) continue;
            output = (String)output + " ";
        }
        return output;
    }

    String mufflifyWord(String word) {
        String myVariant = variants[new Random().nextInt(3)];
        Object output = "";
        for (int i = 0; i < word.length(); ++i) {
            char c = word.charAt(i);
            if (Character.isLetter(c)) {
                if (i == word.length() - 1) {
                    output = (String)output + myVariant.charAt(2);
                    continue;
                }
                if (i == word.length() - 2) {
                    output = (String)output + myVariant.charAt(1);
                    continue;
                }
                output = (String)output + myVariant.charAt(0);
                continue;
            }
            output = (String)output + c;
        }
        return output;
    }

    @SubscribeEvent
    public void computeFov(ComputeFovModifierEvent event) {
        IRestrainableEntity e = (IRestrainableEntity)event.getPlayer();
        if (RestrainedEffectInstance.decodeNoMovement(e.getRestraintCode())) {
            event.setNewFovModifier(1.0f);
        }
    }

    @SubscribeEvent
    public void onOpenScreen(ScreenEvent.Opening event) {
        IRestrainableEntity restrainable;
        LocalPlayer player;
        Minecraft inst;
        if (event.getNewScreen() instanceof InventoryScreen && (inst = Minecraft.m_91087_()) != null && (player = inst.f_91074_) != null && RestrainedEffectInstance.decodeNoItemUse((restrainable = (IRestrainableEntity)player).getRestraintCode())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onInteractionKeyMappingTriggered(InputEvent.InteractionKeyMappingTriggered event) {
        LocalPlayer player;
        Minecraft inst = Minecraft.m_91087_();
        if (inst != null && (player = inst.f_91074_) != null) {
            BlockState pickresult;
            IRestrainableEntity restrainable = (IRestrainableEntity)player;
            if (restrainable.isRestrained()) {
                if (!event.isAttack()) {
                    if (RestrainedEffectInstance.decodeNoItemUse(restrainable.getRestraintCode())) {
                        event.setCanceled(true);
                    }
                } else if (RestrainedEffectInstance.decodeNoMining(restrainable.getRestraintCode())) {
                    event.setCanceled(true);
                }
            }
            ItemStack handItem = player.m_21120_(InteractionHand.MAIN_HAND);
            if (!player.m_7500_() && !handItem.m_204117_(ItemTags.f_271360_) && event.isAttack() && (pickresult = ModClientEvents.GetSelectedBlock((Player)player, false)) != null && pickresult.m_204336_(ModTags.Blocks.REINFORCED_BLOCKS) && !(inst.f_91077_ instanceof EntityHitResult)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onMouseScroll(InputEvent.MouseScrollingEvent event) {
        IRestrainableEntity restrainable;
        LocalPlayer player;
        Minecraft inst = Minecraft.m_91087_();
        if (inst != null && (player = inst.f_91074_) != null && (restrainable = (IRestrainableEntity)player).isRestrained() && RestrainedEffectInstance.decodeNoItemUse(restrainable.getRestraintCode())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRenderPlayer(RenderPlayerEvent event) {
    }

    public static BlockState GetSelectedBlock(Player player, boolean isFluid) {
        HitResult block = player.m_19907_(20.0, 0.0f, isFluid);
        if (block.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos blockpos = ((BlockHitResult)block).m_82425_();
            return player.m_9236_().m_8055_(blockpos);
        }
        return null;
    }

    public static BlockPos GetSelectedBlockPos(Player player, boolean isFluid) {
        HitResult block = player.m_19907_(20.0, 0.0f, isFluid);
        if (block.m_6662_() == HitResult.Type.BLOCK) {
            return ((BlockHitResult)block).m_82425_();
        }
        return null;
    }

    public static boolean isTargettingEntity(Player player, boolean isFluid) {
        HitResult block = player.m_19907_(20.0, 0.0f, isFluid);
        return block.m_6662_() == HitResult.Type.ENTITY;
    }

    public static boolean isLocalPlayer(Player player) {
        Minecraft inst = Minecraft.m_91087_();
        if (inst != null) {
            if (player == null) {
                return false;
            }
            LocalPlayer localPlayer = inst.f_91074_;
            if (localPlayer == null) {
                return false;
            }
            return player.m_20148_() == localPlayer.m_20148_();
        }
        return false;
    }
}

