/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.event;

import com.lazrproductions.cuffed.CuffedMod;
import com.lazrproductions.cuffed.api.CuffedAPI;
import com.lazrproductions.cuffed.blocks.PilloryBlock;
import com.lazrproductions.cuffed.blocks.base.ILockableBlock;
import com.lazrproductions.cuffed.cap.RestrainableCapability;
import com.lazrproductions.cuffed.cap.base.IRestrainableCapability;
import com.lazrproductions.cuffed.cap.provider.RestrainableCapabilityProvider;
import com.lazrproductions.cuffed.entity.ChainKnotEntity;
import com.lazrproductions.cuffed.entity.CrumblingBlockEntity;
import com.lazrproductions.cuffed.entity.base.IAnchorableEntity;
import com.lazrproductions.cuffed.entity.base.IDetainableEntity;
import com.lazrproductions.cuffed.entity.base.INicknamable;
import com.lazrproductions.cuffed.init.ModBlocks;
import com.lazrproductions.cuffed.init.ModEnchantments;
import com.lazrproductions.cuffed.init.ModItems;
import com.lazrproductions.cuffed.init.ModTags;
import com.lazrproductions.cuffed.items.PossessionsBox;
import com.lazrproductions.cuffed.restraints.base.AbstractArmRestraint;
import com.lazrproductions.cuffed.restraints.base.AbstractLegRestraint;
import com.lazrproductions.cuffed.restraints.base.IEnchantableRestraint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;

public class ModServerEvents {
    HashMap<UUID, CompoundTag> deadEntityRestraintData = new HashMap();
    HashMap<UUID, String> deadEntityNicknameData = new HashMap();

    @SubscribeEvent
    public void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player && !((Entity)event.getObject()).getCapability(CuffedAPI.Capabilities.RESTRAINABLE_CAPABILITY).isPresent()) {
            event.addCapability(CuffedAPI.Capabilities.RESTRAINABLE_CAPABILITY_NAME, (ICapabilityProvider)new RestrainableCapabilityProvider());
        }
    }

    @SubscribeEvent
    public void onPlayerCloned(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            if (this.deadEntityRestraintData.containsKey(event.getEntity().m_20148_())) {
                event.getEntity().getCapability(CuffedAPI.Capabilities.RESTRAINABLE_CAPABILITY).ifPresent(n -> {
                    n.copyFrom(this.deadEntityRestraintData.get(event.getEntity().m_20148_()), (ServerLevel)event.getEntity().m_9236_());
                    this.deadEntityRestraintData.remove(event.getEntity().m_20148_());
                });
            }
            if (this.deadEntityNicknameData.containsKey(event.getEntity().m_20148_())) {
                INicknamable nick = (INicknamable)event.getEntity();
                nick.deserializeNickname(this.deadEntityNicknameData.get(event.getEntity().m_20148_()));
                this.deadEntityNicknameData.remove(event.getEntity().m_20148_());
            }
        }
    }

    @SubscribeEvent
    public void tickServer(TickEvent.PlayerTickEvent event) {
        ServerPlayer p;
        if (event.phase == TickEvent.Phase.END && event.side == LogicalSide.SERVER && (p = (ServerPlayer)event.player) != null) {
            AttributeInstance a = p.m_21051_(Attributes.f_22279_);
            if (a != null) {
                a.m_22120_(UUID.fromString("3b44d328-0746-45c9-85e3-c2df6c70d4a3"));
            }
            IRestrainableCapability cap = CuffedAPI.Capabilities.getRestrainableCapability((Player)p);
            cap.tickServer(p);
        }
    }

    @SubscribeEvent
    public void playerMineBlock(BlockEvent.BreakEvent event) {
        BlockState pickresult = event.getState();
        if (pickresult.m_204336_(ModTags.Blocks.REINFORCED_BLOCKS) && !event.getPlayer().m_7500_() && !event.getPlayer().m_21120_(InteractionHand.MAIN_HAND).m_204117_(ItemTags.f_271360_)) {
            event.setCanceled(true);
            return;
        }
        Level level = (Level)event.getLevel();
        BlockPos pickpos = event.getPos();
        IDetainableEntity detainableEntity = (IDetainableEntity)event.getPlayer();
        if (detainableEntity.getDetained() > -1) {
            event.setCanceled(true);
            return;
        }
        if (CuffedAPI.Lockpicking.isLockedAt(level, pickresult, pickpos)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void playerInteractBlock(PlayerInteractEvent.RightClickBlock event) {
        Level level;
        if (event.getHand() == InteractionHand.MAIN_HAND && !(level = event.getEntity().m_9236_()).m_5776_()) {
            ItemStack stack;
            Player interacting = event.getEntity();
            IRestrainableCapability cap = CuffedAPI.Capabilities.getRestrainableCapability(interacting);
            IDetainableEntity detainableEntity = (IDetainableEntity)interacting;
            BlockPos pos = event.getPos();
            BlockState state = level.m_8055_(pos);
            if (detainableEntity.getDetained() > -1) {
                event.setCancellationResult(InteractionResult.FAIL);
                event.setCanceled(true);
                return;
            }
            ArrayList<IAnchorableEntity> entitiesAnchoredToInteractor = new ArrayList<IAnchorableEntity>(0);
            ServerLevel server = (ServerLevel)event.getLevel();
            if (server != null) {
                for (Object t : server.m_8583_()) {
                    IAnchorableEntity en;
                    if (!(t instanceof IAnchorableEntity) || !(en = (IAnchorableEntity)t).isAnchored() || en.getAnchor().m_20148_() != interacting.m_20148_()) continue;
                    entitiesAnchoredToInteractor.add(en);
                }
            }
            if ((state.m_204336_(Tags.Blocks.FENCES) && ((Boolean)CuffedMod.SERVER_CONFIG.ANCHORING_ALLOW_ANCHORING_TO_FENCES.get()).booleanValue() || state.m_60713_(Blocks.f_50266_) && ((Boolean)CuffedMod.SERVER_CONFIG.ANCHORING_ALLOW_ANCHORING_TO_TRIPWIRE_HOOKS.get()).booleanValue()) && entitiesAnchoredToInteractor.size() > 0) {
                for (int i = 0; i < entitiesAnchoredToInteractor.size(); ++i) {
                    ChainKnotEntity.bindEntityToNewOrExistingKnot((LivingEntity)entitiesAnchoredToInteractor.get(i), level, event.getPos());
                }
                event.setCanceled(true);
                return;
            }
            if (state.m_60713_((Block)ModBlocks.PILLORY.get())) {
                if (level.m_8055_(pos.m_7494_()).m_60713_((Block)ModBlocks.PILLORY.get())) {
                    state = level.m_8055_(pos.m_7494_());
                }
                if (cap.getWhoImEscorting() != null) {
                    cap.getWhoImEscorting().m_20219_(PilloryBlock.getPositionBehind(state, pos));
                    cap.stopEscortingPlayer();
                }
            }
            if (state.m_204336_(ModTags.Blocks.REINFORCED_BLOCKS) && Block.m_49916_((VoxelShape)state.m_60808_((BlockGetter)level, pos)) && ((stack = event.getItemStack()).m_150930_((Item)ModItems.FORK.get()) || stack.m_150930_((Item)ModItems.SPOON.get()))) {
                Random r = new Random();
                if (r.nextFloat() < 0.25f) {
                    CrumblingBlockEntity.crumbleBlock(level, pos, state, 1);
                }
                level.m_5594_(null, pos, SoundEvents.f_12446_, SoundSource.BLOCKS, 1.0f, r.nextFloat() * 0.2f + 0.9f);
                level.m_5898_(null, 2001, pos, Block.m_49956_((BlockState)state));
                stack.m_41622_(1, (LivingEntity)interacting, f -> f.m_21190_(event.getHand()));
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
            if (CuffedAPI.Lockpicking.isLockedAt(level, state, pos) && !(state.m_60734_() instanceof ILockableBlock)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void playerInteractEntity(PlayerInteractEvent.EntityInteract event) {
        if (event.getSide() == LogicalSide.CLIENT) {
            return;
        }
        if (event.getHand() == InteractionHand.MAIN_HAND && event.getSide() == LogicalSide.SERVER) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            IRestrainableCapability myCap = CuffedAPI.Capabilities.getRestrainableCapability((Player)player);
            IDetainableEntity detainableEntity = (IDetainableEntity)player;
            if (detainableEntity.getDetained() > -1) {
                event.setCancellationResult(InteractionResult.FAIL);
                event.setCanceled(true);
                return;
            }
            Entity entity = event.getTarget();
            if (entity instanceof ServerPlayer) {
                ServerPlayer target = (ServerPlayer)entity;
                IRestrainableCapability targetCap = CuffedAPI.Capabilities.getRestrainableCapability((Player)target);
                double maxDist = player.m_146892_().m_82554_(target.m_20182_());
                Vec3 interactionPos = new Vec3(target.m_20182_().f_82479_, player.m_20154_().m_82559_((Vec3)new Vec3((double)maxDist, (double)maxDist, (double)maxDist)).m_82549_((Vec3)player.m_146892_()).f_82480_, target.m_20182_().f_82481_);
                if (event.getItemStack().m_150930_((Item)ModItems.POSSESSIONSBOX.get()) && targetCap.armsRestrained()) {
                    PossessionsBox.frisk(player, target, event.getItemStack());
                    event.setCancellationResult(InteractionResult.SUCCESS);
                    event.setCanceled(true);
                    return;
                }
                if (targetCap != null) {
                    targetCap.onInteractedByOther(target, player, interactionPos.f_82480_ - target.m_20182_().f_82480_, event.getItemStack(), event.getHand());
                }
            }
            if (event.getTarget().m_6095_().m_204039_(ModTags.Entities.CHAINABLE_ENTITIES)) {
                Player p;
                IRestrainableCapability cap;
                Entity maxDist;
                IAnchorableEntity anchorableEntity = (IAnchorableEntity)event.getTarget();
                if (((Boolean)CuffedMod.SERVER_CONFIG.ANCHORING_ANCHOR_ONLY_WHEN_RESTRAINED.get()).booleanValue() && (maxDist = event.getTarget()) instanceof Player && !(cap = CuffedAPI.Capabilities.getRestrainableCapability(p = (Player)maxDist)).isRestrained()) {
                    return;
                }
                if (anchorableEntity.isAnchored()) {
                    if (player.m_21120_(event.getHand()).m_150930_(Items.f_41852_)) {
                        anchorableEntity.setAnchoredTo(null);
                        player.m_9236_().m_5594_(null, event.getPos(), SoundEvents.f_11794_, SoundSource.PLAYERS, 0.7f, 1.0f);
                        event.setCancellationResult(InteractionResult.SUCCESS);
                        event.setCanceled(true);
                        return;
                    }
                } else if (player.m_21120_(event.getHand()).m_150930_(Items.f_42026_)) {
                    anchorableEntity.setAnchoredTo((Entity)player);
                    player.m_21120_(InteractionHand.MAIN_HAND).m_41774_(1);
                    player.m_9236_().m_5594_(null, event.getPos(), SoundEvents.f_11745_, SoundSource.PLAYERS, 0.7f, 1.0f);
                    event.setCancellationResult(InteractionResult.SUCCESS);
                    event.setCanceled(true);
                    return;
                }
            }
            if (event.getTarget() != null && !(event.getTarget() instanceof Player) && myCap != null && myCap.getWhoImEscorting() != null && myCap.getWhoImEscorting().m_20329_(event.getTarget())) {
                Level level = player.m_9236_();
                if (level != null) {
                    level.m_6269_(null, event.getTarget(), SoundEvents.f_11678_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                myCap.stopEscortingPlayer();
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
                return;
            }
        }
    }

    public void onPlayerDismount() {
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer p = (ServerPlayer)event.getEntity();
        if (p != null) {
            IRestrainableCapability cap = CuffedAPI.Capabilities.getRestrainableCapability((Player)p);
            cap.onLoginServer(p);
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        ServerPlayer p = (ServerPlayer)event.getEntity();
        if (p != null) {
            IRestrainableCapability cap = CuffedAPI.Capabilities.getRestrainableCapability((Player)p);
            cap.onLogoutServer(p);
        }
    }

    @SubscribeEvent
    public void onEntityDied(LivingDeathEvent event) {
        IAnchorableEntity anchorable;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            IRestrainableCapability cap = CuffedAPI.Capabilities.getRestrainableCapability((Player)player);
            if (cap != null) {
                cap.onDeathServer(player);
                this.deadEntityRestraintData.put(event.getEntity().m_20148_(), cap.serializeNBT());
            }
            INicknamable nick = (INicknamable)player;
            if (((Boolean)CuffedMod.SERVER_CONFIG.NICKNAME_PERSISTS_ON_DEATH.get()).booleanValue()) {
                this.deadEntityNicknameData.put(player.m_20148_(), nick.serializeNickname());
            }
        }
        if ((livingEntity = event.getEntity()) instanceof IAnchorableEntity && (anchorable = (IAnchorableEntity)livingEntity).isAnchored()) {
            anchorable.setAnchoredTo(null);
        }
    }

    @SubscribeEvent
    public void onLand(LivingFallEvent event) {
        ServerPlayer player;
        IRestrainableCapability cap;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer && (cap = CuffedAPI.Capabilities.getRestrainableCapability((Player)(player = (ServerPlayer)livingEntity))) != null) {
            event.setDamageMultiplier(cap.onLandServer(player, event.getDistance(), event.getDamageMultiplier()));
        }
    }

    @SubscribeEvent
    public void onJump(LivingEvent.LivingJumpEvent event) {
        ServerPlayer player;
        IRestrainableCapability cap;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer && (cap = CuffedAPI.Capabilities.getRestrainableCapability((Player)(player = (ServerPlayer)livingEntity))) != null) {
            cap.onJumpServer(player);
        }
    }

    @SubscribeEvent
    public void onLivingDamaged(LivingDamageEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player captor = (Player)livingEntity;
            if (!event.getEntity().m_9236_().m_5776_()) {
                float originalAmount = event.getAmount();
                ServerLevel level = (ServerLevel)event.getEntity().m_9236_();
                MinecraftServer server = event.getEntity().m_9236_().m_7654_();
                if (server != null) {
                    boolean activateImbue = true;
                    ArrayList<Player> playersToTakeDamage = new ArrayList<Player>();
                    List players = server.m_6846_().m_11314_();
                    for (int i = 0; i < players.size(); ++i) {
                        AbstractLegRestraint leg;
                        IRestrainableCapability cap = CuffedAPI.Capabilities.getRestrainableCapability((Player)players.get(i));
                        AbstractArmRestraint arm = cap.getArmRestraint();
                        if (arm != null && arm.getCaptor(level) == captor) {
                            playersToTakeDamage.add((Player)players.get(i));
                        }
                        if ((leg = cap.getLegRestraint()) == null || leg.getCaptor(level) != captor) continue;
                        playersToTakeDamage.add((Player)players.get(i));
                    }
                    if (activateImbue) {
                        float amountNegated = 0.0f;
                        for (Player pl : playersToTakeDamage) {
                            AbstractLegRestraint enchLevel2;
                            float percentage;
                            IEnchantableRestraint e;
                            AbstractArmRestraint abstractArmRestraint;
                            IRestrainableCapability cap = CuffedAPI.Capabilities.getRestrainableCapability(pl);
                            if (cap != null && cap.armsRestrained() && (abstractArmRestraint = cap.getArmRestraint()) instanceof IEnchantableRestraint && (e = (IEnchantableRestraint)((Object)abstractArmRestraint)).hasEnchantment((Enchantment)ModEnchantments.IMBUE.get())) {
                                int enchLevel2 = e.getEnchantmentLevel((Enchantment)ModEnchantments.IMBUE.get());
                                percentage = (float)enchLevel2 / 3.0f * 0.8f;
                                amountNegated += originalAmount * percentage;
                            }
                            if (cap != null && cap.legsRestrained() && (enchLevel2 = cap.getLegRestraint()) instanceof IEnchantableRestraint && (e = (IEnchantableRestraint)((Object)enchLevel2)).hasEnchantment((Enchantment)ModEnchantments.IMBUE.get())) {
                                int enchLevel3 = e.getEnchantmentLevel((Enchantment)ModEnchantments.IMBUE.get());
                                percentage = (float)enchLevel3 / 3.0f * 0.8f;
                                amountNegated += originalAmount * percentage;
                            }
                            pl.m_6469_(captor.m_269291_().m_269425_(), amountNegated / (float)playersToTakeDamage.size());
                        }
                        event.setAmount(Mth.m_14036_((float)(originalAmount - amountNegated), (float)0.0f, (float)originalAmount));
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onCommand(CommandEvent event) {
        RestrainableCapability cap;
        ServerPlayer player = ((CommandSourceStack)event.getParseResults().getContext().getSource()).m_230896_();
        if (player != null && (cap = (RestrainableCapability)CuffedAPI.Capabilities.getRestrainableCapability((Player)player)) != null && cap.restraintsDisabledMovement() && !player.m_20310_(2)) {
            player.m_213846_((Component)Component.m_237113_((String)"You cannot do this right now.").m_130940_(ChatFormatting.RED));
            event.setCanceled(true);
        }
    }
}

