/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.items;

import com.lazrproductions.cuffed.init.ModMenuTypes;
import com.lazrproductions.cuffed.inventory.FriskingContainer;
import com.lazrproductions.cuffed.inventory.FriskingMenu;
import com.lazrproductions.cuffed.inventory.tooltip.PossessionsBoxTooltip;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class PossessionsBox
extends Item {
    public static final String TAG_ITEMS = "Items";

    public PossessionsBox(Item.Properties properties) {
        super(properties);
    }

    public boolean m_142207_(@Nonnull ItemStack thisStack, @Nonnull Slot slot, @Nonnull ClickAction click, @Nonnull Player player) {
        if (thisStack.m_41613_() != 1 || click != ClickAction.SECONDARY) {
            return false;
        }
        ItemStack otherStack = slot.m_7993_();
        if (otherStack.m_41619_()) {
            this.playRemoveOneSound((Entity)player);
            PossessionsBox.removeOne(thisStack).ifPresent(p_150740_ -> PossessionsBox.add(thisStack, slot.m_150659_(p_150740_)));
        }
        return true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (PossessionsBox.dropContents(itemstack, player) && player.m_6047_()) {
            this.playDropContentsSound((Entity)player);
            return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public static ItemStack add(ItemStack stack, ItemStack stackToAdd) {
        if (!stackToAdd.m_41619_()) {
            int k;
            CompoundTag compoundtag = stack.m_41784_();
            if (!compoundtag.m_128441_(TAG_ITEMS)) {
                compoundtag.m_128365_(TAG_ITEMS, (Tag)new ListTag());
            }
            if ((k = stackToAdd.m_41613_()) == 0) {
                return stackToAdd;
            }
            ListTag listtag = compoundtag.m_128437_(TAG_ITEMS, 10);
            ItemStack itemstack1 = stackToAdd.m_255036_(k);
            CompoundTag compoundtag2 = new CompoundTag();
            itemstack1.m_41739_(compoundtag2);
            listtag.add(0, (Tag)compoundtag2);
            return stackToAdd;
        }
        return stackToAdd;
    }

    private static Optional<ItemStack> removeOne(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41784_();
        if (!compoundtag.m_128441_(TAG_ITEMS)) {
            return Optional.empty();
        }
        ListTag listtag = compoundtag.m_128437_(TAG_ITEMS, 10);
        if (listtag.isEmpty()) {
            return Optional.empty();
        }
        CompoundTag compoundtag1 = listtag.m_128728_(0);
        ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compoundtag1);
        listtag.remove(0);
        if (listtag.isEmpty()) {
            stack.m_41749_(TAG_ITEMS);
        }
        return Optional.of(itemstack);
    }

    private static boolean dropContents(ItemStack stack, Player player) {
        CompoundTag compoundtag = stack.m_41784_();
        if (player.m_6047_()) {
            if (!compoundtag.m_128441_(TAG_ITEMS)) {
                return false;
            }
            if (player instanceof ServerPlayer) {
                ListTag listtag = compoundtag.m_128437_(TAG_ITEMS, 10);
                for (int i = 0; i < listtag.size(); ++i) {
                    CompoundTag compoundtag1 = listtag.m_128728_(i);
                    ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compoundtag1);
                    player.m_36176_(itemstack, true);
                }
            }
            stack.m_41749_(TAG_ITEMS);
            return true;
        }
        return false;
    }

    public static Stream<ItemStack> getContents(ItemStack p_150783_) {
        CompoundTag compoundtag = p_150783_.m_41783_();
        if (compoundtag == null) {
            return Stream.empty();
        }
        ListTag listtag = compoundtag.m_128437_(TAG_ITEMS, 10);
        return listtag.stream().map(CompoundTag.class::cast).map(ItemStack::m_41712_);
    }

    public Component m_7626_(@Nonnull ItemStack stack) {
        ListTag listtag;
        CompoundTag compoundtag = stack.m_41784_();
        if (compoundtag.m_128441_(TAG_ITEMS) && (listtag = compoundtag.m_128437_(TAG_ITEMS, 10)).size() > 0) {
            return Component.m_237115_((String)(this.m_5671_(stack) + ".full"));
        }
        return Component.m_237115_((String)(this.m_5671_(stack) + ".empty"));
    }

    public Optional<TooltipComponent> m_142422_(@Nonnull ItemStack p_150775_) {
        NonNullList nonnulllist = NonNullList.m_122779_();
        PossessionsBox.getContents(p_150775_).forEach(arg_0 -> nonnulllist.add(arg_0));
        if (nonnulllist.size() > 0) {
            return Optional.of(new PossessionsBoxTooltip((NonNullList<ItemStack>)nonnulllist));
        }
        return Optional.empty();
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level p_150750_, @Nonnull List<Component> component, @Nonnull TooltipFlag p_150752_) {
        CompoundTag compoundtag = stack.m_41784_();
        if (!compoundtag.m_128441_(TAG_ITEMS)) {
            component.add((Component)Component.m_237115_((String)"item.cuffed.possessions_box.lore.empty").m_130940_(ChatFormatting.GRAY));
        } else {
            ListTag listtag = compoundtag.m_128437_(TAG_ITEMS, 10);
            component.add((Component)Component.m_237110_((String)"item.cuffed.possessions_box.lore.full", (Object[])new Object[]{listtag.size()}).m_130940_(ChatFormatting.GRAY));
        }
    }

    public void m_142023_(@Nonnull ItemEntity p_150728_) {
        ItemUtils.m_150952_((ItemEntity)p_150728_, PossessionsBox.getContents(p_150728_.m_32055_()));
    }

    private void playRemoveOneSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184216_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private void playDropContentsSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184214_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    public static void frisk(@Nonnull ServerPlayer frisker, final @Nonnull ServerPlayer player, final @Nonnull ItemStack boxStack) {
        frisker.m_5893_(new MenuProvider(){

            public Component m_5446_() {
                return player.m_5446_();
            }

            public AbstractContainerMenu m_7208_(int id, @Nonnull Inventory playerInventory, @Nonnull Player p) {
                return new FriskingMenu((MenuType)ModMenuTypes.FRISKING_MENU.get(), id, playerInventory, player.m_19879_(), new FriskingContainer(player, boxStack), 5);
            }
        });
    }
}

