/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.items;

import com.lazrproductions.cuffed.init.ModItems;
import com.lazrproductions.cuffed.inventory.tooltip.TrayTooltip;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class TrayItem
extends BlockItem {
    public static final String TAG_ITEMS = "Items";
    public static final int MAX_WEIGHT = 4;

    public TrayItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public boolean m_142207_(@Nonnull ItemStack stack, @Nonnull Slot slot, @Nonnull ClickAction clickAction, @Nonnull Player player) {
        int j;
        if (stack.m_41613_() != 1 || clickAction != ClickAction.SECONDARY) {
            return false;
        }
        ItemStack itemstack = slot.m_7993_();
        if (itemstack.m_41619_()) {
            this.playRemoveOneSound((Entity)player);
            TrayItem.removeOne(stack).ifPresent(stackInSlot -> TrayItem.add(stack, slot.m_150659_(stackInSlot)));
        } else if (TrayItem.canFitInTray(stack, itemstack) && (j = TrayItem.add(stack, slot.m_150647_(itemstack.m_41613_(), 1, player))) > 0) {
            this.playInsertSound((Entity)player);
        }
        return true;
    }

    public boolean m_142305_(@Nonnull ItemStack stack, @Nonnull ItemStack otherStack, @Nonnull Slot slot, @Nonnull ClickAction clickAction, @Nonnull Player player, @Nonnull SlotAccess slotAccess) {
        if (stack.m_41613_() != 1) {
            return false;
        }
        if (clickAction == ClickAction.SECONDARY && slot.m_150651_(player)) {
            if (otherStack.m_41619_()) {
                TrayItem.removeOne(stack).ifPresent(s -> {
                    this.playRemoveOneSound((Entity)player);
                    slotAccess.m_142104_(s);
                });
            } else {
                int i = TrayItem.add(stack, otherStack);
                if (i > 0) {
                    this.playInsertSound((Entity)player);
                    otherStack.m_41774_(i);
                }
            }
            return true;
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (player.m_6047_() && TrayItem.dropContents(itemstack, player)) {
            this.playDropContentsSound((Entity)player);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
        }
        return super.m_7203_(level, player, hand);
    }

    private static int add(@Nonnull ItemStack stack, @Nonnull ItemStack stackToAdd) {
        if (!stackToAdd.m_41619_() && TrayItem.canFitInTray(stack, stackToAdd)) {
            CompoundTag tag = stack.m_41784_();
            if (!tag.m_128441_(TAG_ITEMS)) {
                tag.m_128365_(TAG_ITEMS, (Tag)TrayItem.saveItemToTagList((NonNullList<ItemStack>)NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_)));
            }
            ListTag listtag = tag.m_128437_(TAG_ITEMS, 10);
            int slotToAddTo = -1;
            if (TrayItem.itemIsFood(stackToAdd)) {
                slotToAddTo = 0;
            }
            if (TrayItem.itemIsFork(stackToAdd)) {
                slotToAddTo = 1;
            }
            if (TrayItem.itemIsSpoon(stackToAdd)) {
                slotToAddTo = 2;
            }
            if (TrayItem.itemIsKnife(stackToAdd)) {
                slotToAddTo = 3;
            }
            if (slotToAddTo > -1 && listtag.m_128728_(slotToAddTo).m_128456_()) {
                ItemStack itemToAddCopy = stackToAdd.m_255036_(1);
                CompoundTag itemToAddData = new CompoundTag();
                itemToAddCopy.m_41739_(itemToAddData);
                listtag.set(slotToAddTo, (Tag)itemToAddData);
                return 1;
            }
        }
        return 0;
    }

    private static Optional<ItemStack> removeOne(ItemStack stack) {
        int toRemove;
        CompoundTag compoundtag = stack.m_41784_();
        if (compoundtag.m_128441_(TAG_ITEMS) && (toRemove = TrayItem.getNextStackIndex(stack)) > -1) {
            ListTag listtag = compoundtag.m_128437_(TAG_ITEMS, 10);
            CompoundTag compoundtag1 = listtag.m_128728_(toRemove);
            ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compoundtag1);
            listtag.set(toRemove, (Tag)new CompoundTag());
            return Optional.of(itemstack);
        }
        return Optional.empty();
    }

    private static boolean dropContents(ItemStack stack, Player player) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_(TAG_ITEMS) && player instanceof ServerPlayer) {
            int i;
            ListTag listtag = tag.m_128437_(TAG_ITEMS, 10);
            for (i = 0; i < listtag.size(); ++i) {
                CompoundTag compoundtag1 = listtag.m_128728_(i);
                ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compoundtag1);
                player.m_36176_(itemstack, true);
            }
            for (i = 0; i < listtag.size(); ++i) {
                listtag.set(i, (Tag)new CompoundTag());
            }
            return true;
        }
        return false;
    }

    public Optional<TooltipComponent> m_142422_(@Nonnull ItemStack stack) {
        NonNullList nonnulllist = NonNullList.m_122779_();
        TrayItem.getContents(stack).forEach(arg_0 -> nonnulllist.add(arg_0));
        return Optional.of(new TrayTooltip((NonNullList<ItemStack>)nonnulllist));
    }

    private void playRemoveOneSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_12029_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private void playInsertSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_12027_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private void playDropContentsSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184214_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    public static NonNullList<ItemStack> getContents(@Nonnull ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        NonNullList list = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
        if (tag.m_128441_(TAG_ITEMS)) {
            ListTag listtag = tag.m_128437_(TAG_ITEMS, 10);
            CompoundTag food = listtag.m_128728_(0);
            CompoundTag fork = listtag.m_128728_(1);
            CompoundTag spoon = listtag.m_128728_(2);
            CompoundTag knife = listtag.m_128728_(3);
            if (!food.m_128456_()) {
                list.set(0, (Object)ItemStack.m_41712_((CompoundTag)food));
            } else {
                list.set(0, (Object)ItemStack.f_41583_);
            }
            if (!fork.m_128456_()) {
                list.set(1, (Object)ItemStack.m_41712_((CompoundTag)fork));
            } else {
                list.set(1, (Object)ItemStack.f_41583_);
            }
            if (!spoon.m_128456_()) {
                list.set(2, (Object)ItemStack.m_41712_((CompoundTag)spoon));
            } else {
                list.set(2, (Object)ItemStack.f_41583_);
            }
            if (!knife.m_128456_()) {
                list.set(3, (Object)ItemStack.m_41712_((CompoundTag)knife));
            } else {
                list.set(3, (Object)ItemStack.f_41583_);
            }
        }
        return list;
    }

    public static NonNullList<ItemStack> getContents(@Nonnull ListTag listtag) {
        NonNullList list = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
        CompoundTag food = listtag.m_128728_(0);
        CompoundTag fork = listtag.m_128728_(1);
        CompoundTag spoon = listtag.m_128728_(2);
        CompoundTag knife = listtag.m_128728_(3);
        if (!food.m_128456_()) {
            list.set(0, (Object)ItemStack.m_41712_((CompoundTag)food));
        } else {
            list.set(0, (Object)ItemStack.f_41583_);
        }
        if (!fork.m_128456_()) {
            list.set(1, (Object)ItemStack.m_41712_((CompoundTag)fork));
        } else {
            list.set(1, (Object)ItemStack.f_41583_);
        }
        if (!spoon.m_128456_()) {
            list.set(2, (Object)ItemStack.m_41712_((CompoundTag)spoon));
        } else {
            list.set(2, (Object)ItemStack.f_41583_);
        }
        if (!knife.m_128456_()) {
            list.set(3, (Object)ItemStack.m_41712_((CompoundTag)knife));
        } else {
            list.set(3, (Object)ItemStack.f_41583_);
        }
        return list;
    }

    public static int getNextStackIndex(@Nonnull ItemStack stack) {
        NonNullList<ItemStack> list = TrayItem.getContents(stack);
        for (int i = 0; i < list.size(); ++i) {
            if (((ItemStack)list.get(i)).m_41619_()) continue;
            return i;
        }
        return -1;
    }

    public static int getNextAvailableIndex(@Nonnull ItemStack stack) {
        NonNullList<ItemStack> list = TrayItem.getContents(stack);
        for (int i = 0; i < list.size(); ++i) {
            if (!((ItemStack)list.get(i)).m_41619_()) continue;
            return i;
        }
        return -1;
    }

    public static ListTag saveItemToTagList(NonNullList<ItemStack> items) {
        CompoundTag tag;
        ListTag listtag = new ListTag();
        ItemStack food = (ItemStack)items.get(0);
        ItemStack fork = (ItemStack)items.get(1);
        ItemStack spoon = (ItemStack)items.get(2);
        ItemStack knife = (ItemStack)items.get(3);
        if (!food.m_41619_()) {
            tag = new CompoundTag();
            listtag.add((Object)food.m_41739_(tag));
        } else {
            listtag.add((Object)new CompoundTag());
        }
        if (!fork.m_41619_()) {
            tag = new CompoundTag();
            listtag.add((Object)fork.m_41739_(tag));
        } else {
            listtag.add((Object)new CompoundTag());
        }
        if (!spoon.m_41619_()) {
            tag = new CompoundTag();
            listtag.add((Object)spoon.m_41739_(tag));
        } else {
            listtag.add((Object)new CompoundTag());
        }
        if (!knife.m_41619_()) {
            tag = new CompoundTag();
            listtag.add((Object)knife.m_41739_(tag));
        } else {
            listtag.add((Object)new CompoundTag());
        }
        return listtag;
    }

    public static ItemStack createTrayFrom(NonNullList<ItemStack> stacks) {
        ItemStack stack = ((Item)ModItems.TRAY.get()).m_7968_();
        CompoundTag tag = stack.m_41784_();
        tag.m_128365_(TAG_ITEMS, (Tag)TrayItem.saveItemToTagList(stacks));
        return stack;
    }

    private static boolean canFitInTray(@Nonnull ItemStack tray, @Nonnull ItemStack stack) {
        boolean trayHasFood = TrayItem.trayHasFoodItem(tray);
        boolean trayHasSpoon = TrayItem.trayHasSpoon(tray);
        boolean trayHasFork = TrayItem.trayHasFork(tray);
        boolean trayHasKnife = TrayItem.trayHasKnife(tray);
        boolean isFood = stack.m_41614_();
        if (isFood) {
            return !trayHasFood;
        }
        if (stack.m_150930_((Item)ModItems.SPOON.get())) {
            return !trayHasSpoon;
        }
        if (stack.m_150930_((Item)ModItems.FORK.get())) {
            return !trayHasFork;
        }
        if (stack.m_150930_((Item)ModItems.KNIFE.get())) {
            return !trayHasKnife;
        }
        return false;
    }

    public static boolean trayHasFoodItem(@Nonnull ItemStack stack) {
        NonNullList<ItemStack> stacks = TrayItem.getContents(stack);
        for (ItemStack itemStack : stacks) {
            if (!itemStack.m_41614_()) continue;
            return true;
        }
        return false;
    }

    public static boolean trayHasSpoon(@Nonnull ItemStack stack) {
        NonNullList<ItemStack> stacks = TrayItem.getContents(stack);
        for (ItemStack itemStack : stacks) {
            if (!itemStack.m_150930_((Item)ModItems.SPOON.get())) continue;
            return true;
        }
        return false;
    }

    public static boolean trayHasFork(@Nonnull ItemStack stack) {
        NonNullList<ItemStack> stacks = TrayItem.getContents(stack);
        for (ItemStack itemStack : stacks) {
            if (!itemStack.m_150930_((Item)ModItems.FORK.get())) continue;
            return true;
        }
        return false;
    }

    public static boolean trayHasKnife(@Nonnull ItemStack stack) {
        NonNullList<ItemStack> stacks = TrayItem.getContents(stack);
        for (ItemStack itemStack : stacks) {
            if (!itemStack.m_150930_((Item)ModItems.KNIFE.get())) continue;
            return true;
        }
        return false;
    }

    public static boolean itemIsFood(@Nonnull ItemStack stack) {
        return stack.m_41614_();
    }

    public static boolean itemIsSpoon(@Nonnull ItemStack stack) {
        return stack.m_150930_((Item)ModItems.SPOON.get());
    }

    public static boolean itemIsFork(@Nonnull ItemStack stack) {
        return stack.m_150930_((Item)ModItems.FORK.get());
    }

    public static boolean itemIsKnife(@Nonnull ItemStack stack) {
        return stack.m_150930_((Item)ModItems.KNIFE.get());
    }
}

