/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.recipes.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lazrproductions.cuffed.init.ModItems;
import com.lazrproductions.cuffed.recipes.KeyMoldBakeRecipe;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class KeyMoldBakeRecipeSerializer<T extends KeyMoldBakeRecipe>
implements RecipeSerializer<T> {
    private final RecipeFactory<T> factory;

    public KeyMoldBakeRecipeSerializer(RecipeFactory<T> factory) {
        this.factory = factory;
    }

    public T fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
        JsonArray ingredientElement = GsonHelper.m_13885_((JsonObject)json, (String)"ingredient") ? GsonHelper.m_13933_((JsonObject)json, (String)"ingredient") : GsonHelper.m_13930_((JsonObject)json, (String)"ingredient");
        Ingredient ingredient = Ingredient.m_43917_((JsonElement)ingredientElement);
        ItemStack result = ((Item)ModItems.KEY_MOLD.get()).m_7968_();
        float experience = GsonHelper.m_13820_((JsonObject)json, (String)"experience", (float)0.0f);
        int cookingTime = GsonHelper.m_13824_((JsonObject)json, (String)"cookingtime", (int)200);
        return this.factory.create(recipeId, group, ingredient, result, experience, cookingTime);
    }

    public T fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
        String group = buffer.m_130277_();
        Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        ItemStack result = buffer.m_130267_();
        float experience = buffer.readFloat();
        int cookingTime = buffer.m_130242_();
        return this.factory.create(recipeId, group, ingredient, result, experience, cookingTime);
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull T recipe) {
        buffer.m_130070_(recipe.m_6076_());
        ((Ingredient)recipe.m_7527_().get(0)).m_43923_(buffer);
        buffer.m_130055_(((Item)ModItems.KEY_MOLD.get()).m_7968_());
        buffer.writeFloat(recipe.m_43750_());
        buffer.m_130130_(recipe.m_43753_());
    }

    public static interface RecipeFactory<T extends KeyMoldBakeRecipe> {
        public T create(ResourceLocation var1, String var2, Ingredient var3, ItemStack var4, float var5, int var6);
    }
}

