/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.restraints.base;

import com.lazrproductions.cuffed.CuffedMod;
import com.lazrproductions.cuffed.compat.ArsNouveauCompat;
import com.lazrproductions.cuffed.compat.IronsSpellsnSpellbooksCompat;
import com.lazrproductions.cuffed.entity.animation.ArmRestraintAnimationFlags;
import com.lazrproductions.cuffed.entity.animation.LegRestraintAnimationFlags;
import com.lazrproductions.cuffed.init.ModEnchantments;
import com.lazrproductions.cuffed.init.ModStatistics;
import com.lazrproductions.cuffed.restraints.base.IBreakableRestraint;
import com.lazrproductions.cuffed.restraints.base.IEnchantableRestraint;
import com.lazrproductions.cuffed.restraints.base.RestraintType;
import com.lazrproductions.cuffed.restraints.client.RestraintModelInterface;
import com.mojang.blaze3d.platform.Window;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class AbstractRestraint {
    private ServerPlayer s_player;
    private Player c_player;
    private CompoundTag itemData;
    @Nonnull
    private UUID captor;
    protected int clientSidedDurability = 100;

    public AbstractRestraint() {
        this.captor = UUID.randomUUID();
    }

    public AbstractRestraint(ItemStack stack, ServerPlayer player, ServerPlayer captor) {
        AbstractRestraint abstractRestraint = this;
        if (abstractRestraint instanceof IEnchantableRestraint) {
            IEnchantableRestraint enchantable = (IEnchantableRestraint)((Object)abstractRestraint);
            enchantable.setEnchantments(stack.m_41785_());
        }
        this.itemData = new CompoundTag();
        stack.m_41739_(this.itemData);
        this.captor = captor.m_20148_();
    }

    public abstract ResourceLocation getId();

    public abstract RestraintType getType();

    public abstract String getActionBarLabel();

    public abstract String getName();

    public abstract Item getItem();

    public abstract Item getKeyItem();

    public abstract boolean AllowItemUse();

    public abstract boolean AllowBreakingBlocks();

    public abstract boolean AllowMovement();

    public abstract boolean AllowJumping();

    public abstract SoundEvent getEquipSound();

    public abstract SoundEvent getUnequipSound();

    public abstract boolean getLockpickable();

    public abstract int getLockpickingSpeedIncreasePerPick();

    public abstract int getLockpickingProgressPerPick();

    public abstract ArrayList<Integer> getBlockedKeyCodes();

    public abstract ArmRestraintAnimationFlags getArmAnimationFlags();

    public abstract LegRestraintAnimationFlags getLegAnimationFlags();

    public boolean canEquipRestraintItem(ItemStack stack, ServerPlayer player, ServerPlayer captor) {
        return true;
    }

    public Player getPlayer() {
        if (this.isClientSide()) {
            return this.c_player;
        }
        return this.s_player;
    }

    @Nullable
    public Player getCaptor(@Nonnull ServerLevel level) {
        return level.m_46003_(this.captor);
    }

    public boolean isClientSide() {
        return this.s_player == null;
    }

    public void onTickServer(ServerPlayer player) {
        this.s_player = player;
        ModStatistics.awardTimeSpentRestrained(player, this);
        AbstractRestraint abstractRestraint = this;
        if (abstractRestraint instanceof IEnchantableRestraint) {
            IEnchantableRestraint e = (IEnchantableRestraint)((Object)abstractRestraint);
            if (e.getEnchantmentLevel((Enchantment)ModEnchantments.FAMINE.get()) >= 1 && !player.m_21023_(MobEffects.f_19612_)) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 100, 1));
            }
            if (e.getEnchantmentLevel((Enchantment)ModEnchantments.SHROUD.get()) >= 1 && !player.m_21023_(MobEffects.f_19610_)) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 100, 1));
            }
            if (e.getEnchantmentLevel((Enchantment)ModEnchantments.EXHAUST.get()) >= 1) {
                if (!player.m_21023_(MobEffects.f_19599_)) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 100, 1));
                }
                if (!player.m_21023_(MobEffects.f_19613_)) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 100, 1));
                }
            }
            if (e.getEnchantmentLevel((Enchantment)ModEnchantments.SILENCE.get()) >= 1) {
                if (CuffedMod.ArsNouveauInstalled) {
                    ArsNouveauCompat.DrainMana(player, 2);
                }
                if (CuffedMod.IronsSpellsnSpellbooksInstalled) {
                    IronsSpellsnSpellbooksCompat.DrainMana(player, 2);
                }
            }
        }
    }

    public void onTickClient(Player player) {
        this.c_player = player;
    }

    public void onEquippedServer(ServerPlayer player, ServerPlayer captor) {
        this.s_player = player;
        this.captor = captor.m_20148_();
        ModStatistics.awardRestrained(player, this);
        Random random = new Random();
        player.m_9236_().m_5594_(null, player.m_20183_(), this.getEquipSound(), SoundSource.PLAYERS, 0.8f, random.nextFloat() * 0.2f + 0.9f);
    }

    public void onEquippedClient(Player player, Player captor) {
        this.c_player = player;
    }

    public void onUnequippedServer(ServerPlayer player) {
        Random random = new Random();
        player.m_9236_().m_5594_(null, player.m_20183_(), this.getUnequipSound(), SoundSource.PLAYERS, 0.8f, random.nextFloat() * 0.2f + 0.9f);
    }

    public void onUnequippedClient(Player player) {
    }

    public abstract void onLoginServer(ServerPlayer var1);

    public abstract void onLoginClient(Player var1);

    public abstract void onLogoutServer(ServerPlayer var1);

    public abstract void onLogoutClient(Player var1);

    public abstract void onDeathServer(ServerPlayer var1);

    public abstract void onDeathClient(Player var1);

    public abstract void onJumpServer(ServerPlayer var1);

    public abstract void onJumpClient(Player var1);

    public abstract float onLandServer(ServerPlayer var1, float var2, float var3);

    public abstract void onLandClient(Player var1, float var2, float var3);

    public abstract void renderOverlay(Player var1, GuiGraphics var2, float var3, Window var4);

    public void onKeyInput(Player player, int keyCode, int action) {
        IBreakableRestraint breakable;
        AbstractRestraint abstractRestraint;
        Minecraft instance = Minecraft.m_91087_();
        if (action == 1 && (abstractRestraint = this) instanceof IBreakableRestraint && (breakable = (IBreakableRestraint)((Object)abstractRestraint)).canBeBrokenOutOf()) {
            breakable.attemptToBreak(player, keyCode, action, instance.f_91066_);
        }
    }

    public void onMouseInput(Player player, int keyCode, int action) {
        IBreakableRestraint breakable;
        AbstractRestraint abstractRestraint;
        Minecraft instance = Minecraft.m_91087_();
        if (action == 1 && (abstractRestraint = this) instanceof IBreakableRestraint && (breakable = (IBreakableRestraint)((Object)abstractRestraint)).canBeBrokenOutOf()) {
            breakable.attemptToBreak(player, keyCode, action, instance.f_91066_);
        }
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public abstract RestraintModelInterface getModelInterface();

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("Id", this.getId().toString());
        tag.m_128359_("Type", this.getType().toString());
        AbstractRestraint abstractRestraint = this;
        if (abstractRestraint instanceof IEnchantableRestraint) {
            IEnchantableRestraint ench = (IEnchantableRestraint)((Object)abstractRestraint);
            tag.m_128365_("Enchantments", (Tag)ench.getEnchantments());
        }
        tag.m_128362_("Captor", this.captor);
        tag.m_128365_("ItemData", (Tag)this.itemData);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        AbstractRestraint abstractRestraint = this;
        if (abstractRestraint instanceof IEnchantableRestraint) {
            IEnchantableRestraint ench = (IEnchantableRestraint)((Object)abstractRestraint);
            ListTag t = nbt.m_128437_("Enchantments", 10);
            ench.setEnchantments(t);
        }
        this.captor = nbt.m_128342_("Captor");
        this.itemData = nbt.m_128469_("ItemData");
    }

    public ItemStack saveToItemStack() {
        ItemStack stack = ItemStack.m_41712_((CompoundTag)this.itemData);
        stack.m_41764_(1);
        AbstractRestraint abstractRestraint = this;
        if (abstractRestraint instanceof IBreakableRestraint) {
            IBreakableRestraint breakable = (IBreakableRestraint)((Object)abstractRestraint);
            stack.m_41721_(breakable.getMaxDurability() - breakable.getDurability());
        }
        if ((abstractRestraint = this) instanceof IEnchantableRestraint) {
            IEnchantableRestraint enchantable = (IEnchantableRestraint)((Object)abstractRestraint);
            EnchantmentHelper.m_44865_((Map)EnchantmentHelper.m_44882_((ListTag)enchantable.getEnchantments()), (ItemStack)stack);
        }
        return stack;
    }

    public void receiveUtilityPacketServer(ServerPlayer player, int utiltiyCode, int integerArg, boolean booleanArg, double doubleArg, String stringArg) {
        AbstractRestraint abstractRestraint;
        if (utiltiyCode == 102 && (abstractRestraint = this) instanceof IBreakableRestraint) {
            IBreakableRestraint breakable = (IBreakableRestraint)((Object)abstractRestraint);
            breakable.incrementDurability(player, integerArg);
        }
    }

    public void receiveUtilityPacketClient(Player player, int utiltiyCode, int integerArg, boolean booleanArg, double doubleArg, String stringArg) {
        AbstractRestraint abstractRestraint;
        if (utiltiyCode == 101) {
            this.clientSidedDurability = integerArg;
        } else if (utiltiyCode == 103 && (abstractRestraint = this) instanceof IBreakableRestraint) {
            IBreakableRestraint breakable = (IBreakableRestraint)((Object)abstractRestraint);
            breakable.onBrokenClient(player);
        }
    }
}

