/*
 * Decompiled with CFR 0.152.
 */
package io.github.reserveword.imblocker;

import com.google.gson.JsonObject;
import io.github.reserveword.imblocker.common.IMBlockerCore;
import io.github.reserveword.imblocker.common.accessor.ModLoaderAccessor;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.minecraft.DetectedVersion;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.loading.FMLLoader;

public class ModLoaderAccessorImpl
implements ModLoaderAccessor {
    private static final int currentProtocolVersion;

    private ModLoaderAccessorImpl() {
    }

    @Override
    public boolean isGameVersionReached(int protocolVersion) {
        return currentProtocolVersion >= protocolVersion;
    }

    @Override
    public boolean hasMod(String modid) {
        return FMLLoader.getLoadingModList().getModFileById(modid) != null;
    }

    @Override
    public ModLoaderAccessor.Mapping getMapping() {
        return ModLoaderAccessor.Mapping.OFFICIAL;
    }

    @Override
    public void registerClientTickEvent(final Runnable tickEvent) {
        MinecraftForge.EVENT_BUS.register(new Object(){

            @SubscribeEvent
            public void onStartTick(TickEvent.ClientTickEvent e) {
                if (e.phase == TickEvent.Phase.START) {
                    tickEvent.run();
                }
            }
        });
    }

    static {
        int protocolVersion;
        try (InputStream is = DetectedVersion.class.getResourceAsStream("/version.json");
             InputStreamReader isr = new InputStreamReader(is);){
            protocolVersion = GsonHelper.m_13927_((JsonObject)GsonHelper.m_13859_((Reader)isr), (String)"protocol_version");
        }
        catch (Exception e) {
            IMBlockerCore.LOGGER.warn("[IMBlocker] Failed to get protocol version!");
            protocolVersion = Integer.MAX_VALUE;
        }
        currentProtocolVersion = protocolVersion;
    }
}

