/*
 * Decompiled with CFR 0.152.
 */
package io.github.reserveword.imblocker.common;

import com.sun.jna.Native;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import io.github.reserveword.imblocker.common.IMBlockerCore;
import io.github.reserveword.imblocker.common.IMManager;
import io.github.reserveword.imblocker.common.MathHelper;
import io.github.reserveword.imblocker.common.gui.FocusManager;
import io.github.reserveword.imblocker.common.gui.FocusableObject;
import io.github.reserveword.imblocker.common.gui.FocusableWidget;
import io.github.reserveword.imblocker.common.gui.Point;
import io.github.reserveword.imblocker.common.gui.Rectangle;
import io.github.reserveword.imblocker.common.jnastructs.COMPOSITIONFORM;
import io.github.reserveword.imblocker.common.jnastructs.LOGFONTW;

final class IMManagerWindows
implements IMManager.PlatformIMManager {
    public static long lastIMStateOnTimestamp = System.currentTimeMillis();
    private final SetConversionStateThread setConversionStateThread = new SetConversionStateThread();
    private boolean preferredEnglishState = false;
    private static final User32 u;

    private static native WinNT.HANDLE ImmGetContext(WinDef.HWND var0);

    private static native WinNT.HANDLE ImmAssociateContext(WinDef.HWND var0, WinNT.HANDLE var1);

    private static native boolean ImmReleaseContext(WinDef.HWND var0, WinNT.HANDLE var1);

    private static native WinNT.HANDLE ImmCreateContext();

    private static native boolean ImmDestroyContext(WinNT.HANDLE var0);

    private static native boolean ImmSetConversionStatus(WinNT.HANDLE var0, int var1, int var2);

    private static native boolean ImmGetCompositionWindow(WinNT.HANDLE var0, COMPOSITIONFORM var1);

    private static native boolean ImmSetCompositionWindow(WinNT.HANDLE var0, COMPOSITIONFORM var1);

    private static native boolean ImmGetCompositionFontW(WinNT.HANDLE var0, LOGFONTW var1);

    private static native boolean ImmSetCompositionFontW(WinNT.HANDLE var0, LOGFONTW var1);

    private static native WinDef.HWND ImmGetDefaultIMEWnd(WinDef.HWND var0);

    public IMManagerWindows() {
        this.setConversionStateThread.start();
    }

    @Override
    public void setState(boolean on) {
        WinDef.HWND hwnd = IMManagerWindows.getActiveWindow();
        WinNT.HANDLE himc = IMManagerWindows.ImmGetContext(hwnd);
        if (himc != null != on) {
            if (on) {
                himc = IMManagerWindows.ImmCreateContext();
                IMManagerWindows.ImmAssociateContext(hwnd, himc);
                lastIMStateOnTimestamp = System.currentTimeMillis();
            } else {
                himc = IMManagerWindows.ImmAssociateContext(hwnd, null);
                IMManagerWindows.ImmDestroyContext(himc);
            }
        }
        IMManagerWindows.ImmReleaseContext(hwnd, himc);
        if (on) {
            this.updateCompositionWindowPos();
            this.updateCompositionFontSize();
        }
    }

    @Override
    public void setEnglishState(boolean englishState) {
        this.preferredEnglishState = englishState;
        if (!this.setConversionStateThread.isScheduled) {
            this.setConversionStateThread.awake();
            this.setConversionStateThread.isScheduled = true;
        }
    }

    private void syncEnglishState() {
        if (this.getConversionStatusCooldown() <= 0L) {
            WinDef.HWND hwnd = IMManagerWindows.getActiveWindow();
            WinNT.HANDLE himc = IMManagerWindows.ImmGetContext(hwnd);
            if (himc != null) {
                IMManagerWindows.ImmSetConversionStatus(himc, this.preferredEnglishState ? 0 : 1, 0);
            }
            IMManagerWindows.ImmReleaseContext(hwnd, himc);
            this.setConversionStateThread.isScheduled = false;
        } else {
            this.setConversionStateThread.awake();
        }
    }

    private long getConversionStatusCooldown() {
        return 60L - (System.currentTimeMillis() - lastIMStateOnTimestamp);
    }

    @Override
    public void updateCompositionWindowPos() {
        FocusableObject focusedWidget;
        WinDef.HWND hwnd = IMManagerWindows.getActiveWindow();
        WinNT.HANDLE himc = IMManagerWindows.ImmGetContext(hwnd);
        if (himc != null && (focusedWidget = FocusManager.getFocusOwner()) != null) {
            Point compositionWindowPos = this.calculateProperCompositionWindowPos(focusedWidget);
            COMPOSITIONFORM cfr = new COMPOSITIONFORM();
            IMManagerWindows.ImmGetCompositionWindow(himc, cfr);
            cfr.dwStyle = 2;
            cfr.ptCurrentPos.x = compositionWindowPos.x();
            cfr.ptCurrentPos.y = compositionWindowPos.y();
            IMManagerWindows.ImmSetCompositionWindow(himc, cfr);
        }
        IMManagerWindows.ImmReleaseContext(hwnd, himc);
    }

    @Override
    public void updateCompositionFontSize() {
        FocusableObject focusedWidget;
        WinDef.HWND hwnd = IMManagerWindows.getActiveWindow();
        WinNT.HANDLE himc = IMManagerWindows.ImmGetContext(hwnd);
        if (himc != null && (focusedWidget = FocusManager.getFocusOwner()) != null) {
            int fontSize = focusedWidget.getFontHeight();
            fontSize = (int)((double)fontSize * focusedWidget.getGuiScale());
            LOGFONTW lplf = new LOGFONTW();
            IMManagerWindows.ImmGetCompositionFontW(himc, lplf);
            lplf.lfHeight = -fontSize;
            lplf.lfWidth = 0;
            lplf.lfWeight = 400;
            lplf.lfCharSet = 0;
            lplf.lfFaceName = "Arial".toCharArray();
            IMManagerWindows.ImmSetCompositionFontW(himc, lplf);
        }
        IMManagerWindows.ImmReleaseContext(hwnd, himc);
    }

    private static WinDef.HWND getActiveWindow() {
        try {
            return u.GetActiveWindow();
        }
        catch (NoSuchMethodError e) {
            return u.GetForegroundWindow();
        }
    }

    private Point calculateProperCompositionWindowPos(FocusableObject inputEntry) {
        try {
            double scaleFactor = inputEntry.getGuiScale();
            Rectangle inputEntryBounds = inputEntry.getBoundsAbs();
            Point caretPos = inputEntry.getCaretPos();
            if (inputEntryBounds == Rectangle.EMPTY && caretPos == Point.TOP_LEFT) {
                return Point.TOP_LEFT;
            }
            int caretX = MathHelper.clamp(caretPos.x(), 0, inputEntryBounds.width());
            int caretY = MathHelper.clamp(caretPos.y(), 0, inputEntryBounds.height());
            caretY = (int)((double)caretY - scaleFactor / 2.0);
            int compositionWindowPosX = inputEntryBounds.x() + caretX;
            int compositionWindowPosY = inputEntryBounds.y() + caretY;
            if (inputEntry instanceof FocusableWidget) {
                int margin = (int)((double)inputEntry.getFontHeight() * scaleFactor / 2.0);
                FocusableWidget inputWidget = (FocusableWidget)inputEntry;
                Rectangle containerBounds = inputWidget.getFocusContainer().getBoundsAbs();
                compositionWindowPosX = MathHelper.clamp(compositionWindowPosX, 0, containerBounds.width() - margin);
                compositionWindowPosY = MathHelper.clamp(compositionWindowPosY, 0, containerBounds.height() - margin);
                compositionWindowPosX += containerBounds.x();
                compositionWindowPosY += containerBounds.y();
            }
            return new Point(compositionWindowPosX, compositionWindowPosY);
        }
        catch (Throwable e) {
            IMBlockerCore.LOGGER.error("[IMBlocker] Failed to calculate caret position: " + e);
            return Point.TOP_LEFT;
        }
    }

    static {
        Native.register((String)"imm32");
        u = User32.INSTANCE;
    }

    private class SetConversionStateThread
    extends Thread {
        private boolean isScheduled = false;

        private SetConversionStateThread() {
        }

        @Override
        public synchronized void run() {
            block0: while (true) {
                this.await(0L);
                while (true) {
                    long cooldown;
                    if ((cooldown = IMManagerWindows.this.getConversionStatusCooldown()) <= 0L) {
                        IMBlockerCore.invokeOnMainThread(() -> IMManagerWindows.this.syncEnglishState());
                        continue block0;
                    }
                    this.await(cooldown);
                }
                break;
            }
        }

        private synchronized void awake() {
            this.notifyAll();
        }

        private void await(long milis) {
            try {
                this.wait(milis);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

