/*
 * Decompiled with CFR 0.152.
 */
package io.github.reserveword.imblocker.common.gui;

import io.github.reserveword.imblocker.common.IMManager;
import io.github.reserveword.imblocker.common.accessor.MinecraftClientAccessor;
import io.github.reserveword.imblocker.common.gui.FocusableObject;
import io.github.reserveword.imblocker.common.gui.FocusableWidget;
import io.github.reserveword.imblocker.common.gui.ImGuiFocusContext;
import io.github.reserveword.imblocker.common.gui.MinecraftFocusContext;
import io.github.reserveword.imblocker.common.gui.Point;
import io.github.reserveword.imblocker.common.gui.Rectangle;

public abstract class FocusContainer
implements FocusableObject {
    public static final FocusContainer MINECRAFT = new MinecraftFocusContext();
    public static final FocusContainer IMGUI = new ImGuiFocusContext();
    double guiScaleFactor = 1.0;
    boolean isFocused;
    boolean preferredState = false;
    FocusableWidget focusedWidget;

    FocusContainer(boolean defaultFocusState) {
        this.isFocused = defaultFocusState;
    }

    public void requestFocus(FocusableWidget toFocus) {
        if (this.focusedWidget != toFocus) {
            this.switchFocus(toFocus);
        }
    }

    public void locateRealFocus() {
    }

    public void removeFocus(FocusableWidget toRemove) {
        if (this.focusedWidget == toRemove) {
            this.restoreContainerFocus();
        }
    }

    public void switchFocus(FocusableWidget toFocus) {
        if (this.focusedWidget != toFocus) {
            if (this.isFocused) {
                if (this.focusedWidget != null) {
                    this.focusedWidget.lostFocus();
                }
                this.focusedWidget = toFocus;
                this.focusedWidget.deliverFocus();
            } else {
                this.focusedWidget = toFocus;
            }
        }
    }

    public void clearFocus() {
        this.restoreContainerFocus();
    }

    public void checkFocusCandidatesVisibility(long lastGameRenderTime) {
    }

    void restoreContainerFocus() {
        if (this.focusedWidget != null) {
            if (this.isFocused) {
                this.focusedWidget.lostFocus();
                FocusableObject.super.deliverFocus();
            }
            this.focusedWidget = null;
        }
    }

    @Override
    public void deliverFocus() {
        this.isFocused = true;
        if (this.focusedWidget != null) {
            this.focusedWidget.deliverFocus();
        } else {
            FocusableObject.super.deliverFocus();
        }
    }

    @Override
    public void lostFocus() {
        this.isFocused = false;
        if (this.focusedWidget != null) {
            this.focusedWidget.lostFocus();
        } else {
            FocusableObject.super.lostFocus();
        }
    }

    public void setPreferredState(boolean preferredState) {
        if (this.preferredState != preferredState) {
            this.preferredState = preferredState;
            if (this.isTrulyFocused()) {
                this.updateIMState();
            }
        }
    }

    @Override
    public boolean getPreferredState() {
        return this.preferredState;
    }

    @Override
    public Rectangle getBoundsAbs() {
        Rectangle bounds = MinecraftClientAccessor.INSTANCE.getWindowBounds();
        return new Rectangle(0, 0, bounds.width(), bounds.height());
    }

    @Override
    public Point getCaretPos() {
        Rectangle bounds = MinecraftClientAccessor.INSTANCE.getWindowBounds();
        return new Point(bounds.width() / 3, bounds.height() / 2);
    }

    public void setGuiScaleFactor(double factor) {
        this.guiScaleFactor = factor;
        IMManager.updateCompositionWindowPos();
        IMManager.updateCompositionFontSize();
    }

    @Override
    public double getGuiScale() {
        return this.guiScaleFactor;
    }
}

