/*
 * Decompiled with CFR 0.152.
 */
package io.github.reserveword.imblocker.mixin;

import io.github.reserveword.imblocker.common.gui.FocusContainer;
import io.github.reserveword.imblocker.common.gui.FocusManager;
import io.github.reserveword.imblocker.common.gui.MinecraftTextFieldWidget;
import io.github.reserveword.imblocker.common.gui.SinglelineCursorInfo;
import io.github.reserveword.imblocker.mixin.AbstractWidgetMixin;
import net.minecraft.client.gui.components.EditBox;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EditBox.class})
public abstract class TextFieldMixin
extends AbstractWidgetMixin
implements MinecraftTextFieldWidget {
    @Shadow
    private boolean f_94098_;
    @Shadow
    private boolean f_94096_;
    @Shadow
    private int f_94100_;
    @Shadow
    private int f_94101_;
    @Shadow
    private String f_94093_;
    private final SinglelineCursorInfo imblocker$cursorInfo;
    private boolean preferredEnglishState;
    @Unique
    private boolean isRenderable;
    @Unique
    private long lastRenderTime;

    public TextFieldMixin() {
        this.imblocker$cursorInfo = new SinglelineCursorInfo(this.f_94096_, this.f_93619_, this.f_94100_, this.f_94101_, this.f_94093_);
        this.preferredEnglishState = this.getPrimaryEnglishState();
        this.isRenderable = true;
    }

    @Shadow
    public abstract boolean m_94204_();

    @Override
    @Inject(method={"setFocused"}, at={@At(value="TAIL")})
    public void focusChanged(boolean isFocused, CallbackInfo ci) {
        this.imblocker$onFocusChanged(this.m_94204_());
    }

    @Inject(method={"setVisible"}, at={@At(value="TAIL")})
    public void visibilityChanged(boolean isVisible, CallbackInfo ci) {
        this.imblocker$onFocusChanged(this.m_94204_());
    }

    @Inject(method={"charTyped"}, at={@At(value="HEAD")}, cancellable=true)
    public void checkFocusTracking(char chr, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (FocusManager.isTrackingFocus) {
            if (this.m_94204_()) {
                FocusContainer.MINECRAFT.switchFocus(this);
                cir.setReturnValue((Object)true);
            } else {
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Inject(method={"onValueChange"}, at={@At(value="TAIL")})
    public void onTextChanged(String newValue, CallbackInfo ci) {
        this.imblocker$onCursorChanged();
    }

    @Override
    public boolean updateCursorInfo() {
        return this.imblocker$cursorInfo.updateCursorInfo(this.f_94096_, this.f_93619_, this.f_94100_, this.f_94101_, this.f_94093_);
    }

    @Override
    public SinglelineCursorInfo getCursorInfo() {
        return this.imblocker$cursorInfo;
    }

    @Override
    public void updateLastRenderTime(CallbackInfoReturnable<Boolean> ci) {
        if (FocusManager.isGameRendering) {
            this.lastRenderTime = System.nanoTime();
        }
    }

    @Overwrite
    public void m_94186_(boolean editable) {
        if (this.f_94098_ != editable) {
            this.f_94098_ = editable;
            this.imblocker$onFocusChanged(this.m_94204_());
        }
    }

    @Override
    public void setPreferredEnglishState(boolean state) {
        if (this.preferredEnglishState != state) {
            this.preferredEnglishState = state;
            if (this.isTrulyFocused()) {
                this.updateEnglishState();
            }
        }
    }

    @Override
    public boolean getPreferredEnglishState() {
        return this.preferredEnglishState;
    }

    @Override
    public void checkVisibility(long lastGameRenderTime) {
        this.setRenderable(this.lastRenderTime > lastGameRenderTime);
    }

    @Unique
    private void setRenderable(boolean renderable) {
        if (this.isRenderable != renderable) {
            this.isRenderable = renderable;
            this.getFocusContainer().locateRealFocus();
        }
    }

    @Override
    @Unique
    public boolean isRenderable() {
        return this.isRenderable;
    }
}

