/*
 * Decompiled with CFR 0.152.
 */
package io.github.reserveword.imblocker.mixin.compat;

import com.ldtteam.blockui.controls.TextField;
import io.github.reserveword.imblocker.common.IMManager;
import io.github.reserveword.imblocker.common.gui.FocusContainer;
import io.github.reserveword.imblocker.common.gui.FocusManager;
import io.github.reserveword.imblocker.common.gui.MinecraftTextFieldWidget;
import io.github.reserveword.imblocker.common.gui.SinglelineCursorInfo;
import io.github.reserveword.imblocker.mixin.compat.BlockUIPaneMixin;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TextField.class}, remap=false)
public abstract class BlockUITextFieldMixin
extends BlockUIPaneMixin
implements MinecraftTextFieldWidget {
    @Shadow
    protected String text;
    @Shadow
    protected int scrollOffset = 0;
    @Shadow
    protected int cursorPosition = 0;
    private double imblocker$guiScale;
    private final SinglelineCursorInfo imblocker$cursorInfo = new SinglelineCursorInfo(true, this.height, this.scrollOffset, this.cursorPosition, this.text);

    @Inject(method={"onFocus"}, at={@At(value="TAIL")})
    public void focusGained(CallbackInfo ci) {
        this.imblocker$onFocusGained();
    }

    @Override
    public void focusLost(CallbackInfo ci) {
        this.imblocker$onFocusLost();
    }

    @Inject(method={"onKeyTyped"}, at={@At(value="HEAD")}, cancellable=true)
    public void checkFocusTracking(char c, int key, CallbackInfoReturnable<Boolean> cir) {
        if (FocusManager.isTrackingFocus) {
            FocusContainer.MINECRAFT.switchFocus(this);
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"onUpdate"}, at={@At(value="TAIL")})
    public void onUpdate(CallbackInfo ci) {
        double currentGuiScale = super.getGuiScale();
        if (this.imblocker$guiScale != currentGuiScale) {
            this.imblocker$guiScale = currentGuiScale;
            IMManager.updateCompositionFontSize();
        }
    }

    @Inject(method={"setCursorPosition"}, at={@At(value="TAIL")})
    public void onCursorChanged(int pos, CallbackInfo ci) {
        this.imblocker$onCursorChanged();
    }

    @Inject(method={"setSelectionEnd"}, at={@At(value="TAIL")})
    public void onSelectionChanged(int pos, CallbackInfo ci) {
        this.imblocker$onCursorChanged();
    }

    @Override
    public boolean updateCursorInfo() {
        return this.imblocker$cursorInfo.updateCursorInfo(true, this.height, this.scrollOffset, this.cursorPosition, this.text);
    }

    @Override
    public SinglelineCursorInfo getCursorInfo() {
        return this.imblocker$cursorInfo;
    }

    @Override
    public double getGuiScale() {
        return this.imblocker$guiScale;
    }
}

