/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.netmusic.api.pojo;

import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class NetEaseMusicList {
    @SerializedName(value="result", alternate={"playlist"})
    private PlayList playList;
    @SerializedName(value="code")
    private int code;

    public PlayList getPlayList() {
        return this.playList;
    }

    public int getCode() {
        return this.code;
    }

    public class PlayList {
        @SerializedName(value="name")
        private String name;
        @SerializedName(value="trackCount")
        private int trackCount;
        @SerializedName(value="playCount")
        private int playCount;
        @SerializedName(value="creator")
        private Creator creator;
        @SerializedName(value="createTime")
        private long createTime;
        @SerializedName(value="subscribedCount")
        private int subscribedCount;
        @SerializedName(value="shareCount")
        private int shareCount;
        @SerializedName(value="tags")
        private List<String> tags = Lists.newArrayList();
        @SerializedName(value="description")
        private String description = "";
        @SerializedName(value="tracks")
        private List<Track> tracks;
        @SerializedName(value="trackIds")
        private List<TrackId> trackIds;

        public String getName() {
            return this.name;
        }

        public int getTrackCount() {
            return this.trackCount;
        }

        public int getPlayCount() {
            return this.playCount;
        }

        public int getSubscribedCount() {
            return this.subscribedCount;
        }

        public int getShareCount() {
            return this.shareCount;
        }

        public String getDescription() {
            return this.description;
        }

        public List<Track> getTracks() {
            return this.tracks;
        }

        public List<TrackId> getTrackIds() {
            return this.trackIds;
        }

        public class TrackId {
            @SerializedName(value="id")
            private long id;

            public long getId() {
                return this.id;
            }
        }
    }

    private static class Album {
        @SerializedName(value="name")
        private String name;

        private Album() {
        }
    }

    private static class Artist {
        @SerializedName(value="name")
        private String name;

        private Artist() {
        }
    }

    private static class Creator {
        @SerializedName(value="nickname")
        private String nickname;

        private Creator() {
        }
    }

    public static class Track {
        @SerializedName(value="id")
        private long id;
        @SerializedName(value="name")
        private String name;
        @SerializedName(value="artists", alternate={"ar"})
        private List<Artist> artists;
        @SerializedName(value="album", alternate={"al"})
        private Album album;
        @SerializedName(value="duration", alternate={"dt"})
        private int duration;
        @SerializedName(value="transNames", alternate={"tns"})
        private List<String> transNames;
        @SerializedName(value="fee")
        private int fee;

        public long getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public List<String> getArtists() {
            if (this.artists == null || this.artists.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList artistNames = Lists.newArrayList();
            this.artists.forEach(artist -> artistNames.add(artist.name));
            return artistNames;
        }

        public Album getAlbum() {
            return this.album;
        }

        public int getDuration() {
            return this.duration;
        }

        public String getTransName() {
            if (this.transNames == null || this.transNames.isEmpty()) {
                return "";
            }
            return this.transNames.get(0);
        }

        public boolean needVip() {
            return this.fee == 1;
        }
    }
}

