/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.netmusic.api.search;

import com.google.gson.annotations.SerializedName;
import java.util.List;
import javax.annotation.Nullable;

public class SearchResponse {
    @SerializedName(value="result")
    private Result result;

    @Nullable
    public Song getFirstSong() {
        if (this.result != null && this.result.songs != null && !this.result.songs.isEmpty()) {
            return this.result.songs.get(0);
        }
        return null;
    }

    private static class Result {
        @SerializedName(value="songs")
        private List<Song> songs;

        private Result() {
        }
    }

    public static class Song {
        @SerializedName(value="id")
        private long id;
        @SerializedName(value="name")
        private String name;
        @SerializedName(value="duration")
        private long durationMs;

        public String getUrl() {
            return String.format("https://music.163.com/song/media/outer/url?id=%d.mp3", this.id);
        }

        public int getTimeSecond() {
            return (int)(this.durationMs / 1000L);
        }

        public String getName() {
            return this.name;
        }
    }
}

