/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.netmusic.inventory;

import com.github.tartaricacid.netmusic.init.InitItems;
import com.github.tartaricacid.netmusic.item.ItemMusicCD;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class ComputerMenu
extends AbstractContainerMenu {
    public static final MenuType<ComputerMenu> TYPE = IForgeMenuType.create((windowId, inv, data) -> new ComputerMenu(windowId, inv));
    private final ItemStackHandler input = new ItemStackHandler(){

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return stack.m_41720_() == InitItems.MUSIC_CD.get();
        }
    };
    private final ItemStackHandler output = new ItemStackHandler(){

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return false;
        }

        protected int getStackLimit(int slot, @NotNull ItemStack stack) {
            return 1;
        }
    };
    private ItemMusicCD.SongInfo songInfo;

    public ComputerMenu(int id, Inventory inventory) {
        super(TYPE, id);
        int i;
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.input, 0, 147, 14));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.output, 0, 147, 79));
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)inventory, i, 8 + i * 18, 192));
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18, 134 + i * 18));
            }
        }
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotItem = slot.m_7993_();
            itemStack = slotItem.m_41777_();
            if (index < 2 ? !this.m_38903_(slotItem, 2, this.f_38839_.size(), false) : !this.m_38903_(slotItem, 0, 2, true)) {
                return ItemStack.f_41583_;
            }
            if (slotItem.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemStack;
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.input.getStackInSlot(0));
        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.output.getStackInSlot(0));
    }

    public void setSongInfo(ItemMusicCD.SongInfo setSongInfo) {
        this.songInfo = setSongInfo;
        if (!this.input.getStackInSlot(0).m_41619_() && this.output.getStackInSlot(0).m_41619_()) {
            ItemStack itemStack = this.input.extractItem(0, 1, false);
            ItemMusicCD.SongInfo rawSongInfo = ItemMusicCD.getSongInfo(itemStack);
            if (rawSongInfo == null || !rawSongInfo.readOnly) {
                ItemMusicCD.setSongInfo(this.songInfo, itemStack);
            }
            this.output.setStackInSlot(0, itemStack);
        }
    }

    public ItemStackHandler getInput() {
        return this.input;
    }
}

