/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.netmusic.tileentity;

import com.github.tartaricacid.netmusic.block.BlockMusicPlayer;
import com.github.tartaricacid.netmusic.init.InitBlocks;
import com.github.tartaricacid.netmusic.inventory.MusicPlayerInv;
import com.github.tartaricacid.netmusic.item.ItemMusicCD;
import com.github.tartaricacid.netmusic.network.NetworkHandler;
import com.github.tartaricacid.netmusic.network.message.MusicToClientMessage;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class TileEntityMusicPlayer
extends BlockEntity {
    public static final BlockEntityType<TileEntityMusicPlayer> TYPE = BlockEntityType.Builder.m_155273_(TileEntityMusicPlayer::new, (Block[])new Block[]{(Block)InitBlocks.MUSIC_PLAYER.get()}).m_58966_(null);
    private static final String CD_ITEM_TAG = "ItemStackCD";
    private static final String IS_PLAY_TAG = "IsPlay";
    private static final String CURRENT_TIME_TAG = "CurrentTime";
    private static final String SIGNAL_TAG = "RedStoneSignal";
    private final ItemStackHandler playerInv = new MusicPlayerInv(this);
    private LazyOptional<IItemHandler> playerInvHandler;
    private boolean isPlay = false;
    private int currentTime;
    private boolean hasSignal = false;

    public TileEntityMusicPlayer(BlockPos blockPos, BlockState blockState) {
        super(TYPE, blockPos, blockState);
    }

    public void m_183515_(CompoundTag compound) {
        this.getPersistentData().m_128365_(CD_ITEM_TAG, (Tag)this.playerInv.serializeNBT());
        this.getPersistentData().m_128379_(IS_PLAY_TAG, this.isPlay);
        this.getPersistentData().m_128405_(CURRENT_TIME_TAG, this.currentTime);
        this.getPersistentData().m_128379_(SIGNAL_TAG, this.hasSignal);
        super.m_183515_(compound);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.playerInv.deserializeNBT(this.getPersistentData().m_128469_(CD_ITEM_TAG));
        this.isPlay = this.getPersistentData().m_128471_(IS_PLAY_TAG);
        this.currentTime = this.getPersistentData().m_128451_(CURRENT_TIME_TAG);
        this.hasSignal = this.getPersistentData().m_128471_(SIGNAL_TAG);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public ItemStackHandler getPlayerInv() {
        return this.playerInv;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (!this.f_58859_ && cap == ForgeCapabilities.ITEM_HANDLER) {
            if (this.playerInvHandler == null) {
                this.playerInvHandler = LazyOptional.of(this::createHandler);
            }
            return this.playerInvHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_155250_(BlockState blockState) {
        super.m_155250_(blockState);
        if (this.playerInvHandler != null) {
            LazyOptional<IItemHandler> oldHandler = this.playerInvHandler;
            this.playerInvHandler = null;
            oldHandler.invalidate();
        }
    }

    private IItemHandler createHandler() {
        BlockState state = this.m_58900_();
        if (state.m_60734_() instanceof BlockMusicPlayer) {
            return this.playerInv;
        }
        return null;
    }

    public boolean isPlay() {
        return this.isPlay;
    }

    public void setPlay(boolean play) {
        this.isPlay = play;
    }

    public void setPlayToClient(ItemMusicCD.SongInfo info) {
        this.setCurrentTime(info.songTime * 20 + 64);
        this.isPlay = true;
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            MusicToClientMessage msg = new MusicToClientMessage(this.f_58858_, info.songUrl, info.songTime, info.songName);
            NetworkHandler.sendToNearby(this.f_58857_, this.f_58858_, msg);
        }
    }

    public void markDirty() {
        this.m_6596_();
        if (this.f_58857_ != null) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
        }
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.playerInvHandler != null) {
            this.playerInvHandler.invalidate();
            this.playerInvHandler = null;
        }
    }

    public void setCurrentTime(int time) {
        this.currentTime = time;
    }

    public int getCurrentTime() {
        return this.currentTime;
    }

    public boolean hasSignal() {
        return this.hasSignal;
    }

    public void setSignal(boolean signal) {
        this.hasSignal = signal;
    }

    public void tickTime() {
        if (this.currentTime > 0) {
            --this.currentTime;
        }
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, TileEntityMusicPlayer te) {
        te.tickTime();
        if (0 < te.getCurrentTime() && te.getCurrentTime() < 16 && te.getCurrentTime() % 5 == 0) {
            if (((Boolean)blockState.m_61143_((Property)BlockMusicPlayer.CYCLE_DISABLE)).booleanValue()) {
                te.setPlay(false);
                te.markDirty();
            } else {
                ItemStack stackInSlot = te.getPlayerInv().getStackInSlot(0);
                if (stackInSlot.m_41619_()) {
                    return;
                }
                ItemMusicCD.SongInfo songInfo = ItemMusicCD.getSongInfo(stackInSlot);
                if (songInfo != null) {
                    te.setPlayToClient(songInfo);
                }
            }
        }
    }
}

