/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.filter.premade;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import org.apache.commons.lang3.ArrayUtils;
import team.creative.creativecore.common.util.CompoundSerializer;
import team.creative.creativecore.common.util.filter.Filter;

public class ItemFilters {
    public static Filter<Item> item(Item item) {
        return new ItemFilter(item);
    }

    public static Filter<Item> items(Item ... items) {
        return new ItemsFilter(items);
    }

    public static Filter<Item> instance(Class<? extends Item> clazz) {
        return new ItemClassFilter(clazz);
    }

    public static Filter<Item> and(Filter<Item> ... filters) {
        return Filter.and(filters);
    }

    public static Filter<Item> or(Filter<Item> ... filters) {
        return Filter.or(filters);
    }

    public static Filter<Item> not(Filter<Item> filter) {
        return Filter.not(filter);
    }

    static {
        Filter.SERIALIZER.register("item", ItemFilter.class);
        Filter.SERIALIZER.register("items", ItemsFilter.class);
        Filter.SERIALIZER.register("iclass", ItemClassFilter.class);
    }

    private static class ItemFilter
    implements Filter<Item>,
    CompoundSerializer {
        public final Item item;

        public ItemFilter(Item item) {
            this.item = item;
        }

        public ItemFilter(CompoundTag nbt) {
            this.item = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(nbt.m_128461_("i")));
        }

        @Override
        public boolean is(Item t) {
            return t == this.item;
        }

        @Override
        public CompoundTag write() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("i", BuiltInRegistries.f_257033_.m_7981_((Object)this.item).toString());
            return nbt;
        }
    }

    private static class ItemsFilter
    implements Filter<Item>,
    CompoundSerializer {
        public final Item[] items;

        public ItemsFilter(Item ... items) {
            this.items = items;
        }

        public ItemsFilter(CompoundTag nbt) {
            ListTag list = nbt.m_128437_("i", 8);
            this.items = new Item[list.size()];
            for (int i = 0; i < this.items.length; ++i) {
                this.items[i] = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(list.m_128778_(i)));
            }
        }

        @Override
        public boolean is(Item t) {
            return ArrayUtils.contains((Object[])this.items, (Object)t);
        }

        @Override
        public CompoundTag write() {
            CompoundTag nbt = new CompoundTag();
            ListTag list = new ListTag();
            for (int i = 0; i < this.items.length; ++i) {
                list.add((Object)StringTag.m_129297_((String)BuiltInRegistries.f_257033_.m_7981_((Object)this.items[i]).toString()));
            }
            nbt.m_128365_("i", (Tag)list);
            return nbt;
        }
    }

    private static class ItemClassFilter
    implements Filter<Item>,
    CompoundSerializer {
        public final Class<? extends Item> clazz;

        public ItemClassFilter(Class<? extends Item> clazz) {
            this.clazz = clazz;
        }

        public ItemClassFilter(CompoundTag nbt) {
            Class<?> temp = null;
            try {
                temp = Class.forName(nbt.m_128461_("c"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.clazz = temp;
        }

        @Override
        public boolean is(Item t) {
            return this.clazz != null && this.clazz.isInstance(t);
        }

        @Override
        public CompoundTag write() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("c", this.clazz.getName());
            return nbt;
        }
    }
}

