/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.api.behaviour.spouting;

import com.simibubi.create.api.behaviour.spouting.BlockSpoutingBehaviour;
import com.simibubi.create.content.fluids.spout.SpoutBlockEntity;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public record StateChangingBehavior(int amount, Predicate<Fluid> fluidTest, Predicate<BlockState> canFill, UnaryOperator<BlockState> fillFunction) implements BlockSpoutingBehaviour
{
    @Override
    public int fillBlock(Level level, BlockPos pos, SpoutBlockEntity spout, FluidStack availableFluid, boolean simulate) {
        if (availableFluid.getAmount() < this.amount || !this.fluidTest.test(availableFluid.getFluid())) {
            return 0;
        }
        BlockState state = level.m_8055_(pos);
        if (!this.canFill.test(state)) {
            return 0;
        }
        if (!simulate) {
            BlockState newState = (BlockState)this.fillFunction.apply(state);
            level.m_46597_(pos, newState);
        }
        return this.amount;
    }

    public static BlockSpoutingBehaviour setTo(int amount, Predicate<Fluid> fluidTest, Block block) {
        return StateChangingBehavior.setTo(amount, fluidTest, block.m_49966_());
    }

    public static BlockSpoutingBehaviour setTo(int amount, Predicate<Fluid> fluidTest, BlockState newState) {
        return new StateChangingBehavior(amount, fluidTest, state -> true, state -> newState);
    }

    public static BlockSpoutingBehaviour incrementingState(int amount, Predicate<Fluid> fluidTest, IntegerProperty property) {
        int max = (Integer)property.m_6908_().stream().max(Integer::compareTo).orElseThrow();
        Predicate<BlockState> canFill = state -> (Integer)state.m_61143_((Property)property) < max;
        UnaryOperator fillFunction = state -> (BlockState)state.m_61124_((Property)property, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)property) + 1));
        return new StateChangingBehavior(amount, fluidTest, canFill, fillFunction);
    }
}

