/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.api.data.recipe;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.AllRecipeTypes;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;

public class MechanicalCraftingRecipeBuilder {
    private final Item result;
    private final int count;
    private final List<String> pattern = Lists.newArrayList();
    private final Map<Character, Ingredient> key = Maps.newLinkedHashMap();
    private boolean acceptMirrored;
    private List<ICondition> recipeConditions;

    public MechanicalCraftingRecipeBuilder(ItemLike result, int resultCount) {
        this.result = result.m_5456_();
        this.count = resultCount;
        this.acceptMirrored = true;
        this.recipeConditions = new ArrayList<ICondition>();
    }

    public static MechanicalCraftingRecipeBuilder shapedRecipe(ItemLike result) {
        return MechanicalCraftingRecipeBuilder.shapedRecipe(result, 1);
    }

    public static MechanicalCraftingRecipeBuilder shapedRecipe(ItemLike result, int resultCount) {
        return new MechanicalCraftingRecipeBuilder(result, resultCount);
    }

    public MechanicalCraftingRecipeBuilder key(Character c, TagKey<Item> tag) {
        return this.key(c, Ingredient.m_204132_(tag));
    }

    public MechanicalCraftingRecipeBuilder key(Character c, ItemLike item) {
        return this.key(c, Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public MechanicalCraftingRecipeBuilder key(Character c, Ingredient ingredient) {
        if (this.key.containsKey(c)) {
            throw new IllegalArgumentException("Symbol '" + c + "' is already defined!");
        }
        if (c.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.key.put(c, ingredient);
        return this;
    }

    public MechanicalCraftingRecipeBuilder patternLine(String line) {
        if (!this.pattern.isEmpty() && line.length() != this.pattern.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.pattern.add(line);
        return this;
    }

    public MechanicalCraftingRecipeBuilder disallowMirrored() {
        this.acceptMirrored = false;
        return this;
    }

    public void build(Consumer<FinishedRecipe> out) {
        this.build(out, CatnipServices.REGISTRIES.getKeyOrThrow(this.result));
    }

    public void build(Consumer<FinishedRecipe> out, String id) {
        ResourceLocation resourcelocation = CatnipServices.REGISTRIES.getKeyOrThrow(this.result);
        if (new ResourceLocation(id).equals((Object)resourcelocation)) {
            throw new IllegalStateException("Shaped Recipe " + id + " should remove its 'id' argument");
        }
        this.build(out, new ResourceLocation(id));
    }

    public void build(Consumer<FinishedRecipe> out, ResourceLocation id) {
        this.validate(id);
        out.accept(new Result(id, this.result, this.count, this.pattern, this.key, this.acceptMirrored, this.recipeConditions));
    }

    private void validate(ResourceLocation recipeId) {
        if (this.pattern.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for shaped recipe " + String.valueOf(recipeId) + "!");
        }
        HashSet set = Sets.newHashSet(this.key.keySet());
        set.remove(Character.valueOf(' '));
        for (String s : this.pattern) {
            for (int i = 0; i < s.length(); ++i) {
                char c0 = s.charAt(i);
                if (!this.key.containsKey(Character.valueOf(c0)) && c0 != ' ') {
                    throw new IllegalStateException("Pattern in recipe " + String.valueOf(recipeId) + " uses undefined symbol '" + c0 + "'");
                }
                set.remove(Character.valueOf(c0));
            }
        }
        if (!set.isEmpty()) {
            throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + String.valueOf(recipeId));
        }
    }

    public MechanicalCraftingRecipeBuilder whenModLoaded(String modid) {
        return this.withCondition((ICondition)new ModLoadedCondition(modid));
    }

    public MechanicalCraftingRecipeBuilder whenModMissing(String modid) {
        return this.withCondition((ICondition)new NotCondition((ICondition)new ModLoadedCondition(modid)));
    }

    public MechanicalCraftingRecipeBuilder withCondition(ICondition condition) {
        this.recipeConditions.add(condition);
        return this;
    }

    public class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Item result;
        private final int count;
        private final List<String> pattern;
        private final Map<Character, Ingredient> key;
        private final boolean acceptMirrored;
        private List<ICondition> recipeConditions;

        public Result(ResourceLocation recipeId, Item result, int count, List<String> pattern, Map<Character, Ingredient> p_i48271_7_, boolean asymmetrical, List<ICondition> recipeConditions) {
            this.id = recipeId;
            this.result = result;
            this.count = count;
            this.pattern = pattern;
            this.key = p_i48271_7_;
            this.acceptMirrored = asymmetrical;
            this.recipeConditions = recipeConditions;
        }

        public void m_7917_(JsonObject o) {
            JsonArray jsonarray = new JsonArray();
            for (String string : this.pattern) {
                jsonarray.add(string);
            }
            o.add("pattern", (JsonElement)jsonarray);
            JsonObject jsonobject = new JsonObject();
            for (Map.Entry<Character, Ingredient> entry : this.key.entrySet()) {
                jsonobject.add(String.valueOf(entry.getKey()), entry.getValue().m_43942_());
            }
            o.add("key", (JsonElement)jsonobject);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", CatnipServices.REGISTRIES.getKeyOrThrow(this.result).toString());
            if (this.count > 1) {
                jsonObject.addProperty("count", (Number)this.count);
            }
            o.add("result", (JsonElement)jsonObject);
            o.addProperty("acceptMirrored", Boolean.valueOf(this.acceptMirrored));
            if (this.recipeConditions.isEmpty()) {
                return;
            }
            JsonArray jsonArray = new JsonArray();
            this.recipeConditions.forEach(c -> conds.add((JsonElement)CraftingHelper.serialize((ICondition)c)));
            o.add("conditions", (JsonElement)jsonArray);
        }

        public RecipeSerializer<?> m_6637_() {
            return AllRecipeTypes.MECHANICAL_CRAFTING.getSerializer();
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

