/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.actors.contraptionControls;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.actors.contraptionControls.ContraptionControlsMovement;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ContraptionDisableActorPacket
extends SimplePacketBase {
    private int entityID;
    private ItemStack filter;
    private boolean enable;

    public ContraptionDisableActorPacket(int entityID, ItemStack filter, boolean enable) {
        this.entityID = entityID;
        this.filter = filter;
        this.enable = enable;
    }

    public ContraptionDisableActorPacket(FriendlyByteBuf buffer) {
        this.entityID = buffer.readInt();
        this.enable = buffer.readBoolean();
        this.filter = buffer.m_130267_();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.entityID);
        buffer.writeBoolean(this.enable);
        buffer.m_130055_(this.filter);
    }

    @Override
    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            Entity entityByID = Minecraft.m_91087_().f_91073_.m_6815_(this.entityID);
            if (!(entityByID instanceof AbstractContraptionEntity)) {
                return;
            }
            AbstractContraptionEntity ace = (AbstractContraptionEntity)entityByID;
            Contraption contraption = ace.getContraption();
            List<ItemStack> disabledActors = contraption.getDisabledActors();
            if (this.filter.m_41619_()) {
                disabledActors.clear();
            }
            if (!this.enable) {
                disabledActors.add(this.filter);
                contraption.setActorsActive(this.filter, false);
                return;
            }
            Iterator<ItemStack> iterator = disabledActors.iterator();
            while (iterator.hasNext()) {
                ItemStack next = iterator.next();
                if (!ContraptionControlsMovement.isSameFilter(next, this.filter) && !next.m_41619_()) continue;
                iterator.remove();
            }
            contraption.setActorsActive(this.filter, true);
        });
        return true;
    }
}

