/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ActorVisual;
import com.simibubi.create.content.contraptions.render.ContraptionRenderInfo;
import com.simibubi.create.foundation.utility.worldWrappers.WrappedBlockAndTintGetter;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.instance.Instancer;
import dev.engine_room.flywheel.api.material.CardinalLightingMode;
import dev.engine_room.flywheel.api.material.Material;
import dev.engine_room.flywheel.api.model.Model;
import dev.engine_room.flywheel.api.task.Plan;
import dev.engine_room.flywheel.api.visual.BlockEntityVisual;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visual.LightUpdatedVisual;
import dev.engine_room.flywheel.api.visual.SectionTrackedVisual;
import dev.engine_room.flywheel.api.visual.ShaderLightVisual;
import dev.engine_room.flywheel.api.visual.TickableVisual;
import dev.engine_room.flywheel.api.visual.Visual;
import dev.engine_room.flywheel.api.visualization.BlockEntityVisualizer;
import dev.engine_room.flywheel.api.visualization.VisualEmbedding;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.api.visualization.VisualizerRegistry;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.material.SimpleMaterial;
import dev.engine_room.flywheel.lib.model.ModelUtil;
import dev.engine_room.flywheel.lib.model.baked.ForgeBlockModelBuilder;
import dev.engine_room.flywheel.lib.task.ForEachPlan;
import dev.engine_room.flywheel.lib.task.NestedPlan;
import dev.engine_room.flywheel.lib.task.PlanMap;
import dev.engine_room.flywheel.lib.task.RunnablePlan;
import dev.engine_room.flywheel.lib.visual.AbstractEntityVisual;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.model.data.ModelData;
import org.apache.commons.lang3.tuple.MutablePair;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;

public class ContraptionVisual<E extends AbstractContraptionEntity>
extends AbstractEntityVisual<E>
implements DynamicVisual,
TickableVisual,
LightUpdatedVisual,
ShaderLightVisual {
    protected static final int LIGHT_PADDING = 1;
    protected final VisualEmbedding embedding;
    protected final List<BlockEntityVisual<?>> children = new ArrayList();
    protected final List<ActorVisual> actors = new ArrayList<ActorVisual>();
    protected final PlanMap<DynamicVisual, DynamicVisual.Context> dynamicVisuals = new PlanMap();
    protected final PlanMap<TickableVisual, TickableVisual.Context> tickableVisuals = new PlanMap();
    protected VirtualRenderWorld virtualRenderWorld;
    protected Model model;
    protected TransformedInstance structure;
    protected SectionTrackedVisual.SectionCollector sectionCollector;
    protected long minSection;
    protected long maxSection;
    protected long minBlock;
    protected long maxBlock;
    private final PoseStack contraptionMatrix = new PoseStack();

    public ContraptionVisual(VisualizationContext ctx, E entity, float partialTick) {
        super(ctx, entity, partialTick);
        this.embedding = ctx.createEmbedding(Vec3i.f_123288_);
        this.setEmbeddingMatrices(partialTick);
        Contraption contraption = ((AbstractContraptionEntity)((Object)entity)).getContraption();
        if (contraption == null) {
            return;
        }
        this.setupModel(contraption);
        this.setupChildren(partialTick, contraption);
        this.setupActors(partialTick, contraption);
    }

    private void setupModel(Contraption contraption) {
        this.virtualRenderWorld = ContraptionRenderInfo.setupRenderWorld(this.level, contraption);
        final Contraption.RenderedBlocks blocks = contraption.getRenderedBlocks();
        WrappedBlockAndTintGetter modelWorld = new WrappedBlockAndTintGetter((BlockAndTintGetter)this.virtualRenderWorld){

            @Override
            public BlockState m_8055_(BlockPos pos) {
                return blocks.lookup().apply(pos);
            }
        };
        this.model = new ForgeBlockModelBuilder((BlockAndTintGetter)modelWorld, blocks.positions()).modelDataLookup(pos -> contraption.modelData.getOrDefault(pos, ModelData.EMPTY)).materialFunc((renderType, aBoolean) -> SimpleMaterial.builderOf((Material)ModelUtil.getMaterial((RenderType)renderType, (boolean)aBoolean)).cardinalLightingMode(CardinalLightingMode.CHUNK)).build();
        Instancer instancer = this.embedding.instancerProvider().instancer(InstanceTypes.TRANSFORMED, this.model);
        if (this.structure == null) {
            this.structure = (TransformedInstance)instancer.createInstance();
        } else {
            instancer.stealInstance((Instance)this.structure);
        }
        this.structure.setChanged();
    }

    private void setupChildren(float partialTick, Contraption contraption) {
        this.children.forEach(Visual::delete);
        this.children.clear();
        for (BlockEntity be : contraption.getRenderedBEs()) {
            this.setupVisualizer(be, partialTick);
        }
    }

    private void setupActors(float partialTick, Contraption contraption) {
        this.actors.forEach(ActorVisual::delete);
        this.actors.clear();
        for (MutablePair<StructureTemplate.StructureBlockInfo, MovementContext> actor : contraption.getActors()) {
            this.setupActor(actor, partialTick);
        }
    }

    protected <T extends BlockEntity> void setupVisualizer(T be, float partialTicks) {
        BlockEntityVisualizer visualizer = VisualizerRegistry.getVisualizer((BlockEntityType)be.m_58903_());
        if (visualizer == null) {
            return;
        }
        Level level = be.m_58904_();
        be.m_142339_((Level)this.virtualRenderWorld);
        BlockEntityVisual visual = visualizer.createVisual((VisualizationContext)this.embedding, be, partialTicks);
        this.children.add(visual);
        if (visual instanceof DynamicVisual) {
            DynamicVisual dynamic = (DynamicVisual)visual;
            this.dynamicVisuals.add((Object)dynamic, dynamic.planFrame());
        }
        if (visual instanceof TickableVisual) {
            TickableVisual tickable = (TickableVisual)visual;
            this.tickableVisuals.add((Object)tickable, tickable.planTick());
        }
        be.m_142339_(level);
    }

    private void setupActor(MutablePair<StructureTemplate.StructureBlockInfo, MovementContext> actor, float partialTick) {
        StructureTemplate.StructureBlockInfo blockInfo;
        MovementBehaviour movementBehaviour;
        MovementContext context = (MovementContext)actor.getRight();
        if (context == null) {
            return;
        }
        if (context.world == null) {
            context.world = this.level;
        }
        if ((movementBehaviour = MovementBehaviour.REGISTRY.get((StateHolder<Block, ?>)(blockInfo = (StructureTemplate.StructureBlockInfo)actor.getLeft()).f_74676_())) == null) {
            return;
        }
        ActorVisual visual = movementBehaviour.createVisual((VisualizationContext)this.embedding, this.virtualRenderWorld, context);
        if (visual == null) {
            return;
        }
        this.actors.add(visual);
    }

    public Plan<TickableVisual.Context> planTick() {
        return NestedPlan.of((Plan[])new Plan[]{ForEachPlan.of(() -> this.actors, ActorVisual::tick), this.tickableVisuals});
    }

    public Plan<DynamicVisual.Context> planFrame() {
        return NestedPlan.of((Plan[])new Plan[]{RunnablePlan.of(this::beginFrame), ForEachPlan.of(() -> this.actors, ActorVisual::beginFrame), this.dynamicVisuals});
    }

    protected void beginFrame(DynamicVisual.Context context) {
        float partialTick = context.partialTick();
        this.setEmbeddingMatrices(partialTick);
        if (this.hasMovedSections()) {
            this.sectionCollector.sections(this.collectLightSections());
        }
        if (this.hasMovedBlocks()) {
            this.updateLight(partialTick);
        }
        Contraption contraption = ((AbstractContraptionEntity)this.entity).getContraption();
        if (contraption.deferInvalidate) {
            this.setupModel(contraption);
            this.setupChildren(partialTick, contraption);
            this.setupActors(partialTick, contraption);
            contraption.deferInvalidate = false;
        }
    }

    private void setEmbeddingMatrices(float partialTick) {
        double z;
        double y;
        double x;
        Vec3i origin = this.renderOrigin();
        if (((AbstractContraptionEntity)this.entity).isPrevPosInvalid()) {
            x = ((AbstractContraptionEntity)this.entity).m_20185_() - (double)origin.m_123341_();
            y = ((AbstractContraptionEntity)this.entity).m_20186_() - (double)origin.m_123342_();
            z = ((AbstractContraptionEntity)this.entity).m_20189_() - (double)origin.m_123343_();
        } else {
            x = Mth.m_14139_((double)partialTick, (double)((AbstractContraptionEntity)this.entity).f_19854_, (double)((AbstractContraptionEntity)this.entity).m_20185_()) - (double)origin.m_123341_();
            y = Mth.m_14139_((double)partialTick, (double)((AbstractContraptionEntity)this.entity).f_19855_, (double)((AbstractContraptionEntity)this.entity).m_20186_()) - (double)origin.m_123342_();
            z = Mth.m_14139_((double)partialTick, (double)((AbstractContraptionEntity)this.entity).f_19856_, (double)((AbstractContraptionEntity)this.entity).m_20189_()) - (double)origin.m_123343_();
        }
        this.contraptionMatrix.m_166856_();
        this.contraptionMatrix.m_85837_(x, y, z);
        ((AbstractContraptionEntity)this.entity).applyLocalTransforms(this.contraptionMatrix, partialTick);
        this.embedding.transforms((Matrix4fc)this.contraptionMatrix.m_85850_().m_252922_(), (Matrix3fc)this.contraptionMatrix.m_85850_().m_252943_());
    }

    public void updateLight(float partialTick) {
    }

    public LongSet collectLightSections() {
        AABB boundingBox = ((AbstractContraptionEntity)this.entity).m_20191_();
        int minSectionX = ContraptionVisual.minLightSection(boundingBox.f_82288_);
        int minSectionY = ContraptionVisual.minLightSection(boundingBox.f_82289_);
        int minSectionZ = ContraptionVisual.minLightSection(boundingBox.f_82290_);
        int maxSectionX = ContraptionVisual.maxLightSection(boundingBox.f_82291_);
        int maxSectionY = ContraptionVisual.maxLightSection(boundingBox.f_82292_);
        int maxSectionZ = ContraptionVisual.maxLightSection(boundingBox.f_82293_);
        this.minSection = SectionPos.m_123209_((int)minSectionX, (int)minSectionY, (int)minSectionZ);
        this.maxSection = SectionPos.m_123209_((int)maxSectionX, (int)maxSectionY, (int)maxSectionZ);
        LongArraySet longSet = new LongArraySet();
        for (int x = 0; x <= maxSectionX - minSectionX; ++x) {
            for (int y = 0; y <= maxSectionY - minSectionY; ++y) {
                for (int z = 0; z <= maxSectionZ - minSectionZ; ++z) {
                    longSet.add(SectionPos.m_123186_((long)this.minSection, (int)x, (int)y, (int)z));
                }
            }
        }
        return longSet;
    }

    protected boolean hasMovedBlocks() {
        AABB boundingBox = ((AbstractContraptionEntity)this.entity).m_20191_();
        int minX = ContraptionVisual.minLight(boundingBox.f_82288_);
        int minY = ContraptionVisual.minLight(boundingBox.f_82289_);
        int minZ = ContraptionVisual.minLight(boundingBox.f_82290_);
        int maxX = ContraptionVisual.maxLight(boundingBox.f_82291_);
        int maxY = ContraptionVisual.maxLight(boundingBox.f_82292_);
        int maxZ = ContraptionVisual.maxLight(boundingBox.f_82293_);
        return this.minBlock != BlockPos.m_121882_((int)minX, (int)minY, (int)minZ) || this.maxBlock != BlockPos.m_121882_((int)maxX, (int)maxY, (int)maxZ);
    }

    protected boolean hasMovedSections() {
        AABB boundingBox = ((AbstractContraptionEntity)this.entity).m_20191_();
        int minSectionX = ContraptionVisual.minLightSection(boundingBox.f_82288_);
        int minSectionY = ContraptionVisual.minLightSection(boundingBox.f_82289_);
        int minSectionZ = ContraptionVisual.minLightSection(boundingBox.f_82290_);
        int maxSectionX = ContraptionVisual.maxLightSection(boundingBox.f_82291_);
        int maxSectionY = ContraptionVisual.maxLightSection(boundingBox.f_82292_);
        int maxSectionZ = ContraptionVisual.maxLightSection(boundingBox.f_82293_);
        return this.minSection != SectionPos.m_123209_((int)minSectionX, (int)minSectionY, (int)minSectionZ) || this.maxSection != SectionPos.m_123209_((int)maxSectionX, (int)maxSectionY, (int)maxSectionZ);
    }

    public void setSectionCollector(SectionTrackedVisual.SectionCollector collector) {
        this.sectionCollector = collector;
    }

    protected void _delete() {
        this.children.forEach(Visual::delete);
        this.actors.forEach(ActorVisual::delete);
        if (this.structure != null) {
            this.structure.delete();
        }
    }

    public static int minLight(double aabbPos) {
        return Mth.m_14107_((double)aabbPos) - 1;
    }

    public static int maxLight(double aabbPos) {
        return Mth.m_14165_((double)aabbPos) + 1;
    }

    public static int minLightSection(double aabbPos) {
        return SectionPos.m_123171_((int)ContraptionVisual.minLight(aabbPos));
    }

    public static int maxLightSection(double aabbPos) {
        return SectionPos.m_123171_((int)ContraptionVisual.maxLight(aabbPos));
    }
}

