/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.clipboard;

import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class ClipboardEntry {
    public boolean checked;
    public MutableComponent text;
    public ItemStack icon;
    public int itemAmount;

    public ClipboardEntry(boolean checked, MutableComponent text) {
        this.checked = checked;
        this.text = text;
        this.icon = ItemStack.f_41583_;
    }

    public ClipboardEntry displayItem(ItemStack icon, int amount) {
        this.icon = icon;
        this.itemAmount = amount;
        return this;
    }

    public static List<List<ClipboardEntry>> readAll(ItemStack clipboardItem) {
        CompoundTag tag = clipboardItem.m_41783_();
        if (tag == null) {
            return new ArrayList<List<ClipboardEntry>>();
        }
        return NBTHelper.readCompoundList((ListTag)tag.m_128437_("Pages", 10), pageTag -> NBTHelper.readCompoundList((ListTag)pageTag.m_128437_("Entries", 10), ClipboardEntry::readNBT));
    }

    public static List<ClipboardEntry> getLastViewedEntries(ItemStack heldItem) {
        List<List<ClipboardEntry>> pages = ClipboardEntry.readAll(heldItem);
        if (pages.isEmpty()) {
            return new ArrayList<ClipboardEntry>();
        }
        int page = heldItem.m_41783_() == null ? 0 : Math.min(heldItem.m_41783_().m_128451_("PreviouslyOpenedPage"), pages.size() - 1);
        List<ClipboardEntry> entries = pages.get(page);
        return entries;
    }

    public static void saveAll(List<List<ClipboardEntry>> entries, ItemStack clipboardItem) {
        CompoundTag tag = clipboardItem.m_41784_();
        tag.m_128365_("Pages", (Tag)NBTHelper.writeCompoundList(entries, list -> {
            CompoundTag pageTag = new CompoundTag();
            pageTag.m_128365_("Entries", (Tag)NBTHelper.writeCompoundList((Iterable)list, ClipboardEntry::writeNBT));
            return pageTag;
        }));
    }

    public CompoundTag writeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("Checked", this.checked);
        nbt.m_128359_("Text", Component.Serializer.m_130703_((Component)this.text));
        if (this.icon.m_41619_()) {
            return nbt;
        }
        nbt.m_128365_("Icon", (Tag)this.icon.serializeNBT());
        nbt.m_128405_("ItemAmount", this.itemAmount);
        return nbt;
    }

    public static ClipboardEntry readNBT(CompoundTag tag) {
        ClipboardEntry clipboardEntry = new ClipboardEntry(tag.m_128471_("Checked"), Component.Serializer.m_130701_((String)tag.m_128461_("Text")));
        if (tag.m_128441_("Icon")) {
            clipboardEntry.displayItem(ItemStack.m_41712_((CompoundTag)tag.m_128469_("Icon")), tag.m_128451_("ItemAmount"));
        }
        return clipboardEntry;
    }
}

