/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.potatoCannon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.Create;
import com.simibubi.create.api.equipment.potatoCannon.PotatoProjectileBlockHitAction;
import com.simibubi.create.api.registry.CreateBuiltInRegistries;
import com.simibubi.create.foundation.mixin.accessor.FallingBlockEntityAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.registries.ForgeRegistries;

public class AllPotatoProjectileBlockHitActions {
    public static void init() {
    }

    private static void register(String name, Codec<? extends PotatoProjectileBlockHitAction> codec) {
        Registry.m_122965_(CreateBuiltInRegistries.POTATO_PROJECTILE_BLOCK_HIT_ACTION, (ResourceLocation)Create.asResource(name), codec);
    }

    static {
        AllPotatoProjectileBlockHitActions.register("plant_crop", PlantCrop.CODEC);
        AllPotatoProjectileBlockHitActions.register("place_block_on_ground", PlaceBlockOnGround.CODEC);
    }

    public record PlantCrop(Holder<Block> cropBlock) implements PotatoProjectileBlockHitAction
    {
        public static final Codec<PlantCrop> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f_256975_.m_206110_().fieldOf("block").forGetter(PlantCrop::cropBlock)).apply((Applicative)instance, PlantCrop::new));

        public PlantCrop(Block cropBlock) {
            this((Holder<Block>)ForgeRegistries.BLOCKS.getDelegateOrThrow((Object)cropBlock));
        }

        @Override
        public boolean execute(LevelAccessor level, ItemStack projectile, BlockHitResult ray) {
            Level l;
            if (level.m_5776_()) {
                return true;
            }
            BlockPos hitPos = ray.m_82425_();
            if (level instanceof Level && !(l = (Level)level).m_46749_(hitPos)) {
                return true;
            }
            Direction face = ray.m_82434_();
            if (face != Direction.UP) {
                return false;
            }
            BlockPos placePos = hitPos.m_121945_(face);
            if (!level.m_8055_(placePos).m_247087_()) {
                return false;
            }
            if (!(this.cropBlock.m_203334_() instanceof IPlantable)) {
                return false;
            }
            BlockState blockState = level.m_8055_(hitPos);
            if (!blockState.canSustainPlant((BlockGetter)level, hitPos, face, (IPlantable)this.cropBlock.m_203334_())) {
                return false;
            }
            level.m_7731_(placePos, ((Block)this.cropBlock.m_203334_()).m_49966_(), 3);
            return true;
        }

        @Override
        public Codec<? extends PotatoProjectileBlockHitAction> codec() {
            return CODEC;
        }
    }

    public record PlaceBlockOnGround(Holder<Block> block) implements PotatoProjectileBlockHitAction
    {
        public static final Codec<PlaceBlockOnGround> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f_256975_.m_206110_().fieldOf("block").forGetter(PlaceBlockOnGround::block)).apply((Applicative)instance, PlaceBlockOnGround::new));

        public PlaceBlockOnGround(Block block) {
            this((Holder<Block>)ForgeRegistries.BLOCKS.getDelegateOrThrow((Object)block));
        }

        @Override
        public boolean execute(LevelAccessor levelAccessor, ItemStack projectile, BlockHitResult ray) {
            Level l;
            if (levelAccessor.m_5776_()) {
                return true;
            }
            BlockPos hitPos = ray.m_82425_();
            if (levelAccessor instanceof Level && !(l = (Level)levelAccessor).m_46749_(hitPos)) {
                return true;
            }
            Direction face = ray.m_82434_();
            BlockPos placePos = hitPos.m_121945_(face);
            if (!levelAccessor.m_8055_(placePos).m_247087_()) {
                return false;
            }
            if (face == Direction.UP) {
                levelAccessor.m_7731_(placePos, ((Block)this.block.m_203334_()).m_49966_(), 3);
            } else if (levelAccessor instanceof Level) {
                Level level = (Level)levelAccessor;
                double y = ray.m_82450_().f_82480_ - 0.5;
                if (!level.m_46859_(placePos.m_7494_())) {
                    y = Math.min(y, (double)placePos.m_123342_());
                }
                if (!level.m_46859_(placePos.m_7495_())) {
                    y = Math.max(y, (double)placePos.m_123342_());
                }
                FallingBlockEntity falling = FallingBlockEntityAccessor.create$callInit(level, (double)placePos.m_123341_() + 0.5, y, (double)placePos.m_123343_() + 0.5, ((Block)this.block.m_203334_()).m_49966_());
                falling.f_31942_ = 1;
                level.m_7967_((Entity)falling);
            }
            return true;
        }

        @Override
        public Codec<? extends PotatoProjectileBlockHitAction> codec() {
            return CODEC;
        }
    }
}

