/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter.attribute.attributes;

import com.simibubi.create.content.logistics.item.filter.attribute.AllItemAttributeTypes;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.FireworkStarItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ColorAttribute
implements ItemAttribute {
    private DyeColor color;

    public ColorAttribute(DyeColor color) {
        this.color = color;
    }

    private static Collection<DyeColor> findMatchingDyeColors(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        DyeColor color = DyeColor.getColor((ItemStack)stack);
        if (color != null) {
            return Collections.singletonList(color);
        }
        HashSet<DyeColor> colors = new HashSet<DyeColor>();
        if (stack.m_41720_() instanceof FireworkRocketItem && nbt != null) {
            ListTag listnbt = nbt.m_128469_("Fireworks").m_128437_("Explosions", 10);
            for (int i = 0; i < listnbt.size(); ++i) {
                colors.addAll(ColorAttribute.getFireworkStarColors(listnbt.m_128728_(i)));
            }
        }
        if (stack.m_41720_() instanceof FireworkStarItem && nbt != null) {
            colors.addAll(ColorAttribute.getFireworkStarColors(nbt.m_128469_("Explosion")));
        }
        Arrays.stream(DyeColor.values()).filter(c -> CatnipServices.REGISTRIES.getKeyOrThrow(stack.m_41720_()).m_135815_().startsWith(c.m_41065_() + "_")).forEach(colors::add);
        return colors;
    }

    private static Collection<DyeColor> getFireworkStarColors(CompoundTag compound) {
        HashSet<DyeColor> colors = new HashSet<DyeColor>();
        Arrays.stream(compound.m_128465_("Colors")).mapToObj(DyeColor::m_41061_).forEach(colors::add);
        Arrays.stream(compound.m_128465_("FadeColors")).mapToObj(DyeColor::m_41061_).forEach(colors::add);
        return colors;
    }

    @Override
    public boolean appliesTo(ItemStack itemStack, Level level) {
        return ColorAttribute.findMatchingDyeColors(itemStack).stream().anyMatch(arg_0 -> this.color.equals(arg_0));
    }

    @Override
    public String getTranslationKey() {
        return "color";
    }

    @Override
    public Object[] getTranslationParameters() {
        return new Object[]{I18n.m_118938_((String)("color.minecraft." + this.color.m_41065_()), (Object[])new Object[0])};
    }

    @Override
    public ItemAttributeType getType() {
        return AllItemAttributeTypes.HAS_COLOR;
    }

    @Override
    public void save(CompoundTag nbt) {
        nbt.m_128405_("color", this.color.m_41060_());
    }

    @Override
    public void load(CompoundTag nbt) {
        if (nbt.m_128441_("color")) {
            this.color = DyeColor.m_41053_((int)nbt.m_128451_("color"));
        }
    }

    public static class Type
    implements ItemAttributeType {
        @Override
        @NotNull
        public ItemAttribute createAttribute() {
            return new ColorAttribute(DyeColor.PURPLE);
        }

        @Override
        public List<ItemAttribute> getAllAttributes(ItemStack stack, Level level) {
            ArrayList<ItemAttribute> list = new ArrayList<ItemAttribute>();
            for (DyeColor color : ColorAttribute.findMatchingDyeColors(stack)) {
                list.add(new ColorAttribute(color));
            }
            return list;
        }
    }
}

