/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.track;

import com.simibubi.create.Create;
import com.simibubi.create.api.contraption.train.PortalTrackProvider;
import com.simibubi.create.compat.Mods;
import com.simibubi.create.compat.betterend.BetterEndPortalCompat;
import com.simibubi.create.content.contraptions.glue.SuperGlueEntity;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.createmod.catnip.math.BlockFace;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.registries.ForgeRegistries;

public class AllPortalTracks {
    public static void tryRegisterIntegration(ResourceLocation id, PortalTrackProvider provider) {
        if (ForgeRegistries.BLOCKS.containsKey(id)) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(id);
            PortalTrackProvider.REGISTRY.register(block, provider);
        } else {
            Create.LOGGER.warn("Portal for integration wasn't found: {}. Compat outdated?", (Object)id);
        }
    }

    public static void registerDefaults() {
        PortalTrackProvider.REGISTRY.register(Blocks.f_50142_, AllPortalTracks::nether);
        if (Mods.AETHER.isLoaded()) {
            AllPortalTracks.tryRegisterIntegration(Mods.AETHER.rl("aether_portal"), AllPortalTracks::aether);
        }
        if (Mods.BETTEREND.isLoaded()) {
            AllPortalTracks.tryRegisterIntegration(Mods.BETTEREND.rl("end_portal_block"), AllPortalTracks::betterend);
        }
    }

    private static PortalTrackProvider.Exit nether(ServerLevel level, BlockFace face) {
        MinecraftServer minecraftServer = level.m_7654_();
        if (!minecraftServer.m_7079_()) {
            return null;
        }
        return PortalTrackProvider.fromTeleporter(level, face, (ResourceKey<Level>)Level.f_46428_, (ResourceKey<Level>)Level.f_46429_, ServerLevel::m_8871_);
    }

    private static PortalTrackProvider.Exit aether(ServerLevel level, BlockFace face) {
        ResourceKey aetherLevelKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)Mods.AETHER.rl("the_aether"));
        return PortalTrackProvider.fromTeleporter(level, face, (ResourceKey<Level>)Level.f_46428_, (ResourceKey<Level>)aetherLevelKey, serverLevel -> {
            try {
                return (ITeleporter)Class.forName("com.aetherteam.aether.block.portal.AetherPortalForcer").getDeclaredConstructor(ServerLevel.class, Boolean.TYPE).newInstance(serverLevel, true);
            }
            catch (Exception e) {
                Create.LOGGER.error("Failed to create Aether teleporter: ", (Throwable)e);
                return serverLevel.m_8871_();
            }
        });
    }

    private static PortalTrackProvider.Exit betterend(ServerLevel level, BlockFace face) {
        return AllPortalTracks.fromProbe(level, face, (ResourceKey<Level>)Level.f_46428_, (ResourceKey<Level>)Level.f_46430_, BetterEndPortalCompat::getBetterEndPortalInfo);
    }

    public static PortalTrackProvider.Exit fromTeleporter(ServerLevel level, BlockFace inboundTrack, ResourceKey<Level> firstDimension, ResourceKey<Level> secondDimension, Function<ServerLevel, ITeleporter> customPortalForcer) {
        return PortalTrackProvider.fromProbe(level, inboundTrack, firstDimension, secondDimension, (otherLevel, probe) -> {
            ITeleporter teleporter = (ITeleporter)customPortalForcer.apply((ServerLevel)otherLevel);
            return teleporter.getPortalInfo((Entity)probe, otherLevel, probe::m_7937_);
        });
    }

    public static PortalTrackProvider.Exit fromProbe(ServerLevel level, BlockFace inboundTrack, ResourceKey<Level> firstDimension, ResourceKey<Level> secondDimension, BiFunction<ServerLevel, SuperGlueEntity, PortalInfo> portalInfoProvider) {
        ResourceKey<Level> resourceKey = level.m_46472_() == secondDimension ? firstDimension : secondDimension;
        MinecraftServer minecraftServer = level.m_7654_();
        ServerLevel otherLevel = minecraftServer.m_129880_(resourceKey);
        if (otherLevel == null) {
            return null;
        }
        BlockPos portalPos = inboundTrack.getConnectedPos();
        BlockState portalState = level.m_8055_(portalPos);
        SuperGlueEntity probe = new SuperGlueEntity((Level)level, new AABB(portalPos));
        probe.m_146922_(inboundTrack.getFace().m_122435_());
        probe.setPortalEntrancePos();
        PortalInfo portalInfo = portalInfoProvider.apply(otherLevel, probe);
        if (portalInfo == null) {
            return null;
        }
        BlockPos otherPortalPos = BlockPos.m_274446_((Position)portalInfo.f_77676_);
        BlockState otherPortalState = otherLevel.m_8055_(otherPortalPos);
        if (!otherPortalState.m_60713_(portalState.m_60734_())) {
            return null;
        }
        Direction targetDirection = inboundTrack.getFace();
        if (targetDirection.m_122434_() == otherPortalState.m_61143_((Property)BlockStateProperties.f_61364_)) {
            targetDirection = targetDirection.m_122427_();
        }
        BlockPos otherPos = otherPortalPos.m_121945_(targetDirection);
        return new PortalTrackProvider.Exit(otherLevel, new BlockFace(otherPos, targetDirection.m_122424_()));
    }
}

