/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.track;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.trains.graph.EdgePointType;
import com.simibubi.create.content.trains.signal.TrackEdgePoint;
import com.simibubi.create.content.trains.track.BezierTrackPointLocation;
import com.simibubi.create.content.trains.track.TrackBlockEntity;
import com.simibubi.create.content.trains.track.TrackTargetingBlockItem;
import com.simibubi.create.foundation.networking.BlockEntityConfigurationPacket;
import com.simibubi.create.foundation.utility.CreateLang;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.mutable.MutableObject;

public class CurvedTrackSelectionPacket
extends BlockEntityConfigurationPacket<TrackBlockEntity> {
    private BlockPos targetPos;
    private boolean front;
    private int segment;
    private int slot;

    public CurvedTrackSelectionPacket(BlockPos pos, BlockPos targetPos, int segment, boolean front, int slot) {
        super(pos);
        this.targetPos = targetPos;
        this.segment = segment;
        this.front = front;
        this.slot = slot;
    }

    public CurvedTrackSelectionPacket(FriendlyByteBuf buffer) {
        super(buffer);
    }

    @Override
    protected void writeSettings(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.targetPos);
        buffer.m_130130_(this.segment);
        buffer.writeBoolean(this.front);
        buffer.m_130130_(this.slot);
    }

    @Override
    protected void readSettings(FriendlyByteBuf buffer) {
        this.targetPos = buffer.m_130135_();
        this.segment = buffer.m_130242_();
        this.front = buffer.readBoolean();
        this.slot = buffer.m_130242_();
    }

    @Override
    protected void applySettings(ServerPlayer player, TrackBlockEntity be) {
        if (player.m_150109_().f_35977_ != this.slot) {
            return;
        }
        ItemStack stack = player.m_150109_().m_8020_(this.slot);
        if (!(stack.m_41720_() instanceof TrackTargetingBlockItem)) {
            return;
        }
        if (player.m_6144_() && stack.m_41782_()) {
            player.m_5661_((Component)CreateLang.translateDirect("track_target.clear", new Object[0]), true);
            stack.m_41751_(null);
            AllSoundEvents.CONTROLLER_CLICK.play(player.m_9236_(), null, (Vec3i)this.pos, 1.0f, 0.5f);
            return;
        }
        EdgePointType<TrackEdgePoint> type = AllBlocks.TRACK_SIGNAL.isIn(stack) ? EdgePointType.SIGNAL : EdgePointType.STATION;
        MutableObject result = new MutableObject(null);
        TrackTargetingBlockItem.withGraphLocation(player.m_9236_(), this.pos, this.front, new BezierTrackPointLocation(this.targetPos, this.segment), type, (overlap, location) -> result.setValue((Object)overlap));
        if (((TrackTargetingBlockItem.OverlapResult)((Object)result.getValue())).feedback != null) {
            player.m_5661_((Component)CreateLang.translateDirect(((TrackTargetingBlockItem.OverlapResult)((Object)result.getValue())).feedback, new Object[0]).m_130940_(ChatFormatting.RED), true);
            AllSoundEvents.DENY.play(player.m_9236_(), null, (Vec3i)this.pos, 0.5f, 1.0f);
            return;
        }
        CompoundTag stackTag = stack.m_41784_();
        stackTag.m_128365_("SelectedPos", (Tag)NbtUtils.m_129224_((BlockPos)this.pos));
        stackTag.m_128379_("SelectedDirection", this.front);
        CompoundTag bezierNbt = new CompoundTag();
        bezierNbt.m_128405_("Segment", this.segment);
        bezierNbt.m_128365_("Key", (Tag)NbtUtils.m_129224_((BlockPos)this.targetPos));
        bezierNbt.m_128379_("FromStack", true);
        stackTag.m_128365_("Bezier", (Tag)bezierNbt);
        player.m_5661_((Component)CreateLang.translateDirect("track_target.set", new Object[0]), true);
        stack.m_41751_(stackTag);
        AllSoundEvents.CONTROLLER_CLICK.play(player.m_9236_(), null, (Vec3i)this.pos, 1.0f, 1.0f);
    }

    @Override
    protected int maxRange() {
        return 64;
    }

    @Override
    protected void applySettings(TrackBlockEntity be) {
    }
}

